/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import com.mojang.util.UndashedUuid;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import net.minecraft.SystemUtils;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;

public final class UUIDUtil {
    public static final Codec<UUID> CODEC = Codec.INT_STREAM.comapFlatMap(var0 -> SystemUtils.fixedSize(var0, 4).map(UUIDUtil::uuidFromIntArray), var0 -> Arrays.stream(UUIDUtil.uuidToIntArray(var0)));
    public static final Codec<Set<UUID>> CODEC_SET = Codec.list(CODEC).xmap(Sets::newHashSet, Lists::newArrayList);
    public static final Codec<Set<UUID>> CODEC_LINKED_SET = Codec.list(CODEC).xmap(Sets::newLinkedHashSet, Lists::newArrayList);
    public static final Codec<UUID> STRING_CODEC = Codec.STRING.comapFlatMap(var0 -> {
        try {
            return DataResult.success((Object)UUID.fromString(var0), (Lifecycle)Lifecycle.stable());
        }
        catch (IllegalArgumentException var1) {
            return DataResult.error(() -> "Invalid UUID " + var0 + ": " + var1.getMessage());
        }
    }, UUID::toString);
    public static final Codec<UUID> AUTHLIB_CODEC = Codec.withAlternative((Codec)Codec.STRING.comapFlatMap(var0 -> {
        try {
            return DataResult.success((Object)UndashedUuid.fromStringLenient((String)var0), (Lifecycle)Lifecycle.stable());
        }
        catch (IllegalArgumentException var1) {
            return DataResult.error(() -> "Invalid UUID " + var0 + ": " + var1.getMessage());
        }
    }, UndashedUuid::toString), CODEC);
    public static final Codec<UUID> LENIENT_CODEC = Codec.withAlternative(CODEC, STRING_CODEC);
    public static final StreamCodec<ByteBuf, UUID> STREAM_CODEC = new StreamCodec<ByteBuf, UUID>(){

        @Override
        public UUID decode(ByteBuf var0) {
            return PacketDataSerializer.readUUID(var0);
        }

        @Override
        public void encode(ByteBuf var0, UUID var1) {
            PacketDataSerializer.writeUUID(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (UUID)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final int UUID_BYTES = 16;
    private static final String UUID_PREFIX_OFFLINE_PLAYER = "OfflinePlayer:";

    private UUIDUtil() {
    }

    public static UUID uuidFromIntArray(int[] var0) {
        return new UUID((long)var0[0] << 32 | (long)var0[1] & 0xFFFFFFFFL, (long)var0[2] << 32 | (long)var0[3] & 0xFFFFFFFFL);
    }

    public static int[] uuidToIntArray(UUID var0) {
        long var1 = var0.getMostSignificantBits();
        long var3 = var0.getLeastSignificantBits();
        return UUIDUtil.leastMostToIntArray(var1, var3);
    }

    private static int[] leastMostToIntArray(long var0, long var2) {
        return new int[]{(int)(var0 >> 32), (int)var0, (int)(var2 >> 32), (int)var2};
    }

    public static byte[] uuidToByteArray(UUID var0) {
        byte[] var1 = new byte[16];
        ByteBuffer.wrap(var1).order(ByteOrder.BIG_ENDIAN).putLong(var0.getMostSignificantBits()).putLong(var0.getLeastSignificantBits());
        return var1;
    }

    public static UUID readUUID(Dynamic<?> var0) {
        int[] var1 = var0.asIntStream().toArray();
        if (var1.length != 4) {
            throw new IllegalArgumentException("Could not read UUID. Expected int-array of length 4, got " + var1.length + ".");
        }
        return UUIDUtil.uuidFromIntArray(var1);
    }

    public static UUID createOfflinePlayerUUID(String var0) {
        return UUID.nameUUIDFromBytes((UUID_PREFIX_OFFLINE_PLAYER + var0).getBytes(StandardCharsets.UTF_8));
    }

    public static GameProfile createOfflineProfile(String var0) {
        UUID var1 = UUIDUtil.createOfflinePlayerUUID(var0);
        return new GameProfile(var1, var0);
    }
}

