/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.SnbtGrammar;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Dictionary;
import net.minecraft.util.parsing.packrat.NamedRule;
import net.minecraft.util.parsing.packrat.Term;
import net.minecraft.util.parsing.packrat.commands.Grammar;
import net.minecraft.util.parsing.packrat.commands.ResourceLocationParseRule;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ResourceOrIdArgument<T>
implements ArgumentType<Holder<T>> {
    private static final Collection<String> EXAMPLES = List.of("foo", "foo:bar", "012", "{}", "true");
    public static final DynamicCommandExceptionType ERROR_FAILED_TO_PARSE = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("argument.resource_or_id.failed_to_parse", var0));
    public static final Dynamic2CommandExceptionType ERROR_NO_SUCH_ELEMENT = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatableEscape("argument.resource_or_id.no_such_element", var0, var1));
    public static final DynamicOps<NBTBase> OPS = DynamicOpsNBT.INSTANCE;
    private final HolderLookup.a registryLookup;
    private final Optional<? extends HolderLookup.b<T>> elementLookup;
    private final Codec<T> codec;
    private final Grammar<g<T, NBTBase>> grammar;
    private final ResourceKey<? extends IRegistry<T>> registryKey;

    protected ResourceOrIdArgument(CommandBuildContext var0, ResourceKey<? extends IRegistry<T>> var1, Codec<T> var2) {
        this.registryLookup = var0;
        this.elementLookup = var0.lookup(var1);
        this.registryKey = var1;
        this.codec = var2;
        this.grammar = ResourceOrIdArgument.createGrammar(var1, OPS);
    }

    public static <T, O> Grammar<g<T, O>> createGrammar(ResourceKey<? extends IRegistry<T>> var0, DynamicOps<O> var1) {
        Grammar<O> var2 = SnbtGrammar.createParser(var1);
        Dictionary<StringReader> var32 = new Dictionary<StringReader>();
        Atom var4 = Atom.of("result");
        Atom var5 = Atom.of("id");
        Atom var6 = Atom.of("value");
        var32.put(var5, ResourceLocationParseRule.INSTANCE);
        var32.put(var6, var2.top().value());
        NamedRule var7 = var32.put(var4, Term.alternative(var32.named(var5), var32.named(var6)), var3 -> {
            MinecraftKey var4 = (MinecraftKey)var3.get(var5);
            if (var4 != null) {
                return new f(ResourceKey.create(var0, var4));
            }
            Object var5 = var3.getOrThrow(var6);
            return new b(var5);
        });
        return new Grammar<g<T, O>>(var32, var7);
    }

    public static e lootTable(CommandBuildContext var0) {
        return new e(var0);
    }

    public static Holder<LootTable> getLootTable(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ResourceOrIdArgument.getResource(var0, var1);
    }

    public static c lootModifier(CommandBuildContext var0) {
        return new c(var0);
    }

    public static Holder<LootItemFunction> getLootModifier(CommandContext<CommandListenerWrapper> var0, String var1) {
        return ResourceOrIdArgument.getResource(var0, var1);
    }

    public static d lootPredicate(CommandBuildContext var0) {
        return new d(var0);
    }

    public static Holder<LootItemCondition> getLootPredicate(CommandContext<CommandListenerWrapper> var0, String var1) {
        return ResourceOrIdArgument.getResource(var0, var1);
    }

    public static a dialog(CommandBuildContext var0) {
        return new a(var0);
    }

    public static Holder<Dialog> getDialog(CommandContext<CommandListenerWrapper> var0, String var1) {
        return ResourceOrIdArgument.getResource(var0, var1);
    }

    private static <T> Holder<T> getResource(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (Holder)var0.getArgument(var1, Holder.class);
    }

    @Nullable
    public Holder<T> parse(StringReader var0) throws CommandSyntaxException {
        return this.parse(var0, this.grammar, OPS);
    }

    @Nullable
    private <O> Holder<T> parse(StringReader var0, Grammar<g<T, O>> var1, DynamicOps<O> var2) throws CommandSyntaxException {
        g<T, O> var3 = var1.parseForCommands(var0);
        if (this.elementLookup.isEmpty()) {
            return null;
        }
        return var3.parse((ImmutableStringReader)var0, this.registryLookup, var2, this.codec, this.elementLookup.get());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        return ICompletionProvider.listSuggestions(var0, var1, this.registryKey, ICompletionProvider.a.ELEMENTS);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    @Nullable
    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static class e
    extends ResourceOrIdArgument<LootTable> {
        protected e(CommandBuildContext var0) {
            super(var0, Registries.LOOT_TABLE, LootTable.DIRECT_CODEC);
        }

        @Override
        @Nullable
        public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
            return super.parse(stringReader);
        }
    }

    public static class c
    extends ResourceOrIdArgument<LootItemFunction> {
        protected c(CommandBuildContext var0) {
            super(var0, Registries.ITEM_MODIFIER, LootItemFunctions.ROOT_CODEC);
        }

        @Override
        @Nullable
        public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
            return super.parse(stringReader);
        }
    }

    public static class d
    extends ResourceOrIdArgument<LootItemCondition> {
        protected d(CommandBuildContext var0) {
            super(var0, Registries.PREDICATE, LootItemCondition.DIRECT_CODEC);
        }

        @Override
        @Nullable
        public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
            return super.parse(stringReader);
        }
    }

    public static class a
    extends ResourceOrIdArgument<Dialog> {
        protected a(CommandBuildContext var0) {
            super(var0, Registries.DIALOG, Dialog.DIRECT_CODEC);
        }

        @Override
        @Nullable
        public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
            return super.parse(stringReader);
        }
    }

    public static sealed interface g<T, O>
    permits b, f {
        public Holder<T> parse(ImmutableStringReader var1, HolderLookup.a var2, DynamicOps<O> var3, Codec<T> var4, HolderLookup.b<T> var5) throws CommandSyntaxException;
    }

    public record f<T, O>(ResourceKey<T> key) implements g<T, O>
    {
        @Override
        public Holder<T> parse(ImmutableStringReader var0, HolderLookup.a var1, DynamicOps<O> var2, Codec<T> var3, HolderLookup.b<T> var4) throws CommandSyntaxException {
            return var4.get(this.key).orElseThrow(() -> ERROR_NO_SUCH_ELEMENT.createWithContext(var0, (Object)this.key.location(), (Object)this.key.registry()));
        }
    }

    public record b<T, O>(O value) implements g<T, O>
    {
        @Override
        public Holder<T> parse(ImmutableStringReader var0, HolderLookup.a var12, DynamicOps<O> var2, Codec<T> var3, HolderLookup.b<T> var4) throws CommandSyntaxException {
            return Holder.direct(var3.parse(var12.createSerializationContext(var2), this.value).getOrThrow(var1 -> ERROR_FAILED_TO_PARSE.createWithContext(var0, var1)));
        }
    }
}

