/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import net.minecraft.SystemUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.FileNameDateFormatter;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import org.slf4j.Logger;

public class WorldNBTStorage {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final File playerDir;
    protected final DataFixer fixerUpper;
    private static final DateTimeFormatter FORMATTER = FileNameDateFormatter.create();

    public WorldNBTStorage(Convertable.ConversionSession var0, DataFixer var1) {
        this.fixerUpper = var1;
        this.playerDir = var0.getLevelPath(SavedFile.PLAYER_DATA_DIR).toFile();
        this.playerDir.mkdirs();
    }

    public void save(EntityHuman var0) {
        try (ProblemReporter.j var1 = new ProblemReporter.j(var0.problemPath(), LOGGER);){
            TagValueOutput var2 = TagValueOutput.createWithContext(var1, var0.registryAccess());
            var0.saveWithoutId(var2);
            Path var3 = this.playerDir.toPath();
            Path var4 = Files.createTempFile(var3, var0.getStringUUID() + "-", ".dat", new FileAttribute[0]);
            NBTTagCompound var5 = var2.buildResult();
            NBTCompressedStreamTools.writeCompressed(var5, var4);
            Path var6 = var3.resolve(var0.getStringUUID() + ".dat");
            Path var7 = var3.resolve(var0.getStringUUID() + ".dat_old");
            SystemUtils.safeReplaceFile(var6, var4, var7);
        }
        catch (Exception var12) {
            LOGGER.warn("Failed to save player data for {}", (Object)var0.getName().getString());
        }
    }

    private void backup(EntityHuman var0, String var1) {
        Path var2 = this.playerDir.toPath();
        Path var3 = var2.resolve(var0.getStringUUID() + var1);
        Path var4 = var2.resolve(var0.getStringUUID() + "_corrupted_" + LocalDateTime.now().format(FORMATTER) + var1);
        if (!Files.isRegularFile(var3, new LinkOption[0])) {
            return;
        }
        try {
            Files.copy(var3, var4, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (Exception var5) {
            LOGGER.warn("Failed to copy the player.dat file for {}", (Object)var0.getName().getString(), (Object)var5);
        }
    }

    private Optional<NBTTagCompound> load(EntityHuman var0, String var1) {
        File var2 = new File(this.playerDir, var0.getStringUUID() + var1);
        if (var2.exists() && var2.isFile()) {
            try {
                return Optional.of(NBTCompressedStreamTools.readCompressed(var2.toPath(), NBTReadLimiter.unlimitedHeap()));
            }
            catch (Exception var3) {
                LOGGER.warn("Failed to load player data for {}", (Object)var0.getName().getString());
            }
        }
        return Optional.empty();
    }

    public Optional<ValueInput> load(EntityHuman var0, ProblemReporter var1) {
        Optional<NBTTagCompound> var22 = this.load(var0, ".dat");
        if (var22.isEmpty()) {
            this.backup(var0, ".dat");
        }
        return var22.or(() -> this.load(var0, ".dat_old")).map(var2 -> {
            int var3 = GameProfileSerializer.getDataVersion(var2, -1);
            var2 = DataFixTypes.PLAYER.updateToCurrentVersion(this.fixerUpper, (NBTTagCompound)var2, var3);
            ValueInput var4 = TagValueInput.create(var1, (HolderLookup.a)var0.registryAccess(), var2);
            var0.load(var4);
            return var4;
        });
    }
}

