/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.protocol.common.custom.RedstoneWireOrientationsDebugPayload;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockRedstoneWire;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyRedstoneSide;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.redstone.RedstoneWireEvaluator;

public class ExperimentalRedstoneWireEvaluator
extends RedstoneWireEvaluator {
    private final Deque<BlockPosition> wiresToTurnOff = new ArrayDeque<BlockPosition>();
    private final Deque<BlockPosition> wiresToTurnOn = new ArrayDeque<BlockPosition>();
    private final Object2IntMap<BlockPosition> updatedWires = new Object2IntLinkedOpenHashMap();

    public ExperimentalRedstoneWireEvaluator(BlockRedstoneWire var0) {
        super(var0);
    }

    @Override
    public void updatePowerStrength(World var0, BlockPosition var1, IBlockData var2, @Nullable Orientation var3, boolean var4) {
        Orientation var5 = ExperimentalRedstoneWireEvaluator.getInitialOrientation(var0, var3);
        this.calculateCurrentChanges(var0, var1, var5);
        ObjectIterator var6 = this.updatedWires.object2IntEntrySet().iterator();
        boolean var7 = true;
        while (var6.hasNext()) {
            Object2IntMap.Entry var8 = (Object2IntMap.Entry)var6.next();
            BlockPosition var9 = (BlockPosition)var8.getKey();
            int var10 = var8.getIntValue();
            int var11 = ExperimentalRedstoneWireEvaluator.unpackPower(var10);
            IBlockData var12 = var0.getBlockState(var9);
            if (var12.is(this.wireBlock) && !var12.getValue(BlockRedstoneWire.POWER).equals(var11)) {
                int var13 = 2;
                if (!var4 || !var7) {
                    var13 |= 0x80;
                }
                var0.setBlock(var9, (IBlockData)var12.setValue(BlockRedstoneWire.POWER, var11), var13);
            } else {
                var6.remove();
            }
            var7 = false;
        }
        this.causeNeighborUpdates(var0);
    }

    private void causeNeighborUpdates(World var0) {
        this.updatedWires.forEach((var1, var2) -> {
            Orientation var3 = ExperimentalRedstoneWireEvaluator.unpackOrientation(var2);
            IBlockData var4 = var0.getBlockState((BlockPosition)var1);
            for (EnumDirection var6 : var3.getDirections()) {
                if (!ExperimentalRedstoneWireEvaluator.isConnected(var4, var6)) continue;
                BlockPosition var7 = var1.relative(var6);
                IBlockData var8 = var0.getBlockState(var7);
                Orientation var9 = var3.withFrontPreserveUp(var6);
                var0.neighborChanged(var8, var7, this.wireBlock, var9, false);
                if (!var8.isRedstoneConductor(var0, var7)) continue;
                for (EnumDirection var11 : var9.getDirections()) {
                    if (var11 == var6.getOpposite()) continue;
                    var0.neighborChanged(var7.relative(var11), this.wireBlock, var9.withFrontPreserveUp(var11));
                }
            }
        });
    }

    private static boolean isConnected(IBlockData var0, EnumDirection var1) {
        BlockStateEnum<BlockPropertyRedstoneSide> var2 = BlockRedstoneWire.PROPERTY_BY_DIRECTION.get(var1);
        if (var2 == null) {
            return var1 == EnumDirection.DOWN;
        }
        return var0.getValue(var2).isConnected();
    }

    private static Orientation getInitialOrientation(World var0, @Nullable Orientation var1) {
        Orientation var2 = var1 != null ? var1 : Orientation.random(var0.random);
        return var2.withUp(EnumDirection.UP).withSideBias(Orientation.a.LEFT);
    }

    private void calculateCurrentChanges(World var0, BlockPosition var1, Orientation var2) {
        int var9;
        int var8;
        int var7;
        int var5;
        BlockPosition var4;
        IBlockData var3 = var0.getBlockState(var1);
        if (var3.is(this.wireBlock)) {
            this.setPower(var1, var3.getValue(BlockRedstoneWire.POWER), var2);
            this.wiresToTurnOff.add(var1);
        } else {
            this.propagateChangeToNeighbors(var0, var1, 0, var2, true);
        }
        while (!this.wiresToTurnOff.isEmpty()) {
            int var11;
            var4 = this.wiresToTurnOff.removeFirst();
            var5 = this.updatedWires.getInt((Object)var4);
            Orientation var6 = ExperimentalRedstoneWireEvaluator.unpackOrientation(var5);
            var7 = ExperimentalRedstoneWireEvaluator.unpackPower(var5);
            var8 = this.getBlockSignal(var0, var4);
            int var10 = Math.max(var8, var9 = this.getIncomingWireSignal(var0, var4));
            if (var10 < var7) {
                if (var8 > 0 && !this.wiresToTurnOn.contains(var4)) {
                    this.wiresToTurnOn.add(var4);
                }
                var11 = 0;
            } else {
                var11 = var10;
            }
            if (var11 != var7) {
                this.setPower(var4, var11, var6);
            }
            this.propagateChangeToNeighbors(var0, var4, var11, var6, var7 > var10);
        }
        while (!this.wiresToTurnOn.isEmpty()) {
            var4 = this.wiresToTurnOn.removeFirst();
            var5 = this.updatedWires.getInt((Object)var4);
            int var6 = ExperimentalRedstoneWireEvaluator.unpackPower(var5);
            var7 = this.getBlockSignal(var0, var4);
            var8 = this.getIncomingWireSignal(var0, var4);
            var9 = Math.max(var7, var8);
            Orientation var10 = ExperimentalRedstoneWireEvaluator.unpackOrientation(var5);
            if (var9 > var6) {
                this.setPower(var4, var9, var10);
            } else if (var9 < var6) {
                throw new IllegalStateException("Turning off wire while trying to turn it on. Should not happen.");
            }
            this.propagateChangeToNeighbors(var0, var4, var9, var10, false);
        }
    }

    private static int packOrientationAndPower(Orientation var0, int var1) {
        return var0.getIndex() << 4 | var1;
    }

    private static Orientation unpackOrientation(int var0) {
        return Orientation.fromIndex(var0 >> 4);
    }

    private static int unpackPower(int var0) {
        return var0 & 0xF;
    }

    private void setPower(BlockPosition var0, int var1, Orientation var22) {
        this.updatedWires.compute((Object)var0, (var2, var3) -> {
            if (var3 == null) {
                return ExperimentalRedstoneWireEvaluator.packOrientationAndPower(var22, var1);
            }
            return ExperimentalRedstoneWireEvaluator.packOrientationAndPower(ExperimentalRedstoneWireEvaluator.unpackOrientation(var3), var1);
        });
    }

    private void propagateChangeToNeighbors(World var0, BlockPosition var1, int var2, Orientation var3, boolean var4) {
        BlockPosition var7;
        for (EnumDirection var6 : var3.getHorizontalDirections()) {
            var7 = var1.relative(var6);
            this.enqueueNeighborWire(var0, var7, var2, var3.withFront(var6), var4);
        }
        for (EnumDirection var6 : var3.getVerticalDirections()) {
            var7 = var1.relative(var6);
            boolean var8 = var0.getBlockState(var7).isRedstoneConductor(var0, var7);
            for (EnumDirection var10 : var3.getHorizontalDirections()) {
                BlockPosition var12;
                BlockPosition var11 = var1.relative(var10);
                if (var6 == EnumDirection.UP && !var8) {
                    var12 = var7.relative(var10);
                    this.enqueueNeighborWire(var0, var12, var2, var3.withFront(var10), var4);
                    continue;
                }
                if (var6 != EnumDirection.DOWN || var0.getBlockState(var11).isRedstoneConductor(var0, var11)) continue;
                var12 = var7.relative(var10);
                this.enqueueNeighborWire(var0, var12, var2, var3.withFront(var10), var4);
            }
        }
    }

    private void enqueueNeighborWire(World var0, BlockPosition var1, int var2, Orientation var3, boolean var4) {
        IBlockData var5 = var0.getBlockState(var1);
        if (var5.is(this.wireBlock)) {
            int var6 = this.getWireSignal(var1, var5);
            if (var6 < var2 - 1 && !this.wiresToTurnOn.contains(var1)) {
                this.wiresToTurnOn.add(var1);
                this.setPower(var1, var6, var3);
            }
            if (var4 && var6 > var2 && !this.wiresToTurnOff.contains(var1)) {
                this.wiresToTurnOff.add(var1);
                this.setPower(var1, var6, var3);
            }
        }
    }

    @Override
    protected int getWireSignal(BlockPosition var0, IBlockData var1) {
        int var2 = this.updatedWires.getOrDefault((Object)var0, -1);
        if (var2 != -1) {
            return ExperimentalRedstoneWireEvaluator.unpackPower(var2);
        }
        return super.getWireSignal(var0, var1);
    }

    private static /* synthetic */ void a(List var0, BlockPosition var1, Integer var2) {
        Orientation var3 = ExperimentalRedstoneWireEvaluator.unpackOrientation(var2);
        var0.add(new RedstoneWireOrientationsDebugPayload.a(var1, var3));
    }
}

