/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.Lists;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class WorldGenFeaturePillagerOutpostPoolPiece
extends StructurePiece {
    protected final WorldGenFeatureDefinedStructurePoolStructure element;
    protected BlockPosition position;
    private final int groundLevelDelta;
    protected final EnumBlockRotation rotation;
    private final List<WorldGenFeatureDefinedStructureJigsawJunction> junctions = Lists.newArrayList();
    private final StructureTemplateManager structureTemplateManager;
    private final LiquidSettings liquidSettings;

    public WorldGenFeaturePillagerOutpostPoolPiece(StructureTemplateManager var0, WorldGenFeatureDefinedStructurePoolStructure var1, BlockPosition var2, int var3, EnumBlockRotation var4, StructureBoundingBox var5, LiquidSettings var6) {
        super(WorldGenFeatureStructurePieceType.JIGSAW, 0, var5);
        this.structureTemplateManager = var0;
        this.element = var1;
        this.position = var2;
        this.groundLevelDelta = var3;
        this.rotation = var4;
        this.liquidSettings = var6;
    }

    public WorldGenFeaturePillagerOutpostPoolPiece(StructurePieceSerializationContext var0, NBTTagCompound var12) {
        super(WorldGenFeatureStructurePieceType.JIGSAW, var12);
        this.structureTemplateManager = var0.structureTemplateManager();
        this.position = new BlockPosition(var12.getIntOr("PosX", 0), var12.getIntOr("PosY", 0), var12.getIntOr("PosZ", 0));
        this.groundLevelDelta = var12.getIntOr("ground_level_delta", 0);
        RegistryOps<NBTBase> var2 = var0.registryAccess().createSerializationContext(DynamicOpsNBT.INSTANCE);
        this.element = var12.read("pool_element", WorldGenFeatureDefinedStructurePoolStructure.CODEC, var2).orElseThrow(() -> new IllegalStateException("Invalid pool element found"));
        this.rotation = var12.read("rotation", EnumBlockRotation.LEGACY_CODEC).orElseThrow();
        this.boundingBox = this.element.getBoundingBox(this.structureTemplateManager, this.position, this.rotation);
        NBTTagList var3 = var12.getListOrEmpty("junctions");
        this.junctions.clear();
        var3.forEach(var1 -> this.junctions.add(WorldGenFeatureDefinedStructureJigsawJunction.deserialize(new Dynamic(var2, var1))));
        this.liquidSettings = var12.read("liquid_settings", LiquidSettings.CODEC).orElse(JigsawStructure.DEFAULT_LIQUID_SETTINGS);
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
        var1.putInt("PosX", this.position.getX());
        var1.putInt("PosY", this.position.getY());
        var1.putInt("PosZ", this.position.getZ());
        var1.putInt("ground_level_delta", this.groundLevelDelta);
        RegistryOps<NBTBase> var2 = var0.registryAccess().createSerializationContext(DynamicOpsNBT.INSTANCE);
        var1.store("pool_element", WorldGenFeatureDefinedStructurePoolStructure.CODEC, var2, this.element);
        var1.store("rotation", EnumBlockRotation.LEGACY_CODEC, this.rotation);
        NBTTagList var3 = new NBTTagList();
        for (WorldGenFeatureDefinedStructureJigsawJunction var5 : this.junctions) {
            var3.add((NBTBase)var5.serialize(var2).getValue());
        }
        var1.put("junctions", var3);
        if (this.liquidSettings != JigsawStructure.DEFAULT_LIQUID_SETTINGS) {
            var1.store("liquid_settings", LiquidSettings.CODEC, var2, this.liquidSettings);
        }
    }

    @Override
    public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
        this.place(var0, var1, var2, var3, var4, var6, false);
    }

    public void place(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, StructureBoundingBox var4, BlockPosition var5, boolean var6) {
        this.element.place(this.structureTemplateManager, var0, var1, var2, this.position, var5, this.rotation, var4, var3, this.liquidSettings, var6);
    }

    @Override
    public void move(int var0, int var1, int var2) {
        super.move(var0, var1, var2);
        this.position = this.position.offset(var0, var1, var2);
    }

    @Override
    public EnumBlockRotation getRotation() {
        return this.rotation;
    }

    public String toString() {
        return String.format(Locale.ROOT, "<%s | %s | %s | %s>", this.getClass().getSimpleName(), this.position, this.rotation, this.element);
    }

    public WorldGenFeatureDefinedStructurePoolStructure getElement() {
        return this.element;
    }

    public BlockPosition getPosition() {
        return this.position;
    }

    public int getGroundLevelDelta() {
        return this.groundLevelDelta;
    }

    public void addJunction(WorldGenFeatureDefinedStructureJigsawJunction var0) {
        this.junctions.add(var0);
    }

    public List<WorldGenFeatureDefinedStructureJigsawJunction> getJunctions() {
        return this.junctions;
    }
}

