/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTrees;

public abstract class WorldGenFeatureTree {
    public static final Codec<WorldGenFeatureTree> CODEC = BuiltInRegistries.TREE_DECORATOR_TYPE.byNameCodec().dispatch(WorldGenFeatureTree::type, WorldGenFeatureTrees::codec);

    protected abstract WorldGenFeatureTrees<?> type();

    public abstract void place(a var1);

    public static final class a {
        private final VirtualLevelReadable level;
        private final BiConsumer<BlockPosition, IBlockData> decorationSetter;
        private final RandomSource random;
        private final ObjectArrayList<BlockPosition> logs;
        private final ObjectArrayList<BlockPosition> leaves;
        private final ObjectArrayList<BlockPosition> roots;

        public a(VirtualLevelReadable var0, BiConsumer<BlockPosition, IBlockData> var1, RandomSource var2, Set<BlockPosition> var3, Set<BlockPosition> var4, Set<BlockPosition> var5) {
            this.level = var0;
            this.decorationSetter = var1;
            this.random = var2;
            this.roots = new ObjectArrayList(var5);
            this.logs = new ObjectArrayList(var3);
            this.leaves = new ObjectArrayList(var4);
            this.logs.sort(Comparator.comparingInt(BaseBlockPosition::getY));
            this.leaves.sort(Comparator.comparingInt(BaseBlockPosition::getY));
            this.roots.sort(Comparator.comparingInt(BaseBlockPosition::getY));
        }

        public void placeVine(BlockPosition var0, BlockStateBoolean var1) {
            this.setBlock(var0, (IBlockData)Blocks.VINE.defaultBlockState().setValue(var1, true));
        }

        public void setBlock(BlockPosition var0, IBlockData var1) {
            this.decorationSetter.accept(var0, var1);
        }

        public boolean isAir(BlockPosition var0) {
            return this.level.isStateAtPosition(var0, BlockBase.BlockData::isAir);
        }

        public boolean checkBlock(BlockPosition var0, Predicate<IBlockData> var1) {
            return this.level.isStateAtPosition(var0, var1);
        }

        public VirtualLevelReadable level() {
            return this.level;
        }

        public RandomSource random() {
            return this.random;
        }

        public ObjectArrayList<BlockPosition> logs() {
            return this.logs;
        }

        public ObjectArrayList<BlockPosition> leaves() {
            return this.leaves;
        }

        public ObjectArrayList<BlockPosition> roots() {
            return this.roots;
        }
    }
}

