/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.carver;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.carver.CanyonCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.WorldGenCanyon;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.carver.WorldGenCaves;
import net.minecraft.world.level.levelgen.carver.WorldGenCavesHell;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import org.apache.commons.lang3.mutable.MutableBoolean;

public abstract class WorldGenCarverAbstract<C extends WorldGenCarverConfiguration> {
    public static final WorldGenCarverAbstract<CaveCarverConfiguration> CAVE = WorldGenCarverAbstract.register("cave", new WorldGenCaves(CaveCarverConfiguration.CODEC));
    public static final WorldGenCarverAbstract<CaveCarverConfiguration> NETHER_CAVE = WorldGenCarverAbstract.register("nether_cave", new WorldGenCavesHell(CaveCarverConfiguration.CODEC));
    public static final WorldGenCarverAbstract<CanyonCarverConfiguration> CANYON = WorldGenCarverAbstract.register("canyon", new WorldGenCanyon(CanyonCarverConfiguration.CODEC));
    protected static final IBlockData AIR = Blocks.AIR.defaultBlockState();
    protected static final IBlockData CAVE_AIR = Blocks.CAVE_AIR.defaultBlockState();
    protected static final Fluid WATER = FluidTypes.WATER.defaultFluidState();
    protected static final Fluid LAVA = FluidTypes.LAVA.defaultFluidState();
    protected Set<FluidType> liquids = ImmutableSet.of((Object)FluidTypes.WATER);
    private final MapCodec<WorldGenCarverWrapper<C>> configuredCodec;

    private static <C extends WorldGenCarverConfiguration, F extends WorldGenCarverAbstract<C>> F register(String var0, F var1) {
        return (F)IRegistry.register(BuiltInRegistries.CARVER, var0, var1);
    }

    public WorldGenCarverAbstract(Codec<C> var0) {
        this.configuredCodec = var0.fieldOf("config").xmap(this::configured, WorldGenCarverWrapper::config);
    }

    public WorldGenCarverWrapper<C> configured(C var0) {
        return new WorldGenCarverWrapper<C>(this, var0);
    }

    public MapCodec<WorldGenCarverWrapper<C>> configuredCodec() {
        return this.configuredCodec;
    }

    public int getRange() {
        return 4;
    }

    protected boolean carveEllipsoid(CarvingContext var0, C var1, IChunkAccess var2, Function<BlockPosition, Holder<BiomeBase>> var3, Aquifer var4, double var5, double var7, double var9, double var11, double var13, CarvingMask var15, a var16) {
        ChunkCoordIntPair var17 = var2.getPos();
        double var18 = var17.getMiddleBlockX();
        double var20 = var17.getMiddleBlockZ();
        double var22 = 16.0 + var11 * 2.0;
        if (Math.abs(var5 - var18) > var22 || Math.abs(var9 - var20) > var22) {
            return false;
        }
        int var24 = var17.getMinBlockX();
        int var25 = var17.getMinBlockZ();
        int var26 = Math.max(MathHelper.floor(var5 - var11) - var24 - 1, 0);
        int var27 = Math.min(MathHelper.floor(var5 + var11) - var24, 15);
        int var28 = Math.max(MathHelper.floor(var7 - var13) - 1, var0.getMinGenY() + 1);
        int var29 = var2.isUpgrading() ? 0 : 7;
        int var30 = Math.min(MathHelper.floor(var7 + var13) + 1, var0.getMinGenY() + var0.getGenDepth() - 1 - var29);
        int var31 = Math.max(MathHelper.floor(var9 - var11) - var25 - 1, 0);
        int var32 = Math.min(MathHelper.floor(var9 + var11) - var25, 15);
        boolean var33 = false;
        BlockPosition.MutableBlockPosition var34 = new BlockPosition.MutableBlockPosition();
        BlockPosition.MutableBlockPosition var35 = new BlockPosition.MutableBlockPosition();
        for (int var36 = var26; var36 <= var27; ++var36) {
            int var37 = var17.getBlockX(var36);
            double var38 = ((double)var37 + 0.5 - var5) / var11;
            for (int var40 = var31; var40 <= var32; ++var40) {
                int var41 = var17.getBlockZ(var40);
                double var42 = ((double)var41 + 0.5 - var9) / var11;
                if (var38 * var38 + var42 * var42 >= 1.0) continue;
                MutableBoolean var44 = new MutableBoolean(false);
                for (int var45 = var30; var45 > var28; --var45) {
                    double var46 = ((double)var45 - 0.5 - var7) / var13;
                    if (var16.shouldSkip(var0, var38, var46, var42, var45) || var15.get(var36, var45, var40) && !WorldGenCarverAbstract.isDebugEnabled(var1)) continue;
                    var15.set(var36, var45, var40);
                    var34.set(var37, var45, var41);
                    var33 |= this.carveBlock(var0, var1, var2, var3, var15, var34, var35, var4, var44);
                }
            }
        }
        return var33;
    }

    protected boolean carveBlock(CarvingContext var0, C var1, IChunkAccess var22, Function<BlockPosition, Holder<BiomeBase>> var3, CarvingMask var4, BlockPosition.MutableBlockPosition var5, BlockPosition.MutableBlockPosition var6, Aquifer var7, MutableBoolean var8) {
        IBlockData var9 = var22.getBlockState(var5);
        if (var9.is(Blocks.GRASS_BLOCK) || var9.is(Blocks.MYCELIUM)) {
            var8.setTrue();
        }
        if (!this.canReplaceBlock(var1, var9) && !WorldGenCarverAbstract.isDebugEnabled(var1)) {
            return false;
        }
        IBlockData var10 = this.getCarveState(var0, var1, var5, var7);
        if (var10 == null) {
            return false;
        }
        var22.setBlockState(var5, var10);
        if (var7.shouldScheduleFluidUpdate() && !var10.getFluidState().isEmpty()) {
            var22.markPosForPostprocessing(var5);
        }
        if (var8.isTrue()) {
            var6.setWithOffset((BaseBlockPosition)var5, EnumDirection.DOWN);
            if (var22.getBlockState(var6).is(Blocks.DIRT)) {
                var0.topMaterial(var3, var22, var6, !var10.getFluidState().isEmpty()).ifPresent(var2 -> {
                    var22.setBlockState(var6, (IBlockData)var2);
                    if (!var2.getFluidState().isEmpty()) {
                        var22.markPosForPostprocessing(var6);
                    }
                });
            }
        }
        return true;
    }

    @Nullable
    private IBlockData getCarveState(CarvingContext var0, C var1, BlockPosition var2, Aquifer var3) {
        if (var2.getY() <= ((WorldGenCarverConfiguration)var1).lavaLevel.resolveY(var0)) {
            return LAVA.createLegacyBlock();
        }
        IBlockData var4 = var3.computeSubstance(new DensityFunction.e(var2.getX(), var2.getY(), var2.getZ()), 0.0);
        if (var4 == null) {
            return WorldGenCarverAbstract.isDebugEnabled(var1) ? ((WorldGenCarverConfiguration)var1).debugSettings.getBarrierState() : null;
        }
        return WorldGenCarverAbstract.isDebugEnabled(var1) ? WorldGenCarverAbstract.getDebugState(var1, var4) : var4;
    }

    private static IBlockData getDebugState(WorldGenCarverConfiguration var0, IBlockData var1) {
        if (var1.is(Blocks.AIR)) {
            return var0.debugSettings.getAirState();
        }
        if (var1.is(Blocks.WATER)) {
            IBlockData var2 = var0.debugSettings.getWaterState();
            if (var2.hasProperty(BlockProperties.WATERLOGGED)) {
                return (IBlockData)var2.setValue(BlockProperties.WATERLOGGED, true);
            }
            return var2;
        }
        if (var1.is(Blocks.LAVA)) {
            return var0.debugSettings.getLavaState();
        }
        return var1;
    }

    public abstract boolean carve(CarvingContext var1, C var2, IChunkAccess var3, Function<BlockPosition, Holder<BiomeBase>> var4, RandomSource var5, Aquifer var6, ChunkCoordIntPair var7, CarvingMask var8);

    public abstract boolean isStartChunk(C var1, RandomSource var2);

    protected boolean canReplaceBlock(C var0, IBlockData var1) {
        return var1.is(((WorldGenCarverConfiguration)var0).replaceable);
    }

    protected static boolean canReach(ChunkCoordIntPair var0, double var1, double var3, int var5, int var6, float var7) {
        double var18;
        double var16;
        double var10;
        double var14;
        double var8 = var0.getMiddleBlockX();
        double var12 = var1 - var8;
        return var12 * var12 + (var14 = var3 - (var10 = (double)var0.getMiddleBlockZ())) * var14 - (var16 = (double)(var6 - var5)) * var16 <= (var18 = (double)(var7 + 2.0f + 16.0f)) * var18;
    }

    private static boolean isDebugEnabled(WorldGenCarverConfiguration var0) {
        return var0.debugSettings.isDebugMode();
    }

    public static interface a {
        public boolean shouldSkip(CarvingContext var1, double var2, double var4, double var6, int var8);
    }
}

