/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.component.Bees;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockFire;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.slf4j.Logger;

public class TileEntityBeehive
extends TileEntity {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_FLOWER_POS = "flower_pos";
    private static final String BEES = "bees";
    static final List<String> IGNORED_BEE_TAGS = Arrays.asList("Air", "drop_chances", "equipment", "Brain", "CanPickUpLoot", "DeathTime", "fall_distance", "FallFlying", "Fire", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "sleeping_pos", "CannotEnterHiveTicks", "TicksSincePollination", "CropsGrownSincePollination", "hive_pos", "Passengers", "leash", "UUID");
    public static final int MAX_OCCUPANTS = 3;
    private static final int MIN_TICKS_BEFORE_REENTERING_HIVE = 400;
    private static final int MIN_OCCUPATION_TICKS_NECTAR = 2400;
    public static final int MIN_OCCUPATION_TICKS_NECTARLESS = 600;
    private List<HiveBee> stored = Lists.newArrayList();
    @Nullable
    public BlockPosition savedFlowerPos;

    public TileEntityBeehive(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.BEEHIVE, var0, var1);
    }

    @Override
    public void setChanged() {
        if (this.isFireNearby()) {
            this.emptyAllLivingFromHive(null, this.level.getBlockState(this.getBlockPos()), ReleaseStatus.EMERGENCY);
        }
        super.setChanged();
    }

    public boolean isFireNearby() {
        if (this.level == null) {
            return false;
        }
        for (BlockPosition var1 : BlockPosition.betweenClosed(this.worldPosition.offset(-1, -1, -1), this.worldPosition.offset(1, 1, 1))) {
            if (!(this.level.getBlockState(var1).getBlock() instanceof BlockFire)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.stored.isEmpty();
    }

    public boolean isFull() {
        return this.stored.size() == 3;
    }

    public void emptyAllLivingFromHive(@Nullable EntityHuman var0, IBlockData var1, ReleaseStatus var2) {
        List<Entity> var3 = this.releaseAllOccupants(var1, var2);
        if (var0 != null) {
            for (Entity var5 : var3) {
                if (!(var5 instanceof EntityBee)) continue;
                EntityBee var6 = (EntityBee)var5;
                if (!(var0.position().distanceToSqr(var5.position()) <= 16.0)) continue;
                if (!this.isSedated()) {
                    var6.setTarget(var0);
                    continue;
                }
                var6.setStayOutOfHiveCountdown(400);
            }
        }
    }

    private List<Entity> releaseAllOccupants(IBlockData var0, ReleaseStatus var1) {
        ArrayList var2 = Lists.newArrayList();
        this.stored.removeIf(var3 -> TileEntityBeehive.releaseOccupant(this.level, this.worldPosition, var0, var3.toOccupant(), var2, var1, this.savedFlowerPos));
        if (!var2.isEmpty()) {
            super.setChanged();
        }
        return var2;
    }

    @VisibleForDebug
    public int getOccupantCount() {
        return this.stored.size();
    }

    public static int getHoneyLevel(IBlockData var0) {
        return var0.getValue(BlockBeehive.HONEY_LEVEL);
    }

    @VisibleForDebug
    public boolean isSedated() {
        return BlockCampfire.isSmokeyPos(this.level, this.getBlockPos());
    }

    public void addOccupant(EntityBee var0) {
        if (this.stored.size() >= 3) {
            return;
        }
        var0.stopRiding();
        var0.ejectPassengers();
        var0.dropLeash();
        this.storeBee(c.of(var0));
        if (this.level != null) {
            if (var0.hasSavedFlowerPos() && (!this.hasSavedFlowerPos() || this.level.random.nextBoolean())) {
                this.savedFlowerPos = var0.getSavedFlowerPos();
            }
            BlockPosition var1 = this.getBlockPos();
            this.level.playSound(null, (double)var1.getX(), (double)var1.getY(), (double)var1.getZ(), SoundEffects.BEEHIVE_ENTER, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.level.gameEvent(GameEvent.BLOCK_CHANGE, var1, GameEvent.a.of(var0, this.getBlockState()));
        }
        var0.discard();
        super.setChanged();
    }

    public void storeBee(c var0) {
        this.stored.add(new HiveBee(var0));
    }

    private static boolean releaseOccupant(World var02, BlockPosition var1, IBlockData var2, c var3, @Nullable List<Entity> var4, ReleaseStatus var5, @Nullable BlockPosition var6) {
        boolean var9;
        if (EntityBee.isNightOrRaining(var02) && var5 != ReleaseStatus.EMERGENCY) {
            return false;
        }
        EnumDirection var7 = var2.getValue(BlockBeehive.FACING);
        BlockPosition var8 = var1.relative(var7);
        boolean bl = var9 = !var02.getBlockState(var8).getCollisionShape(var02, var8).isEmpty();
        if (var9 && var5 != ReleaseStatus.EMERGENCY) {
            return false;
        }
        Entity var10 = var3.createEntity(var02, var1);
        if (var10 != null) {
            if (var10 instanceof EntityBee) {
                EntityBee var11 = (EntityBee)var10;
                if (var6 != null && !var11.hasSavedFlowerPos() && var02.random.nextFloat() < 0.9f) {
                    var11.setSavedFlowerPos(var6);
                }
                if (var5 == ReleaseStatus.HONEY_DELIVERED) {
                    int var12;
                    var11.dropOffNectar();
                    if (var2.is(TagsBlock.BEEHIVES, var0 -> var0.hasProperty(BlockBeehive.HONEY_LEVEL)) && (var12 = TileEntityBeehive.getHoneyLevel(var2)) < 5) {
                        int var13;
                        int n2 = var13 = var02.random.nextInt(100) == 0 ? 2 : 1;
                        if (var12 + var13 > 5) {
                            --var13;
                        }
                        var02.setBlockAndUpdate(var1, (IBlockData)var2.setValue(BlockBeehive.HONEY_LEVEL, var12 + var13));
                    }
                }
                if (var4 != null) {
                    var4.add(var11);
                }
                float var12 = var10.getBbWidth();
                double var13 = var9 ? 0.0 : 0.55 + (double)(var12 / 2.0f);
                double var15 = (double)var1.getX() + 0.5 + var13 * (double)var7.getStepX();
                double var17 = (double)var1.getY() + 0.5 - (double)(var10.getBbHeight() / 2.0f);
                double var19 = (double)var1.getZ() + 0.5 + var13 * (double)var7.getStepZ();
                var10.snapTo(var15, var17, var19, var10.getYRot(), var10.getXRot());
            }
            var02.playSound(null, var1, SoundEffects.BEEHIVE_EXIT, SoundCategory.BLOCKS, 1.0f, 1.0f);
            var02.gameEvent(GameEvent.BLOCK_CHANGE, var1, GameEvent.a.of(var10, var02.getBlockState(var1)));
            return var02.addFreshEntity(var10);
        }
        return false;
    }

    private boolean hasSavedFlowerPos() {
        return this.savedFlowerPos != null;
    }

    private static void tickOccupants(World var0, BlockPosition var1, IBlockData var2, List<HiveBee> var3, @Nullable BlockPosition var4) {
        boolean var5 = false;
        Iterator<HiveBee> var6 = var3.iterator();
        while (var6.hasNext()) {
            ReleaseStatus var8;
            HiveBee var7 = var6.next();
            if (!var7.tick()) continue;
            ReleaseStatus releaseStatus = var8 = var7.hasNectar() ? ReleaseStatus.HONEY_DELIVERED : ReleaseStatus.BEE_RELEASED;
            if (!TileEntityBeehive.releaseOccupant(var0, var1, var2, var7.toOccupant(), null, var8, var4)) continue;
            var5 = true;
            var6.remove();
        }
        if (var5) {
            TileEntityBeehive.setChanged(var0, var1, var2);
        }
    }

    public static void serverTick(World var0, BlockPosition var1, IBlockData var2, TileEntityBeehive var3) {
        TileEntityBeehive.tickOccupants(var0, var1, var2, var3.stored, var3.savedFlowerPos);
        if (!var3.stored.isEmpty() && var0.getRandom().nextDouble() < 0.005) {
            double var4 = (double)var1.getX() + 0.5;
            double var6 = var1.getY();
            double var8 = (double)var1.getZ() + 0.5;
            var0.playSound(null, var4, var6, var8, SoundEffects.BEEHIVE_WORK, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        PacketDebug.sendHiveInfo(var0, var1, var2, var3);
    }

    @Override
    protected void loadAdditional(ValueInput var0) {
        super.loadAdditional(var0);
        this.stored.clear();
        var0.read(BEES, c.LIST_CODEC).orElse(List.of()).forEach(this::storeBee);
        this.savedFlowerPos = var0.read(TAG_FLOWER_POS, BlockPosition.CODEC).orElse(null);
    }

    @Override
    protected void saveAdditional(ValueOutput var0) {
        super.saveAdditional(var0);
        var0.store(BEES, c.LIST_CODEC, this.getBees());
        var0.storeNullable(TAG_FLOWER_POS, BlockPosition.CODEC, this.savedFlowerPos);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter var0) {
        super.applyImplicitComponents(var0);
        this.stored.clear();
        List<c> var1 = var0.getOrDefault(DataComponents.BEES, Bees.EMPTY).bees();
        var1.forEach(this::storeBee);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.a var0) {
        super.collectImplicitComponents(var0);
        var0.set(DataComponents.BEES, new Bees(this.getBees()));
    }

    @Override
    public void removeComponentsFromTag(ValueOutput var0) {
        super.removeComponentsFromTag(var0);
        var0.discard(BEES);
    }

    private List<c> getBees() {
        return this.stored.stream().map(HiveBee::toOccupant).toList();
    }

    public static final class ReleaseStatus
    extends Enum<ReleaseStatus> {
        public static final /* enum */ ReleaseStatus HONEY_DELIVERED = new ReleaseStatus();
        public static final /* enum */ ReleaseStatus BEE_RELEASED = new ReleaseStatus();
        public static final /* enum */ ReleaseStatus EMERGENCY = new ReleaseStatus();
        private static final /* synthetic */ ReleaseStatus[] d;

        public static ReleaseStatus[] values() {
            return (ReleaseStatus[])d.clone();
        }

        public static ReleaseStatus valueOf(String var0) {
            return Enum.valueOf(ReleaseStatus.class, var0);
        }

        private static /* synthetic */ ReleaseStatus[] a() {
            return new ReleaseStatus[]{HONEY_DELIVERED, BEE_RELEASED, EMERGENCY};
        }

        static {
            d = ReleaseStatus.a();
        }
    }

    public static final class c
    extends Record {
        final CustomData entityData;
        private final int ticksInHive;
        final int minTicksInHive;
        public static final Codec<c> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)CustomData.CODEC.optionalFieldOf("entity_data", (Object)CustomData.EMPTY).forGetter(c::entityData), (App)Codec.INT.fieldOf("ticks_in_hive").forGetter(c::ticksInHive), (App)Codec.INT.fieldOf("min_ticks_in_hive").forGetter(c::minTicksInHive)).apply((Applicative)var0, c::new));
        public static final Codec<List<c>> LIST_CODEC = CODEC.listOf();
        public static final StreamCodec<ByteBuf, c> STREAM_CODEC = StreamCodec.composite(CustomData.STREAM_CODEC, c::entityData, ByteBufCodecs.VAR_INT, c::ticksInHive, ByteBufCodecs.VAR_INT, c::minTicksInHive, c::new);

        public c(CustomData var0, int var1, int var2) {
            this.entityData = var0;
            this.ticksInHive = var1;
            this.minTicksInHive = var2;
        }

        public static c of(Entity var0) {
            try (ProblemReporter.j var1 = new ProblemReporter.j(var0.problemPath(), LOGGER);){
                TagValueOutput var2 = TagValueOutput.createWithContext(var1, var0.registryAccess());
                var0.save(var2);
                IGNORED_BEE_TAGS.forEach(var2::discard);
                NBTTagCompound var3 = var2.buildResult();
                boolean var4 = var3.getBooleanOr("HasNectar", false);
                c c2 = new c(CustomData.of(var3), 0, var4 ? 2400 : 600);
                return c2;
            }
        }

        public static c create(int var0) {
            NBTTagCompound var1 = new NBTTagCompound();
            var1.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(EntityTypes.BEE).toString());
            return new c(CustomData.of(var1), var0, 600);
        }

        @Nullable
        public Entity createEntity(World var02, BlockPosition var1) {
            NBTTagCompound var2 = this.entityData.copyTag();
            IGNORED_BEE_TAGS.forEach(var2::remove);
            Entity var3 = EntityTypes.loadEntityRecursive(var2, var02, EntitySpawnReason.LOAD, var0 -> var0);
            if (var3 == null || !var3.getType().is(TagsEntity.BEEHIVE_INHABITORS)) {
                return null;
            }
            var3.setNoGravity(true);
            if (var3 instanceof EntityBee) {
                EntityBee var4 = (EntityBee)var3;
                var4.setHivePos(var1);
                c.setBeeReleaseData(this.ticksInHive, var4);
            }
            return var3;
        }

        private static void setBeeReleaseData(int var0, EntityBee var1) {
            int var2 = var1.getAge();
            if (var2 < 0) {
                var1.setAge(Math.min(0, var2 + var0));
            } else if (var2 > 0) {
                var1.setAge(Math.max(0, var2 - var0));
            }
            var1.setInLoveTime(Math.max(0, var1.getInLoveTime() - var0));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "entityData;ticksInHive;minTicksInHive", "entityData", "ticksInHive", "minTicksInHive"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "entityData;ticksInHive;minTicksInHive", "entityData", "ticksInHive", "minTicksInHive"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "entityData;ticksInHive;minTicksInHive", "entityData", "ticksInHive", "minTicksInHive"}, this, var0);
        }

        public CustomData entityData() {
            return this.entityData;
        }

        public int ticksInHive() {
            return this.ticksInHive;
        }

        public int minTicksInHive() {
            return this.minTicksInHive;
        }
    }

    static class HiveBee {
        private final c occupant;
        private int ticksInHive;

        HiveBee(c var0) {
            this.occupant = var0;
            this.ticksInHive = var0.ticksInHive();
        }

        public boolean tick() {
            return this.ticksInHive++ > this.occupant.minTicksInHive;
        }

        public c toOccupant() {
            return new c(this.occupant.entityData, this.ticksInHive, this.occupant.minTicksInHive);
        }

        public boolean hasNectar() {
            return this.occupant.entityData.getUnsafe().getBooleanOr("HasNectar", false);
        }
    }
}

