/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockSweetBerryBush
extends VegetationBlock
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockSweetBerryBush> CODEC = BlockSweetBerryBush.simpleCodec(BlockSweetBerryBush::new);
    private static final float HURT_SPEED_THRESHOLD = 0.003f;
    public static final int MAX_AGE = 3;
    public static final BlockStateInteger AGE = BlockProperties.AGE_3;
    private static final VoxelShape SHAPE_SAPLING = Block.column(10.0, 0.0, 8.0);
    private static final VoxelShape SHAPE_GROWING = Block.column(14.0, 0.0, 16.0);

    public MapCodec<BlockSweetBerryBush> codec() {
        return CODEC;
    }

    public BlockSweetBerryBush(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(AGE, 0));
    }

    @Override
    protected ItemStack getCloneItemStack(IWorldReader var0, BlockPosition var1, IBlockData var2, boolean var3) {
        return new ItemStack(Items.SWEET_BERRIES);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return switch (var0.getValue(AGE)) {
            case 0 -> SHAPE_SAPLING;
            default -> SHAPE_GROWING;
            case 3 -> VoxelShapes.block();
        };
    }

    @Override
    protected boolean isRandomlyTicking(IBlockData var0) {
        return var0.getValue(AGE) < 3;
    }

    @Override
    protected void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        int var4 = var0.getValue(AGE);
        if (var4 < 3 && var3.nextInt(5) == 0 && var1.getRawBrightness(var2.above(), 0) >= 9) {
            IBlockData var5 = (IBlockData)var0.setValue(AGE, var4 + 1);
            var1.setBlock(var2, var5, 2);
            var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.a.of(var5));
        }
    }

    @Override
    protected void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3, InsideBlockEffectApplier var4) {
        Vec3D var6;
        WorldServer var5;
        block7: {
            block6: {
                if (!(var3 instanceof EntityLiving) || var3.getType() == EntityTypes.FOX || var3.getType() == EntityTypes.BEE) {
                    return;
                }
                var3.makeStuckInBlock(var0, new Vec3D(0.8f, 0.75, 0.8f));
                if (!(var1 instanceof WorldServer)) break block6;
                var5 = (WorldServer)var1;
                if (var0.getValue(AGE) != 0) break block7;
            }
            return;
        }
        Vec3D vec3D = var6 = var3.isClientAuthoritative() ? var3.getKnownMovement() : var3.oldPosition().subtract(var3.position());
        if (var6.horizontalDistanceSqr() > 0.0) {
            double var7 = Math.abs(var6.x());
            double var9 = Math.abs(var6.z());
            if (var7 >= (double)0.003f || var9 >= (double)0.003f) {
                var3.hurtServer(var5, var1.damageSources().sweetBerryBush(), 1.0f);
            }
        }
    }

    @Override
    protected EnumInteractionResult useItemOn(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityHuman var4, EnumHand var5, MovingObjectPositionBlock var6) {
        boolean var8;
        int var7 = var1.getValue(AGE);
        boolean bl = var8 = var7 == 3;
        if (!var8 && var0.is(Items.BONE_MEAL)) {
            return EnumInteractionResult.PASS;
        }
        return super.useItemOn(var0, var1, var2, var3, var4, var5, var6);
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        boolean var6;
        int var5 = var0.getValue(AGE);
        boolean bl = var6 = var5 == 3;
        if (var5 > 1) {
            int var7 = 1 + var1.random.nextInt(2);
            BlockSweetBerryBush.popResource(var1, var2, new ItemStack(Items.SWEET_BERRIES, var7 + (var6 ? 1 : 0)));
            var1.playSound(null, var2, SoundEffects.SWEET_BERRY_BUSH_PICK_BERRIES, SoundCategory.BLOCKS, 1.0f, 0.8f + var1.random.nextFloat() * 0.4f);
            IBlockData var8 = (IBlockData)var0.setValue(AGE, 1);
            var1.setBlock(var2, var8, 2);
            var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.a.of(var3, var8));
            return EnumInteractionResult.SUCCESS;
        }
        return super.useWithoutItem(var0, var1, var2, var3, var4);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(AGE);
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return var2.getValue(AGE) < 3;
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        int var4 = Math.min(3, var3.getValue(AGE) + 1);
        var0.setBlock(var2, (IBlockData)var3.setValue(AGE, var4), 2);
    }
}

