/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Iterator;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockScaffolding
extends Block
implements IBlockWaterlogged {
    public static final MapCodec<BlockScaffolding> CODEC = BlockScaffolding.simpleCodec(BlockScaffolding::new);
    private static final int TICK_DELAY = 1;
    private static final VoxelShape SHAPE_STABLE = VoxelShapes.or(Block.column(16.0, 14.0, 16.0), VoxelShapes.rotateHorizontal(Block.box(0.0, 0.0, 0.0, 2.0, 16.0, 2.0)).values().stream().reduce(VoxelShapes.empty(), VoxelShapes::or));
    private static final VoxelShape SHAPE_UNSTABLE_BOTTOM = Block.column(16.0, 0.0, 2.0);
    private static final VoxelShape SHAPE_UNSTABLE = VoxelShapes.or(SHAPE_STABLE, SHAPE_UNSTABLE_BOTTOM, VoxelShapes.rotateHorizontal(Block.boxZ(16.0, 0.0, 2.0, 0.0, 2.0)).values().stream().reduce(VoxelShapes.empty(), VoxelShapes::or));
    private static final VoxelShape SHAPE_BELOW_BLOCK = VoxelShapes.block().move(0.0, -1.0, 0.0).optimize();
    public static final int STABILITY_MAX_DISTANCE = 7;
    public static final BlockStateInteger DISTANCE = BlockProperties.STABILITY_DISTANCE;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    public static final BlockStateBoolean BOTTOM = BlockProperties.BOTTOM;

    public MapCodec<BlockScaffolding> codec() {
        return CODEC;
    }

    protected BlockScaffolding(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(DISTANCE, 7)).setValue(WATERLOGGED, false)).setValue(BOTTOM, false));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(DISTANCE, WATERLOGGED, BOTTOM);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        if (!var3.isHoldingItem(var0.getBlock().asItem())) {
            return var0.getValue(BOTTOM) != false ? SHAPE_UNSTABLE : SHAPE_STABLE;
        }
        return VoxelShapes.block();
    }

    @Override
    protected VoxelShape getInteractionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return VoxelShapes.block();
    }

    @Override
    protected boolean canBeReplaced(IBlockData var0, BlockActionContext var1) {
        return var1.getItemInHand().is(this.asItem());
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        BlockPosition var1 = var0.getClickedPos();
        World var2 = var0.getLevel();
        int var3 = BlockScaffolding.getDistance(var2, var1);
        return (IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(WATERLOGGED, var2.getFluidState(var1).getType() == FluidTypes.WATER)).setValue(DISTANCE, var3)).setValue(BOTTOM, this.isBottom(var2, var1, var3));
    }

    @Override
    protected void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (!var1.isClientSide) {
            var1.scheduleTick(var2, this, 1);
        }
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
        }
        if (!var1.isClientSide()) {
            var2.scheduleTick(var3, this, 1);
        }
        return var0;
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        int var4 = BlockScaffolding.getDistance(var1, var2);
        IBlockData var5 = (IBlockData)((IBlockData)var0.setValue(DISTANCE, var4)).setValue(BOTTOM, this.isBottom(var1, var2, var4));
        if (var5.getValue(DISTANCE) == 7) {
            if (var0.getValue(DISTANCE) == 7) {
                EntityFallingBlock.fall(var1, var2, var5);
            } else {
                var1.destroyBlock(var2, true);
            }
        } else if (var0 != var5) {
            var1.setBlock(var2, var5, 3);
        }
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return BlockScaffolding.getDistance(var1, var2) < 7;
    }

    @Override
    protected VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        if (var3.isPlacement()) {
            return VoxelShapes.empty();
        }
        if (!var3.isAbove(VoxelShapes.block(), var2, true) || var3.isDescending()) {
            if (var0.getValue(DISTANCE) != 0 && var0.getValue(BOTTOM).booleanValue() && var3.isAbove(SHAPE_BELOW_BLOCK, var2, true)) {
                return SHAPE_UNSTABLE_BOTTOM;
            }
            return VoxelShapes.empty();
        }
        return SHAPE_STABLE;
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    private boolean isBottom(IBlockAccess var0, BlockPosition var1, int var2) {
        return var2 > 0 && !var0.getBlockState(var1.below()).is(this);
    }

    public static int getDistance(IBlockAccess var0, BlockPosition var1) {
        EnumDirection var6;
        IBlockData var7;
        BlockPosition.MutableBlockPosition var2 = var1.mutable().move(EnumDirection.DOWN);
        IBlockData var3 = var0.getBlockState(var2);
        int var4 = 7;
        if (var3.is(Blocks.SCAFFOLDING)) {
            var4 = var3.getValue(DISTANCE);
        } else if (var3.isFaceSturdy(var0, var2, EnumDirection.UP)) {
            return 0;
        }
        Iterator<EnumDirection> iterator = EnumDirection.EnumDirectionLimit.HORIZONTAL.iterator();
        while (iterator.hasNext() && (!(var7 = var0.getBlockState(var2.setWithOffset((BaseBlockPosition)var1, var6 = iterator.next()))).is(Blocks.SCAFFOLDING) || (var4 = Math.min(var4, var7.getValue(DISTANCE) + 1)) != 1)) {
        }
        return var4;
    }
}

