/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import org.slf4j.Logger;

public class BiomeSettingsMobs {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final float DEFAULT_CREATURE_SPAWN_PROBABILITY = 0.1f;
    public static final WeightedList<c> EMPTY_MOB_LIST = WeightedList.of();
    public static final BiomeSettingsMobs EMPTY = new a().build();
    public static final MapCodec<BiomeSettingsMobs> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.floatRange((float)0.0f, (float)0.9999999f).optionalFieldOf("creature_spawn_probability", (Object)Float.valueOf(0.1f)).forGetter(var0 -> Float.valueOf(var0.creatureGenerationProbability)), (App)Codec.simpleMap(EnumCreatureType.CODEC, (Codec)WeightedList.codec(c.CODEC).promotePartial(SystemUtils.prefix("Spawn data: ", arg_0 -> ((Logger)LOGGER).error(arg_0))), (Keyable)INamable.keys(EnumCreatureType.values())).fieldOf("spawners").forGetter(var0 -> var0.spawners), (App)Codec.simpleMap(BuiltInRegistries.ENTITY_TYPE.byNameCodec(), b.CODEC, BuiltInRegistries.ENTITY_TYPE).fieldOf("spawn_costs").forGetter(var0 -> var0.mobSpawnCosts)).apply((Applicative)var02, BiomeSettingsMobs::new));
    private final float creatureGenerationProbability;
    private final Map<EnumCreatureType, WeightedList<c>> spawners;
    private final Map<EntityTypes<?>, b> mobSpawnCosts;

    BiomeSettingsMobs(float var0, Map<EnumCreatureType, WeightedList<c>> var1, Map<EntityTypes<?>, b> var2) {
        this.creatureGenerationProbability = var0;
        this.spawners = ImmutableMap.copyOf(var1);
        this.mobSpawnCosts = ImmutableMap.copyOf(var2);
    }

    public WeightedList<c> getMobs(EnumCreatureType var0) {
        return this.spawners.getOrDefault(var0, EMPTY_MOB_LIST);
    }

    @Nullable
    public b getMobSpawnCost(EntityTypes<?> var0) {
        return this.mobSpawnCosts.get(var0);
    }

    public float getCreatureProbability() {
        return this.creatureGenerationProbability;
    }

    public record b(double energyBudget, double charge) {
        public static final Codec<b> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.DOUBLE.fieldOf("energy_budget").forGetter(var0 -> var0.energyBudget), (App)Codec.DOUBLE.fieldOf("charge").forGetter(var0 -> var0.charge)).apply((Applicative)var02, b::new));
    }

    public record c(EntityTypes<?> type, int minCount, int maxCount) {
        public static final MapCodec<c> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("type").forGetter(var0 -> var0.type), (App)ExtraCodecs.POSITIVE_INT.fieldOf("minCount").forGetter(var0 -> var0.minCount), (App)ExtraCodecs.POSITIVE_INT.fieldOf("maxCount").forGetter(var0 -> var0.maxCount)).apply((Applicative)var02, c::new)).validate(var0 -> {
            if (var0.minCount > var0.maxCount) {
                return DataResult.error(() -> "minCount needs to be smaller or equal to maxCount");
            }
            return DataResult.success((Object)var0);
        });

        public c {
            var0 = var0.getCategory() == EnumCreatureType.MISC ? EntityTypes.PIG : var0;
        }

        @Override
        public String toString() {
            return String.valueOf(EntityTypes.getKey(this.type)) + "*(" + this.minCount + "-" + this.maxCount + ")";
        }
    }

    public static class a {
        private final Map<EnumCreatureType, WeightedList.a<c>> spawners = SystemUtils.makeEnumMap(EnumCreatureType.class, var0 -> WeightedList.builder());
        private final Map<EntityTypes<?>, b> mobSpawnCosts = Maps.newLinkedHashMap();
        private float creatureGenerationProbability = 0.1f;

        public a addSpawn(EnumCreatureType var0, int var1, c var2) {
            this.spawners.get(var0).add(var2, var1);
            return this;
        }

        public a addMobCharge(EntityTypes<?> var0, double var1, double var3) {
            this.mobSpawnCosts.put(var0, new b(var3, var1));
            return this;
        }

        public a creatureGenerationProbability(float var0) {
            this.creatureGenerationProbability = var0;
            return this;
        }

        public BiomeSettingsMobs build() {
            return new BiomeSettingsMobs(this.creatureGenerationProbability, (Map)this.spawners.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, var0 -> ((WeightedList.a)var0.getValue()).build())), (Map<EntityTypes<?>, b>)ImmutableMap.copyOf(this.mobSpawnCosts));
        }
    }
}

