/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public record FireworkExplosion(a shape, IntList colors, IntList fadeColors, boolean hasTrail, boolean hasTwinkle) implements TooltipProvider
{
    public static final FireworkExplosion DEFAULT = new FireworkExplosion(a.SMALL_BALL, IntList.of(), IntList.of(), false, false);
    public static final Codec<IntList> COLOR_LIST_CODEC = Codec.INT.listOf().xmap(IntArrayList::new, ArrayList::new);
    public static final Codec<FireworkExplosion> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)a.CODEC.fieldOf("shape").forGetter(FireworkExplosion::shape), (App)COLOR_LIST_CODEC.optionalFieldOf("colors", (Object)IntList.of()).forGetter(FireworkExplosion::colors), (App)COLOR_LIST_CODEC.optionalFieldOf("fade_colors", (Object)IntList.of()).forGetter(FireworkExplosion::fadeColors), (App)Codec.BOOL.optionalFieldOf("has_trail", (Object)false).forGetter(FireworkExplosion::hasTrail), (App)Codec.BOOL.optionalFieldOf("has_twinkle", (Object)false).forGetter(FireworkExplosion::hasTwinkle)).apply((Applicative)var0, FireworkExplosion::new));
    private static final StreamCodec<ByteBuf, IntList> COLOR_LIST_STREAM_CODEC = ByteBufCodecs.INT.apply(ByteBufCodecs.list()).map(IntArrayList::new, ArrayList::new);
    public static final StreamCodec<ByteBuf, FireworkExplosion> STREAM_CODEC = StreamCodec.composite(a.STREAM_CODEC, FireworkExplosion::shape, COLOR_LIST_STREAM_CODEC, FireworkExplosion::colors, COLOR_LIST_STREAM_CODEC, FireworkExplosion::fadeColors, ByteBufCodecs.BOOL, FireworkExplosion::hasTrail, ByteBufCodecs.BOOL, FireworkExplosion::hasTwinkle, FireworkExplosion::new);
    private static final IChatBaseComponent CUSTOM_COLOR_NAME = IChatBaseComponent.translatable("item.minecraft.firework_star.custom_color");

    @Override
    public void addToTooltip(Item.b var0, Consumer<IChatBaseComponent> var1, TooltipFlag var2, DataComponentGetter var3) {
        var1.accept(this.shape.getName().withStyle(EnumChatFormat.GRAY));
        this.addAdditionalTooltip(var1);
    }

    public void addAdditionalTooltip(Consumer<IChatBaseComponent> var0) {
        if (!this.colors.isEmpty()) {
            var0.accept(FireworkExplosion.appendColors(IChatBaseComponent.empty().withStyle(EnumChatFormat.GRAY), this.colors));
        }
        if (!this.fadeColors.isEmpty()) {
            var0.accept(FireworkExplosion.appendColors(IChatBaseComponent.translatable("item.minecraft.firework_star.fade_to").append(CommonComponents.SPACE).withStyle(EnumChatFormat.GRAY), this.fadeColors));
        }
        if (this.hasTrail) {
            var0.accept(IChatBaseComponent.translatable("item.minecraft.firework_star.trail").withStyle(EnumChatFormat.GRAY));
        }
        if (this.hasTwinkle) {
            var0.accept(IChatBaseComponent.translatable("item.minecraft.firework_star.flicker").withStyle(EnumChatFormat.GRAY));
        }
    }

    private static IChatBaseComponent appendColors(IChatMutableComponent var0, IntList var1) {
        for (int var2 = 0; var2 < var1.size(); ++var2) {
            if (var2 > 0) {
                var0.append(", ");
            }
            var0.append(FireworkExplosion.getColorName(var1.getInt(var2)));
        }
        return var0;
    }

    private static IChatBaseComponent getColorName(int var0) {
        EnumColor var1 = EnumColor.byFireworkColor(var0);
        if (var1 == null) {
            return CUSTOM_COLOR_NAME;
        }
        return IChatBaseComponent.translatable("item.minecraft.firework_star." + var1.getName());
    }

    public FireworkExplosion withFadeColors(IntList var0) {
        return new FireworkExplosion(this.shape, this.colors, (IntList)new IntArrayList(var0), this.hasTrail, this.hasTwinkle);
    }

    public static final class a
    extends Enum<a>
    implements INamable {
        public static final /* enum */ a SMALL_BALL = new a(0, "small_ball");
        public static final /* enum */ a LARGE_BALL = new a(1, "large_ball");
        public static final /* enum */ a STAR = new a(2, "star");
        public static final /* enum */ a CREEPER = new a(3, "creeper");
        public static final /* enum */ a BURST = new a(4, "burst");
        private static final IntFunction<a> BY_ID;
        public static final StreamCodec<ByteBuf, a> STREAM_CODEC;
        public static final Codec<a> CODEC;
        private final int id;
        private final String name;
        private static final /* synthetic */ a[] k;

        public static a[] values() {
            return (a[])k.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(int var2, String var3) {
            this.id = var2;
            this.name = var3;
        }

        public IChatMutableComponent getName() {
            return IChatBaseComponent.translatable("item.minecraft.firework_star.shape." + this.name);
        }

        public int getId() {
            return this.id;
        }

        public static a byId(int var0) {
            return BY_ID.apply(var0);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ a[] d() {
            return new a[]{SMALL_BALL, LARGE_BALL, STAR, CREEPER, BURST};
        }

        static {
            k = a.d();
            BY_ID = ByIdMap.continuous(a::getId, a.values(), ByIdMap.a.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, a::getId);
            CODEC = INamable.fromValues(a::values);
        }
    }
}

