/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import javax.annotation.Nullable;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntityEnderChest;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class InventoryEnderChest
extends InventorySubcontainer {
    @Nullable
    private TileEntityEnderChest activeChest;

    public InventoryEnderChest() {
        super(27);
    }

    public void setActiveChest(TileEntityEnderChest var0) {
        this.activeChest = var0;
    }

    public boolean isActiveChest(TileEntityEnderChest var0) {
        return this.activeChest == var0;
    }

    public void fromSlots(ValueInput.a<ItemStackWithSlot> var0) {
        for (int var1 = 0; var1 < this.getContainerSize(); ++var1) {
            this.setItem(var1, ItemStack.EMPTY);
        }
        for (ItemStackWithSlot var2 : var0) {
            if (!var2.isValidInContainer(this.getContainerSize())) continue;
            this.setItem(var2.slot(), var2.stack());
        }
    }

    public void storeAsSlots(ValueOutput.a<ItemStackWithSlot> var0) {
        for (int var1 = 0; var1 < this.getContainerSize(); ++var1) {
            ItemStack var2 = this.getItem(var1);
            if (var2.isEmpty()) continue;
            var0.add(new ItemStackWithSlot(var1, var2));
        }
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        if (this.activeChest != null && !this.activeChest.stillValid(var0)) {
            return false;
        }
        return super.stillValid(var0);
    }

    @Override
    public void startOpen(EntityHuman var0) {
        if (this.activeChest != null) {
            this.activeChest.startOpen(var0);
        }
        super.startOpen(var0);
    }

    @Override
    public void stopOpen(EntityHuman var0) {
        if (this.activeChest != null) {
            this.activeChest.stopOpen(var0);
        }
        super.stopOpen(var0);
        this.activeChest = null;
    }
}

