/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3D;

public abstract class EntityMinecartContainer
extends EntityMinecartAbstract
implements ContainerEntity {
    private NonNullList<ItemStack> itemStacks = NonNullList.withSize(36, ItemStack.EMPTY);
    @Nullable
    public ResourceKey<LootTable> lootTable;
    public long lootTableSeed;

    protected EntityMinecartContainer(EntityTypes<?> var0, World var1) {
        super(var0, var1);
    }

    @Override
    public void destroy(WorldServer var0, DamageSource var1) {
        super.destroy(var0, var1);
        this.chestVehicleDestroyed(var1, var0, this);
    }

    @Override
    public ItemStack getItem(int var0) {
        return this.getChestVehicleItem(var0);
    }

    @Override
    public ItemStack removeItem(int var0, int var1) {
        return this.removeChestVehicleItem(var0, var1);
    }

    @Override
    public ItemStack removeItemNoUpdate(int var0) {
        return this.removeChestVehicleItemNoUpdate(var0);
    }

    @Override
    public void setItem(int var0, ItemStack var1) {
        this.setChestVehicleItem(var0, var1);
    }

    @Override
    public SlotAccess getSlot(int var0) {
        return this.getChestVehicleSlot(var0);
    }

    @Override
    public void setChanged() {
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return this.isChestVehicleStillValid(var0);
    }

    @Override
    public void remove(Entity.RemovalReason var0) {
        if (!this.level().isClientSide && var0.shouldDestroy()) {
            InventoryUtils.dropContents(this.level(), this, (IInventory)this);
        }
        super.remove(var0);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        this.addChestVehicleSaveData(var0);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.readChestVehicleSaveData(var0);
    }

    @Override
    public EnumInteractionResult interact(EntityHuman var0, EnumHand var1) {
        return this.interactWithContainerVehicle(var0);
    }

    @Override
    protected Vec3D applyNaturalSlowdown(Vec3D var0) {
        float var1 = 0.98f;
        if (this.lootTable == null) {
            int var2 = 15 - Container.getRedstoneSignalFromContainer(this);
            var1 += (float)var2 * 0.001f;
        }
        if (this.isInWater()) {
            var1 *= 0.95f;
        }
        return var0.multiply(var1, 0.0, var1);
    }

    @Override
    public void clearContent() {
        this.clearChestVehicleContent();
    }

    public void setLootTable(ResourceKey<LootTable> var0, long var1) {
        this.lootTable = var0;
        this.lootTableSeed = var1;
    }

    @Override
    @Nullable
    public Container createMenu(int var0, PlayerInventory var1, EntityHuman var2) {
        if (this.lootTable == null || !var2.isSpectator()) {
            this.unpackChestVehicleLootTable(var1.player);
            return this.createMenu(var0, var1);
        }
        return null;
    }

    protected abstract Container createMenu(int var1, PlayerInventory var2);

    @Override
    @Nullable
    public ResourceKey<LootTable> getContainerLootTable() {
        return this.lootTable;
    }

    @Override
    public void setContainerLootTable(@Nullable ResourceKey<LootTable> var0) {
        this.lootTable = var0;
    }

    @Override
    public long getContainerLootTableSeed() {
        return this.lootTableSeed;
    }

    @Override
    public void setContainerLootTableSeed(long var0) {
        this.lootTableSeed = var0;
    }

    @Override
    public NonNullList<ItemStack> getItemStacks() {
        return this.itemStacks;
    }

    @Override
    public void clearItemStacks() {
        this.itemStacks = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
    }
}

