/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.entity.vehicle.MinecartBehavior;
import net.minecraft.world.entity.vehicle.NewMinecartBehavior;
import net.minecraft.world.entity.vehicle.OldMinecartBehavior;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.BlockPoweredRail;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public abstract class EntityMinecartAbstract
extends VehicleEntity {
    private static final Vec3D LOWERED_PASSENGER_ATTACHMENT = new Vec3D(0.0, 0.0, 0.0);
    private static final DataWatcherObject<Optional<IBlockData>> DATA_ID_CUSTOM_DISPLAY_BLOCK = DataWatcher.defineId(EntityMinecartAbstract.class, DataWatcherRegistry.OPTIONAL_BLOCK_STATE);
    private static final DataWatcherObject<Integer> DATA_ID_DISPLAY_OFFSET = DataWatcher.defineId(EntityMinecartAbstract.class, DataWatcherRegistry.INT);
    private static final ImmutableMap<EntityPose, ImmutableList<Integer>> POSE_DISMOUNT_HEIGHTS = ImmutableMap.of((Object)((Object)EntityPose.STANDING), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)EntityPose.CROUCHING), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)EntityPose.SWIMMING), (Object)ImmutableList.of((Object)0, (Object)1));
    protected static final float WATER_SLOWDOWN_FACTOR = 0.95f;
    private static final boolean DEFAULT_FLIPPED_ROTATION = false;
    private boolean onRails;
    private boolean flipped = false;
    private final MinecartBehavior behavior;
    private static final Map<BlockPropertyTrackPosition, Pair<BaseBlockPosition, BaseBlockPosition>> EXITS = Maps.newEnumMap((Map)((Map)SystemUtils.make(() -> {
        BaseBlockPosition var0 = EnumDirection.WEST.getUnitVec3i();
        BaseBlockPosition var1 = EnumDirection.EAST.getUnitVec3i();
        BaseBlockPosition var2 = EnumDirection.NORTH.getUnitVec3i();
        BaseBlockPosition var3 = EnumDirection.SOUTH.getUnitVec3i();
        BaseBlockPosition var4 = var0.below();
        BaseBlockPosition var5 = var1.below();
        BaseBlockPosition var6 = var2.below();
        BaseBlockPosition var7 = var3.below();
        return ImmutableMap.of((Object)BlockPropertyTrackPosition.NORTH_SOUTH, (Object)Pair.of((Object)var2, (Object)var3), (Object)BlockPropertyTrackPosition.EAST_WEST, (Object)Pair.of((Object)var0, (Object)var1), (Object)BlockPropertyTrackPosition.ASCENDING_EAST, (Object)Pair.of((Object)var4, (Object)var1), (Object)BlockPropertyTrackPosition.ASCENDING_WEST, (Object)Pair.of((Object)var0, (Object)var5), (Object)BlockPropertyTrackPosition.ASCENDING_NORTH, (Object)Pair.of((Object)var2, (Object)var7), (Object)BlockPropertyTrackPosition.ASCENDING_SOUTH, (Object)Pair.of((Object)var6, (Object)var3), (Object)BlockPropertyTrackPosition.SOUTH_EAST, (Object)Pair.of((Object)var3, (Object)var1), (Object)BlockPropertyTrackPosition.SOUTH_WEST, (Object)Pair.of((Object)var3, (Object)var0), (Object)BlockPropertyTrackPosition.NORTH_WEST, (Object)Pair.of((Object)var2, (Object)var0), (Object)BlockPropertyTrackPosition.NORTH_EAST, (Object)Pair.of((Object)var2, (Object)var1));
    })));

    protected EntityMinecartAbstract(EntityTypes<?> var0, World var1) {
        super(var0, var1);
        this.blocksBuilding = true;
        this.behavior = EntityMinecartAbstract.useExperimentalMovement(var1) ? new NewMinecartBehavior(this) : new OldMinecartBehavior(this);
    }

    protected EntityMinecartAbstract(EntityTypes<?> var0, World var1, double var2, double var4, double var6) {
        this(var0, var1);
        this.setInitialPos(var2, var4, var6);
    }

    public void setInitialPos(double var0, double var2, double var4) {
        this.setPos(var0, var2, var4);
        this.xo = var0;
        this.yo = var2;
        this.zo = var4;
    }

    @Nullable
    public static <T extends EntityMinecartAbstract> T createMinecart(World var0, double var1, double var3, double var5, EntityTypes<T> var7, EntitySpawnReason var8, ItemStack var9, @Nullable EntityHuman var10) {
        EntityMinecartAbstract var11 = (EntityMinecartAbstract)var7.create(var0, var8);
        if (var11 != null) {
            var11.setInitialPos(var1, var3, var5);
            EntityTypes.createDefaultStackConfig(var0, var9, var10).accept(var11);
            MinecartBehavior minecartBehavior = var11.getBehavior();
            if (minecartBehavior instanceof NewMinecartBehavior) {
                NewMinecartBehavior var12 = (NewMinecartBehavior)minecartBehavior;
                BlockPosition var13 = var11.getCurrentBlockPosOrRailBelow();
                IBlockData var14 = var0.getBlockState(var13);
                var12.adjustToRails(var13, var14, true);
            }
        }
        return (T)var11;
    }

    public MinecartBehavior getBehavior() {
        return this.behavior;
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_ID_CUSTOM_DISPLAY_BLOCK, Optional.empty());
        var0.define(DATA_ID_DISPLAY_OFFSET, this.getDefaultDisplayOffset());
    }

    @Override
    public boolean canCollideWith(Entity var0) {
        return AbstractBoat.canVehicleCollide(this, var0);
    }

    @Override
    public boolean isPushable() {
        return true;
    }

    @Override
    public Vec3D getRelativePortalPosition(EnumDirection.EnumAxis var0, BlockUtil.Rectangle var1) {
        return EntityLiving.resetForwardDirectionOfRelativePortalPosition(super.getRelativePortalPosition(var0, var1));
    }

    @Override
    protected Vec3D getPassengerAttachmentPoint(Entity var0, EntitySize var1, float var2) {
        boolean var3;
        boolean bl = var3 = var0 instanceof EntityVillager || var0 instanceof EntityVillagerTrader;
        if (var3) {
            return LOWERED_PASSENGER_ATTACHMENT;
        }
        return super.getPassengerAttachmentPoint(var0, var1, var2);
    }

    @Override
    public Vec3D getDismountLocationForPassenger(EntityLiving var02) {
        EnumDirection var1 = this.getMotionDirection();
        if (var1.getAxis() == EnumDirection.EnumAxis.Y) {
            return super.getDismountLocationForPassenger(var02);
        }
        int[][] var2 = DismountUtil.offsetsForDirection(var1);
        BlockPosition var3 = this.blockPosition();
        BlockPosition.MutableBlockPosition var4 = new BlockPosition.MutableBlockPosition();
        ImmutableList<EntityPose> var5 = var02.getDismountPoses();
        for (EntityPose var7 : var5) {
            EntitySize var8 = var02.getDimensions(var7);
            float var9 = Math.min(var8.width(), 1.0f) / 2.0f;
            UnmodifiableIterator unmodifiableIterator = ((ImmutableList)POSE_DISMOUNT_HEIGHTS.get((Object)var7)).iterator();
            while (unmodifiableIterator.hasNext()) {
                int var11 = (Integer)unmodifiableIterator.next();
                for (int[] var15 : var2) {
                    var4.set(var3.getX() + var15[0], var3.getY() + var11, var3.getZ() + var15[1]);
                    double var16 = this.level().getBlockFloorHeight(DismountUtil.nonClimbableShape(this.level(), var4), () -> DismountUtil.nonClimbableShape(this.level(), (BlockPosition)var4.below()));
                    if (!DismountUtil.isBlockFloorValid(var16)) continue;
                    AxisAlignedBB var18 = new AxisAlignedBB(-var9, 0.0, -var9, var9, var8.height(), var9);
                    Vec3D var19 = Vec3D.upFromBottomCenterOf(var4, var16);
                    if (!DismountUtil.canDismountTo(this.level(), var02, var18.move(var19))) continue;
                    var02.setPose(var7);
                    return var19;
                }
            }
        }
        double var6 = this.getBoundingBox().maxY;
        var4.set((double)var3.getX(), var6, (double)var3.getZ());
        for (EntityPose var9 : var5) {
            int var12;
            double var13;
            double var10 = var02.getDimensions(var9).height();
            if (!(var6 + var10 <= (var13 = DismountUtil.findCeilingFrom(var4, var12 = MathHelper.ceil(var6 - (double)var4.getY() + var10), var0 -> this.level().getBlockState((BlockPosition)var0).getCollisionShape(this.level(), (BlockPosition)var0))))) continue;
            var02.setPose(var9);
            break;
        }
        return super.getDismountLocationForPassenger(var02);
    }

    @Override
    protected float getBlockSpeedFactor() {
        IBlockData var0 = this.level().getBlockState(this.blockPosition());
        if (var0.is(TagsBlock.RAILS)) {
            return 1.0f;
        }
        return super.getBlockSpeedFactor();
    }

    @Override
    public void animateHurt(float var0) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() + this.getDamage() * 10.0f);
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved();
    }

    public static Pair<BaseBlockPosition, BaseBlockPosition> exits(BlockPropertyTrackPosition var0) {
        return EXITS.get(var0);
    }

    @Override
    public EnumDirection getMotionDirection() {
        return this.behavior.getMotionDirection();
    }

    @Override
    protected double getDefaultGravity() {
        return this.isInWater() ? 0.005 : 0.04;
    }

    @Override
    public void tick() {
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        this.checkBelowWorld();
        this.handlePortal();
        this.behavior.tick();
        this.updateInWaterStateAndDoFluidPushing();
        if (this.isInLava()) {
            this.lavaIgnite();
            this.lavaHurt();
            this.fallDistance *= 0.5;
        }
        this.firstTick = false;
    }

    public boolean isFirstTick() {
        return this.firstTick;
    }

    public BlockPosition getCurrentBlockPosOrRailBelow() {
        int var0 = MathHelper.floor(this.getX());
        int var1 = MathHelper.floor(this.getY());
        int var2 = MathHelper.floor(this.getZ());
        if (EntityMinecartAbstract.useExperimentalMovement(this.level())) {
            double var3 = this.getY() - 0.1 - (double)1.0E-5f;
            if (this.level().getBlockState(BlockPosition.containing(var0, var3, var2)).is(TagsBlock.RAILS)) {
                var1 = MathHelper.floor(var3);
            }
        } else if (this.level().getBlockState(new BlockPosition(var0, var1 - 1, var2)).is(TagsBlock.RAILS)) {
            --var1;
        }
        return new BlockPosition(var0, var1, var2);
    }

    protected double getMaxSpeed(WorldServer var0) {
        return this.behavior.getMaxSpeed(var0);
    }

    public void activateMinecart(int var0, int var1, int var2, boolean var3) {
    }

    @Override
    public void lerpPositionAndRotationStep(int var0, double var1, double var3, double var5, double var7, double var9) {
        super.lerpPositionAndRotationStep(var0, var1, var3, var5, var7, var9);
    }

    @Override
    public void applyGravity() {
        super.applyGravity();
    }

    @Override
    public void reapplyPosition() {
        super.reapplyPosition();
    }

    @Override
    public boolean updateInWaterStateAndDoFluidPushing() {
        return super.updateInWaterStateAndDoFluidPushing();
    }

    @Override
    public Vec3D getKnownMovement() {
        return this.behavior.getKnownMovement(super.getKnownMovement());
    }

    @Override
    public InterpolationHandler getInterpolation() {
        return this.behavior.getInterpolation();
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity var0) {
        super.recreateFromPacket(var0);
        Vec3D var1 = this.getDeltaMovement();
        this.behavior.lerpMotion(var1.x, var1.y, var1.z);
    }

    @Override
    public void lerpMotion(double var0, double var2, double var4) {
        this.behavior.lerpMotion(var0, var2, var4);
    }

    protected void moveAlongTrack(WorldServer var0) {
        this.behavior.moveAlongTrack(var0);
    }

    protected void comeOffTrack(WorldServer var0) {
        double var1 = this.getMaxSpeed(var0);
        Vec3D var3 = this.getDeltaMovement();
        this.setDeltaMovement(MathHelper.clamp(var3.x, -var1, var1), var3.y, MathHelper.clamp(var3.z, -var1, var1));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
        }
        this.move(EnumMoveType.SELF, this.getDeltaMovement());
        if (!this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.95));
        }
    }

    protected double makeStepAlongTrack(BlockPosition var0, BlockPropertyTrackPosition var1, double var2) {
        return this.behavior.stepAlongTrack(var0, var1, var2);
    }

    @Override
    public void move(EnumMoveType var0, Vec3D var1) {
        if (EntityMinecartAbstract.useExperimentalMovement(this.level())) {
            Vec3D var2 = this.position().add(var1);
            super.move(var0, var1);
            boolean var3 = this.behavior.pushAndPickupEntities();
            if (var3) {
                super.move(var0, var2.subtract(this.position()));
            }
            if (var0.equals((Object)EnumMoveType.PISTON)) {
                this.onRails = false;
            }
        } else {
            super.move(var0, var1);
            this.applyEffectsFromBlocks();
        }
    }

    @Override
    public void applyEffectsFromBlocks() {
        if (EntityMinecartAbstract.useExperimentalMovement(this.level())) {
            super.applyEffectsFromBlocks();
        } else {
            this.applyEffectsFromBlocks(this.position(), this.position());
            this.clearMovementThisTick();
        }
    }

    @Override
    public boolean isOnRails() {
        return this.onRails;
    }

    public void setOnRails(boolean var0) {
        this.onRails = var0;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void setFlipped(boolean var0) {
        this.flipped = var0;
    }

    public Vec3D getRedstoneDirection(BlockPosition var0) {
        IBlockData var1 = this.level().getBlockState(var0);
        if (!var1.is(Blocks.POWERED_RAIL) || !var1.getValue(BlockPoweredRail.POWERED).booleanValue()) {
            return Vec3D.ZERO;
        }
        BlockPropertyTrackPosition var2 = var1.getValue(((BlockMinecartTrackAbstract)var1.getBlock()).getShapeProperty());
        if (var2 == BlockPropertyTrackPosition.EAST_WEST) {
            if (this.isRedstoneConductor(var0.west())) {
                return new Vec3D(1.0, 0.0, 0.0);
            }
            if (this.isRedstoneConductor(var0.east())) {
                return new Vec3D(-1.0, 0.0, 0.0);
            }
        } else if (var2 == BlockPropertyTrackPosition.NORTH_SOUTH) {
            if (this.isRedstoneConductor(var0.north())) {
                return new Vec3D(0.0, 0.0, 1.0);
            }
            if (this.isRedstoneConductor(var0.south())) {
                return new Vec3D(0.0, 0.0, -1.0);
            }
        }
        return Vec3D.ZERO;
    }

    public boolean isRedstoneConductor(BlockPosition var0) {
        return this.level().getBlockState(var0).isRedstoneConductor(this.level(), var0);
    }

    protected Vec3D applyNaturalSlowdown(Vec3D var0) {
        double var1 = this.behavior.getSlowdownFactor();
        Vec3D var3 = var0.multiply(var1, 0.0, var1);
        if (this.isInWater()) {
            var3 = var3.scale(0.95f);
        }
        return var3;
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        this.setCustomDisplayBlockState(var0.read("DisplayState", IBlockData.CODEC));
        this.setDisplayOffset(var0.getIntOr("DisplayOffset", this.getDefaultDisplayOffset()));
        this.flipped = var0.getBooleanOr("FlippedRotation", false);
        this.firstTick = var0.getBooleanOr("HasTicked", false);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        this.getCustomDisplayBlockState().ifPresent(var1 -> var0.store("DisplayState", IBlockData.CODEC, var1));
        int var12 = this.getDisplayOffset();
        if (var12 != this.getDefaultDisplayOffset()) {
            var0.putInt("DisplayOffset", var12);
        }
        var0.putBoolean("FlippedRotation", this.flipped);
        var0.putBoolean("HasTicked", this.firstTick);
    }

    @Override
    public void push(Entity var0) {
        double var3;
        if (this.level().isClientSide) {
            return;
        }
        if (var0.noPhysics || this.noPhysics) {
            return;
        }
        if (this.hasPassenger(var0)) {
            return;
        }
        double var1 = var0.getX() - this.getX();
        double var5 = var1 * var1 + (var3 = var0.getZ() - this.getZ()) * var3;
        if (var5 >= (double)1.0E-4f) {
            var5 = Math.sqrt(var5);
            var1 /= var5;
            var3 /= var5;
            double var7 = 1.0 / var5;
            if (var7 > 1.0) {
                var7 = 1.0;
            }
            var1 *= var7;
            var3 *= var7;
            var1 *= (double)0.1f;
            var3 *= (double)0.1f;
            var1 *= 0.5;
            var3 *= 0.5;
            if (var0 instanceof EntityMinecartAbstract) {
                EntityMinecartAbstract var9 = (EntityMinecartAbstract)var0;
                this.pushOtherMinecart(var9, var1, var3);
            } else {
                this.push(-var1, 0.0, -var3);
                var0.push(var1 / 4.0, 0.0, var3 / 4.0);
            }
        }
    }

    private void pushOtherMinecart(EntityMinecartAbstract var0, double var1, double var3) {
        double var7;
        double var5;
        if (EntityMinecartAbstract.useExperimentalMovement(this.level())) {
            var5 = this.getDeltaMovement().x;
            var7 = this.getDeltaMovement().z;
        } else {
            var5 = var0.getX() - this.getX();
            var7 = var0.getZ() - this.getZ();
        }
        Vec3D var9 = new Vec3D(var5, 0.0, var7).normalize();
        Vec3D var10 = new Vec3D(MathHelper.cos(this.getYRot() * ((float)Math.PI / 180)), 0.0, MathHelper.sin(this.getYRot() * ((float)Math.PI / 180))).normalize();
        double var11 = Math.abs(var9.dot(var10));
        if (var11 < (double)0.8f && !EntityMinecartAbstract.useExperimentalMovement(this.level())) {
            return;
        }
        Vec3D var13 = this.getDeltaMovement();
        Vec3D var14 = var0.getDeltaMovement();
        if (var0.isFurnace() && !this.isFurnace()) {
            this.setDeltaMovement(var13.multiply(0.2, 1.0, 0.2));
            this.push(var14.x - var1, 0.0, var14.z - var3);
            var0.setDeltaMovement(var14.multiply(0.95, 1.0, 0.95));
        } else if (!var0.isFurnace() && this.isFurnace()) {
            var0.setDeltaMovement(var14.multiply(0.2, 1.0, 0.2));
            var0.push(var13.x + var1, 0.0, var13.z + var3);
            this.setDeltaMovement(var13.multiply(0.95, 1.0, 0.95));
        } else {
            double var15 = (var14.x + var13.x) / 2.0;
            double var17 = (var14.z + var13.z) / 2.0;
            this.setDeltaMovement(var13.multiply(0.2, 1.0, 0.2));
            this.push(var15 - var1, 0.0, var17 - var3);
            var0.setDeltaMovement(var14.multiply(0.2, 1.0, 0.2));
            var0.push(var15 + var1, 0.0, var17 + var3);
        }
    }

    public IBlockData getDisplayBlockState() {
        return this.getCustomDisplayBlockState().orElseGet(this::getDefaultDisplayBlockState);
    }

    private Optional<IBlockData> getCustomDisplayBlockState() {
        return this.getEntityData().get(DATA_ID_CUSTOM_DISPLAY_BLOCK);
    }

    public IBlockData getDefaultDisplayBlockState() {
        return Blocks.AIR.defaultBlockState();
    }

    public int getDisplayOffset() {
        return this.getEntityData().get(DATA_ID_DISPLAY_OFFSET);
    }

    public int getDefaultDisplayOffset() {
        return 6;
    }

    public void setCustomDisplayBlockState(Optional<IBlockData> var0) {
        this.getEntityData().set(DATA_ID_CUSTOM_DISPLAY_BLOCK, var0);
    }

    public void setDisplayOffset(int var0) {
        this.getEntityData().set(DATA_ID_DISPLAY_OFFSET, var0);
    }

    public static boolean useExperimentalMovement(World var0) {
        return var0.enabledFeatures().contains(FeatureFlags.MINECART_IMPROVEMENTS);
    }

    @Override
    public abstract ItemStack getPickResult();

    public boolean isRideable() {
        return false;
    }

    public boolean isFurnace() {
        return false;
    }
}

