/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.PlacementInfo;

public class StackedItemContents {
    private final AutoRecipeStackManager<Holder<Item>> raw = new AutoRecipeStackManager();

    public void accountSimpleStack(ItemStack var0) {
        if (PlayerInventory.isUsableForCrafting(var0)) {
            this.accountStack(var0);
        }
    }

    public void accountStack(ItemStack var0) {
        this.accountStack(var0, var0.getMaxStackSize());
    }

    public void accountStack(ItemStack var0, int var1) {
        if (!var0.isEmpty()) {
            int var2 = Math.min(var1, var0.getCount());
            this.raw.account(var0.getItemHolder(), var2);
        }
    }

    public boolean canCraft(IRecipe<?> var0, @Nullable AutoRecipeStackManager.b<Holder<Item>> var1) {
        return this.canCraft(var0, 1, var1);
    }

    public boolean canCraft(IRecipe<?> var0, int var1, @Nullable AutoRecipeStackManager.b<Holder<Item>> var2) {
        PlacementInfo var3 = var0.placementInfo();
        if (var3.isImpossibleToPlace()) {
            return false;
        }
        return this.canCraft(var3.ingredients(), var1, var2);
    }

    public boolean canCraft(List<? extends AutoRecipeStackManager.a<Holder<Item>>> var0, @Nullable AutoRecipeStackManager.b<Holder<Item>> var1) {
        return this.canCraft(var0, 1, var1);
    }

    private boolean canCraft(List<? extends AutoRecipeStackManager.a<Holder<Item>>> var0, int var1, @Nullable AutoRecipeStackManager.b<Holder<Item>> var2) {
        return this.raw.tryPick(var0, var1, var2);
    }

    public int getBiggestCraftableStack(IRecipe<?> var0, @Nullable AutoRecipeStackManager.b<Holder<Item>> var1) {
        return this.getBiggestCraftableStack(var0, Integer.MAX_VALUE, var1);
    }

    public int getBiggestCraftableStack(IRecipe<?> var0, int var1, @Nullable AutoRecipeStackManager.b<Holder<Item>> var2) {
        return this.raw.tryPickAll(var0.placementInfo().ingredients(), var1, var2);
    }

    public void clear() {
        this.raw.clear();
    }
}

