/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class EntityRavager
extends EntityRaider {
    private static final Predicate<Entity> ROAR_TARGET_WITH_GRIEFING = var0 -> !(var0 instanceof EntityRavager) && var0.isAlive();
    private static final Predicate<Entity> ROAR_TARGET_WITHOUT_GRIEFING = var0 -> ROAR_TARGET_WITH_GRIEFING.test((Entity)var0) && !var0.getType().equals(EntityTypes.ARMOR_STAND);
    private static final Predicate<EntityLiving> ROAR_TARGET_ON_CLIENT = var0 -> !(var0 instanceof EntityRavager) && var0.isAlive() && var0.isLocalInstanceAuthoritative();
    private static final double BASE_MOVEMENT_SPEED = 0.3;
    private static final double ATTACK_MOVEMENT_SPEED = 0.35;
    private static final int STUNNED_COLOR = 8356754;
    private static final float STUNNED_COLOR_BLUE = 0.57254905f;
    private static final float STUNNED_COLOR_GREEN = 0.5137255f;
    private static final float STUNNED_COLOR_RED = 0.49803922f;
    public static final int ATTACK_DURATION = 10;
    public static final int STUN_DURATION = 40;
    private static final int DEFAULT_ATTACK_TICK = 0;
    private static final int DEFAULT_STUN_TICK = 0;
    private static final int DEFAULT_ROAR_TICK = 0;
    private int attackTick = 0;
    private int stunnedTick = 0;
    private int roarTick = 0;

    public EntityRavager(EntityTypes<? extends EntityRavager> var0, World var1) {
        super((EntityTypes<? extends EntityRaider>)var0, var1);
        this.xpReward = 20;
        this.setPathfindingMalus(PathType.LEAVES, 0.0f);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(4, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.goalSelector.addGoal(5, new PathfinderGoalRandomStrollLand(this, 0.4));
        this.goalSelector.addGoal(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.goalSelector.addGoal(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.targetSelector.addGoal(2, new PathfinderGoalHurtByTarget(this, EntityRaider.class).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.targetSelector.addGoal(4, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, true, (var0, var1) -> !var0.isBaby()));
        this.targetSelector.addGoal(4, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    protected void updateControlFlags() {
        boolean var0 = !(this.getControllingPassenger() instanceof EntityInsentient) || this.getControllingPassenger().getType().is(TagsEntity.RAIDERS);
        boolean var1 = !(this.getVehicle() instanceof AbstractBoat);
        this.goalSelector.setControlFlag(PathfinderGoal.Type.MOVE, var0);
        this.goalSelector.setControlFlag(PathfinderGoal.Type.JUMP, var0 && var1);
        this.goalSelector.setControlFlag(PathfinderGoal.Type.LOOK, var0);
        this.goalSelector.setControlFlag(PathfinderGoal.Type.TARGET, var0);
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MAX_HEALTH, 100.0).add(GenericAttributes.MOVEMENT_SPEED, 0.3).add(GenericAttributes.KNOCKBACK_RESISTANCE, 0.75).add(GenericAttributes.ATTACK_DAMAGE, 12.0).add(GenericAttributes.ATTACK_KNOCKBACK, 1.5).add(GenericAttributes.FOLLOW_RANGE, 32.0).add(GenericAttributes.STEP_HEIGHT, 1.0);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("AttackTick", this.attackTick);
        var0.putInt("StunTick", this.stunnedTick);
        var0.putInt("RoarTick", this.roarTick);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.attackTick = var0.getIntOr("AttackTick", 0);
        this.stunnedTick = var0.getIntOr("StunTick", 0);
        this.roarTick = var0.getIntOr("RoarTick", 0);
    }

    @Override
    public SoundEffect getCelebrateSound() {
        return SoundEffects.RAVAGER_CELEBRATE;
    }

    @Override
    public int getMaxHeadYRot() {
        return 45;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.isAlive()) {
            return;
        }
        if (this.isImmobile()) {
            this.getAttribute(GenericAttributes.MOVEMENT_SPEED).setBaseValue(0.0);
        } else {
            double var0 = this.getTarget() != null ? 0.35 : 0.3;
            double var2 = this.getAttribute(GenericAttributes.MOVEMENT_SPEED).getBaseValue();
            this.getAttribute(GenericAttributes.MOVEMENT_SPEED).setBaseValue(MathHelper.lerp(0.1, var2, var0));
        }
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var0 = (WorldServer)world;
            if (this.horizontalCollision && var0.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                boolean var1 = false;
                AxisAlignedBB var2 = this.getBoundingBox().inflate(0.2);
                for (BlockPosition var4 : BlockPosition.betweenClosed(MathHelper.floor(var2.minX), MathHelper.floor(var2.minY), MathHelper.floor(var2.minZ), MathHelper.floor(var2.maxX), MathHelper.floor(var2.maxY), MathHelper.floor(var2.maxZ))) {
                    IBlockData var5 = var0.getBlockState(var4);
                    Block var6 = var5.getBlock();
                    if (!(var6 instanceof BlockLeaves)) continue;
                    var1 = var0.destroyBlock(var4, true, this) || var1;
                }
                if (!var1 && this.onGround()) {
                    this.jumpFromGround();
                }
            }
        }
        if (this.roarTick > 0) {
            --this.roarTick;
            if (this.roarTick == 10) {
                this.roar();
            }
        }
        if (this.attackTick > 0) {
            --this.attackTick;
        }
        if (this.stunnedTick > 0) {
            --this.stunnedTick;
            this.stunEffect();
            if (this.stunnedTick == 0) {
                this.playSound(SoundEffects.RAVAGER_ROAR, 1.0f, 1.0f);
                this.roarTick = 20;
            }
        }
    }

    private void stunEffect() {
        if (this.random.nextInt(6) == 0) {
            double var0 = this.getX() - (double)this.getBbWidth() * Math.sin(this.yBodyRot * ((float)Math.PI / 180)) + (this.random.nextDouble() * 0.6 - 0.3);
            double var2 = this.getY() + (double)this.getBbHeight() - 0.3;
            double var4 = this.getZ() + (double)this.getBbWidth() * Math.cos(this.yBodyRot * ((float)Math.PI / 180)) + (this.random.nextDouble() * 0.6 - 0.3);
            this.level().addParticle(ColorParticleOption.create(Particles.ENTITY_EFFECT, 0.49803922f, 0.5137255f, 0.57254905f), var0, var2, var4, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected boolean isImmobile() {
        return super.isImmobile() || this.attackTick > 0 || this.stunnedTick > 0 || this.roarTick > 0;
    }

    @Override
    public boolean hasLineOfSight(Entity var0) {
        if (this.stunnedTick > 0 || this.roarTick > 0) {
            return false;
        }
        return super.hasLineOfSight(var0);
    }

    @Override
    protected void blockedByItem(EntityLiving var0) {
        if (this.roarTick == 0) {
            if (this.random.nextDouble() < 0.5) {
                this.stunnedTick = 40;
                this.playSound(SoundEffects.RAVAGER_STUNNED, 1.0f, 1.0f);
                this.level().broadcastEntityEvent(this, (byte)39);
                var0.push(this);
            } else {
                this.strongKnockback(var0);
            }
            var0.hurtMarked = true;
        }
    }

    private void roar() {
        World world;
        if (this.isAlive() && (world = this.level()) instanceof WorldServer) {
            WorldServer var0 = (WorldServer)world;
            Predicate<Entity> var1 = var0.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) ? ROAR_TARGET_WITH_GRIEFING : ROAR_TARGET_WITHOUT_GRIEFING;
            List<Entity> var2 = this.level().getEntitiesOfClass(EntityLiving.class, this.getBoundingBox().inflate(4.0), var1);
            for (EntityLiving entityLiving : var2) {
                if (!(entityLiving instanceof EntityIllagerAbstract)) {
                    entityLiving.hurtServer(var0, this.damageSources().mobAttack(this), 6.0f);
                }
                if (entityLiving instanceof EntityHuman) continue;
                this.strongKnockback(entityLiving);
            }
            this.gameEvent(GameEvent.ENTITY_ACTION);
            var0.broadcastEntityEvent(this, (byte)69);
        }
    }

    private void applyRoarKnockbackClient() {
        List<EntityLiving> var0 = this.level().getEntitiesOfClass(EntityLiving.class, this.getBoundingBox().inflate(4.0), ROAR_TARGET_ON_CLIENT);
        for (EntityLiving var2 : var0) {
            this.strongKnockback(var2);
        }
    }

    private void strongKnockback(Entity var0) {
        double var1 = var0.getX() - this.getX();
        double var3 = var0.getZ() - this.getZ();
        double var5 = Math.max(var1 * var1 + var3 * var3, 0.001);
        var0.push(var1 / var5 * 4.0, 0.2, var3 / var5 * 4.0);
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 4) {
            this.attackTick = 10;
            this.playSound(SoundEffects.RAVAGER_ATTACK, 1.0f, 1.0f);
        } else if (var0 == 39) {
            this.stunnedTick = 40;
        } else if (var0 == 69) {
            this.addRoarParticleEffects();
            this.applyRoarKnockbackClient();
        }
        super.handleEntityEvent(var0);
    }

    private void addRoarParticleEffects() {
        Vec3D var0 = this.getBoundingBox().getCenter();
        for (int var1 = 0; var1 < 40; ++var1) {
            double var2 = this.random.nextGaussian() * 0.2;
            double var4 = this.random.nextGaussian() * 0.2;
            double var6 = this.random.nextGaussian() * 0.2;
            this.level().addParticle(Particles.POOF, var0.x, var0.y, var0.z, var2, var4, var6);
        }
    }

    public int getAttackTick() {
        return this.attackTick;
    }

    public int getStunnedTick() {
        return this.stunnedTick;
    }

    public int getRoarTick() {
        return this.roarTick;
    }

    @Override
    public boolean doHurtTarget(WorldServer var0, Entity var1) {
        this.attackTick = 10;
        var0.broadcastEntityEvent(this, (byte)4);
        this.playSound(SoundEffects.RAVAGER_ATTACK, 1.0f, 1.0f);
        return super.doHurtTarget(var0, var1);
    }

    @Override
    @Nullable
    protected SoundEffect getAmbientSound() {
        return SoundEffects.RAVAGER_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.RAVAGER_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.RAVAGER_DEATH;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.RAVAGER_STEP, 0.15f, 1.0f);
    }

    @Override
    public boolean checkSpawnObstruction(IWorldReader var0) {
        return !var0.containsAnyLiquid(this.getBoundingBox());
    }

    @Override
    public void applyRaidBuffs(WorldServer var0, int var1, boolean var2) {
    }

    @Override
    public boolean canBeLeader() {
        return false;
    }

    @Override
    protected AxisAlignedBB getAttackBoundingBox() {
        AxisAlignedBB var0 = super.getAttackBoundingBox();
        return var0.deflate(0.05, 0.0, 0.05);
    }
}

