/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.DragonFlightHistory;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerManager;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.IDragonController;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class EntityEnderDragon
extends EntityInsentient
implements IMonster {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DataWatcherObject<Integer> DATA_PHASE = DataWatcher.defineId(EntityEnderDragon.class, DataWatcherRegistry.INT);
    private static final PathfinderTargetCondition CRYSTAL_DESTROY_TARGETING = PathfinderTargetCondition.forCombat().range(64.0);
    private static final int GROWL_INTERVAL_MIN = 200;
    private static final int GROWL_INTERVAL_MAX = 400;
    private static final float SITTING_ALLOWED_DAMAGE_PERCENTAGE = 0.25f;
    private static final String DRAGON_DEATH_TIME_KEY = "DragonDeathTime";
    private static final String DRAGON_PHASE_KEY = "DragonPhase";
    private static final int DEFAULT_DEATH_TIME = 0;
    public final DragonFlightHistory flightHistory = new DragonFlightHistory();
    public final EntityComplexPart[] subEntities;
    public final EntityComplexPart head;
    private final EntityComplexPart neck;
    private final EntityComplexPart body;
    private final EntityComplexPart tail1;
    private final EntityComplexPart tail2;
    private final EntityComplexPart tail3;
    private final EntityComplexPart wing1;
    private final EntityComplexPart wing2;
    public float oFlapTime;
    public float flapTime;
    public boolean inWall;
    public int dragonDeathTime = 0;
    public float yRotA;
    @Nullable
    public EntityEnderCrystal nearestCrystal;
    @Nullable
    private EnderDragonBattle dragonFight;
    private BlockPosition fightOrigin = BlockPosition.ZERO;
    private final DragonControllerManager phaseManager;
    private int growlTime = 100;
    private float sittingDamageReceived;
    private final PathPoint[] nodes = new PathPoint[24];
    private final int[] nodeAdjacency = new int[24];
    private final Path openSet = new Path();

    public EntityEnderDragon(EntityTypes<? extends EntityEnderDragon> var0, World var1) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.ENDER_DRAGON, var1);
        this.head = new EntityComplexPart(this, "head", 1.0f, 1.0f);
        this.neck = new EntityComplexPart(this, "neck", 3.0f, 3.0f);
        this.body = new EntityComplexPart(this, "body", 5.0f, 3.0f);
        this.tail1 = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.tail2 = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.tail3 = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.wing1 = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.wing2 = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.subEntities = new EntityComplexPart[]{this.head, this.neck, this.body, this.tail1, this.tail2, this.tail3, this.wing1, this.wing2};
        this.setHealth(this.getMaxHealth());
        this.noPhysics = true;
        this.phaseManager = new DragonControllerManager(this);
    }

    public void setDragonFight(EnderDragonBattle var0) {
        this.dragonFight = var0;
    }

    public void setFightOrigin(BlockPosition var0) {
        this.fightOrigin = var0;
    }

    public BlockPosition getFightOrigin() {
        return this.fightOrigin;
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MAX_HEALTH, 200.0).add(GenericAttributes.CAMERA_DISTANCE, 16.0);
    }

    @Override
    public boolean isFlapping() {
        float var0 = MathHelper.cos(this.flapTime * ((float)Math.PI * 2));
        float var1 = MathHelper.cos(this.oFlapTime * ((float)Math.PI * 2));
        return var1 <= -0.3f && var0 >= -0.3f;
    }

    @Override
    public void onFlap() {
        if (this.level().isClientSide && !this.isSilent()) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEffects.ENDER_DRAGON_FLAP, this.getSoundSource(), 5.0f, 0.8f + this.random.nextFloat() * 0.3f, false);
        }
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_PHASE, DragonControllerPhase.HOVERING.getId());
    }

    @Override
    public void aiStep() {
        float var20;
        float var19;
        float var18;
        Vec3D[] var2;
        Object var0;
        EnderDragonBattle var1;
        World world;
        this.processFlappingMovement();
        if (this.level().isClientSide) {
            this.setHealth(this.getHealth());
            if (!this.isSilent() && !this.phaseManager.getCurrentPhase().isSitting() && --this.growlTime < 0) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEffects.ENDER_DRAGON_GROWL, this.getSoundSource(), 2.5f, 0.8f + this.random.nextFloat() * 0.3f, false);
                this.growlTime = 200 + this.random.nextInt(200);
            }
        }
        if (this.dragonFight == null && (world = this.level()) instanceof WorldServer && (var1 = ((WorldServer)(var0 = (WorldServer)world)).getDragonFight()) != null && this.getUUID().equals(var1.getDragonUUID())) {
            this.dragonFight = var1;
        }
        this.oFlapTime = this.flapTime;
        if (this.isDeadOrDying()) {
            float var02 = (this.random.nextFloat() - 0.5f) * 8.0f;
            float var12 = (this.random.nextFloat() - 0.5f) * 4.0f;
            float var22 = (this.random.nextFloat() - 0.5f) * 8.0f;
            this.level().addParticle(Particles.EXPLOSION, this.getX() + (double)var02, this.getY() + 2.0 + (double)var12, this.getZ() + (double)var22, 0.0, 0.0, 0.0);
            return;
        }
        this.checkCrystals();
        var0 = this.getDeltaMovement();
        float var13 = 0.2f / ((float)((Vec3D)var0).horizontalDistance() * 10.0f + 1.0f);
        this.flapTime = this.phaseManager.getCurrentPhase().isSitting() ? (this.flapTime += 0.1f) : (this.inWall ? (this.flapTime += var13 * 0.5f) : (this.flapTime += (var13 *= (float)Math.pow(2.0, ((Vec3D)var0).y))));
        this.setYRot(MathHelper.wrapDegrees(this.getYRot()));
        if (this.isNoAi()) {
            this.flapTime = 0.5f;
            return;
        }
        this.flightHistory.record(this.getY(), this.getYRot());
        World world2 = this.level();
        if (!(world2 instanceof WorldServer)) {
            this.interpolation.interpolate();
            this.phaseManager.getCurrentPhase().doClientTick();
        } else {
            Vec3D var4;
            var2 = (Vec3D[])world2;
            IDragonController var3 = this.phaseManager.getCurrentPhase();
            var3.doServerTick((WorldServer)var2);
            if (this.phaseManager.getCurrentPhase() != var3) {
                var3 = this.phaseManager.getCurrentPhase();
                var3.doServerTick((WorldServer)var2);
            }
            if ((var4 = var3.getFlyTargetLocation()) != null) {
                double var5 = var4.x - this.getX();
                double var7 = var4.y - this.getY();
                double var9 = var4.z - this.getZ();
                double var11 = var5 * var5 + var7 * var7 + var9 * var9;
                float var132 = var3.getFlySpeed();
                double var14 = Math.sqrt(var5 * var5 + var9 * var9);
                if (var14 > 0.0) {
                    var7 = MathHelper.clamp(var7 / var14, (double)(-var132), (double)var132);
                }
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, var7 * 0.01, 0.0));
                this.setYRot(MathHelper.wrapDegrees(this.getYRot()));
                Vec3D var16 = var4.subtract(this.getX(), this.getY(), this.getZ()).normalize();
                Vec3D var17 = new Vec3D(MathHelper.sin(this.getYRot() * ((float)Math.PI / 180)), this.getDeltaMovement().y, -MathHelper.cos(this.getYRot() * ((float)Math.PI / 180))).normalize();
                var18 = Math.max(((float)var17.dot(var16) + 0.5f) / 1.5f, 0.0f);
                if (Math.abs(var5) > (double)1.0E-5f || Math.abs(var9) > (double)1.0E-5f) {
                    var19 = MathHelper.clamp(MathHelper.wrapDegrees(180.0f - (float)MathHelper.atan2(var5, var9) * 57.295776f - this.getYRot()), -50.0f, 50.0f);
                    this.yRotA *= 0.8f;
                    this.yRotA += var19 * var3.getTurnSpeed();
                    this.setYRot(this.getYRot() + this.yRotA * 0.1f);
                }
                var19 = (float)(2.0 / (var11 + 1.0));
                var20 = 0.06f;
                this.moveRelative(0.06f * (var18 * var19 + (1.0f - var19)), new Vec3D(0.0, 0.0, -1.0));
                if (this.inWall) {
                    this.move(EnumMoveType.SELF, this.getDeltaMovement().scale(0.8f));
                } else {
                    this.move(EnumMoveType.SELF, this.getDeltaMovement());
                }
                Vec3D var21 = this.getDeltaMovement().normalize();
                double var22 = 0.8 + 0.15 * (var21.dot(var17) + 1.0) / 2.0;
                this.setDeltaMovement(this.getDeltaMovement().multiply(var22, 0.91f, var22));
            }
        }
        if (!this.level().isClientSide()) {
            this.applyEffectsFromBlocks();
        }
        this.yBodyRot = this.getYRot();
        var2 = new Vec3D[this.subEntities.length];
        for (int var3 = 0; var3 < this.subEntities.length; ++var3) {
            var2[var3] = new Vec3D(this.subEntities[var3].getX(), this.subEntities[var3].getY(), this.subEntities[var3].getZ());
        }
        float var3 = (float)(this.flightHistory.get(5).y() - this.flightHistory.get(10).y()) * 10.0f * ((float)Math.PI / 180);
        float var4 = MathHelper.cos(var3);
        float var5 = MathHelper.sin(var3);
        float var6 = this.getYRot() * ((float)Math.PI / 180);
        float var7 = MathHelper.sin(var6);
        float var8 = MathHelper.cos(var6);
        this.tickPart(this.body, var7 * 0.5f, 0.0, -var8 * 0.5f);
        this.tickPart(this.wing1, var8 * 4.5f, 2.0, var7 * 4.5f);
        this.tickPart(this.wing2, var8 * -4.5f, 2.0, var7 * -4.5f);
        World world3 = this.level();
        if (world3 instanceof WorldServer) {
            WorldServer var9 = (WorldServer)world3;
            if (this.hurtTime == 0) {
                this.knockBack(var9, var9.getEntities(this, this.wing1.getBoundingBox().inflate(4.0, 2.0, 4.0).move(0.0, -2.0, 0.0), IEntitySelector.NO_CREATIVE_OR_SPECTATOR));
                this.knockBack(var9, var9.getEntities(this, this.wing2.getBoundingBox().inflate(4.0, 2.0, 4.0).move(0.0, -2.0, 0.0), IEntitySelector.NO_CREATIVE_OR_SPECTATOR));
                this.hurt(var9, var9.getEntities(this, this.head.getBoundingBox().inflate(1.0), IEntitySelector.NO_CREATIVE_OR_SPECTATOR));
                this.hurt(var9, var9.getEntities(this, this.neck.getBoundingBox().inflate(1.0), IEntitySelector.NO_CREATIVE_OR_SPECTATOR));
            }
        }
        float var9 = MathHelper.sin(this.getYRot() * ((float)Math.PI / 180) - this.yRotA * 0.01f);
        float var10 = MathHelper.cos(this.getYRot() * ((float)Math.PI / 180) - this.yRotA * 0.01f);
        float var11 = this.getHeadYOffset();
        this.tickPart(this.head, var9 * 6.5f * var4, var11 + var5 * 6.5f, -var10 * 6.5f * var4);
        this.tickPart(this.neck, var9 * 5.5f * var4, var11 + var5 * 5.5f, -var10 * 5.5f * var4);
        DragonFlightHistory.a var12 = this.flightHistory.get(5);
        for (int var133 = 0; var133 < 3; ++var133) {
            EntityComplexPart var14 = null;
            if (var133 == 0) {
                var14 = this.tail1;
            }
            if (var133 == 1) {
                var14 = this.tail2;
            }
            if (var133 == 2) {
                var14 = this.tail3;
            }
            DragonFlightHistory.a var15 = this.flightHistory.get(12 + var133 * 2);
            float var16 = this.getYRot() * ((float)Math.PI / 180) + this.rotWrap(var15.yRot() - var12.yRot()) * ((float)Math.PI / 180);
            float var17 = MathHelper.sin(var16);
            var18 = MathHelper.cos(var16);
            var19 = 1.5f;
            var20 = (float)(var133 + 1) * 2.0f;
            this.tickPart(var14, -(var7 * 1.5f + var17 * var20) * var4, var15.y() - var12.y() - (double)((var20 + 1.5f) * var5) + 1.5, (var8 * 1.5f + var18 * var20) * var4);
        }
        World world4 = this.level();
        if (world4 instanceof WorldServer) {
            WorldServer var134 = (WorldServer)world4;
            this.inWall = this.checkWalls(var134, this.head.getBoundingBox()) | this.checkWalls(var134, this.neck.getBoundingBox()) | this.checkWalls(var134, this.body.getBoundingBox());
            if (this.dragonFight != null) {
                this.dragonFight.updateDragon(this);
            }
        }
        for (int var135 = 0; var135 < this.subEntities.length; ++var135) {
            this.subEntities[var135].xo = var2[var135].x;
            this.subEntities[var135].yo = var2[var135].y;
            this.subEntities[var135].zo = var2[var135].z;
            this.subEntities[var135].xOld = var2[var135].x;
            this.subEntities[var135].yOld = var2[var135].y;
            this.subEntities[var135].zOld = var2[var135].z;
        }
    }

    private void tickPart(EntityComplexPart var0, double var1, double var3, double var5) {
        var0.setPos(this.getX() + var1, this.getY() + var3, this.getZ() + var5);
    }

    private float getHeadYOffset() {
        if (this.phaseManager.getCurrentPhase().isSitting()) {
            return -1.0f;
        }
        DragonFlightHistory.a var0 = this.flightHistory.get(5);
        DragonFlightHistory.a var1 = this.flightHistory.get(0);
        return (float)(var0.y() - var1.y());
    }

    private void checkCrystals() {
        if (this.nearestCrystal != null) {
            if (this.nearestCrystal.isRemoved()) {
                this.nearestCrystal = null;
            } else if (this.tickCount % 10 == 0 && this.getHealth() < this.getMaxHealth()) {
                this.setHealth(this.getHealth() + 1.0f);
            }
        }
        if (this.random.nextInt(10) == 0) {
            List<EntityEnderCrystal> var0 = this.level().getEntitiesOfClass(EntityEnderCrystal.class, this.getBoundingBox().inflate(32.0));
            EntityEnderCrystal var1 = null;
            double var2 = Double.MAX_VALUE;
            for (EntityEnderCrystal var5 : var0) {
                double var6 = var5.distanceToSqr(this);
                if (!(var6 < var2)) continue;
                var2 = var6;
                var1 = var5;
            }
            this.nearestCrystal = var1;
        }
    }

    private void knockBack(WorldServer var0, List<Entity> var1) {
        double var2 = (this.body.getBoundingBox().minX + this.body.getBoundingBox().maxX) / 2.0;
        double var4 = (this.body.getBoundingBox().minZ + this.body.getBoundingBox().maxZ) / 2.0;
        for (Entity var7 : var1) {
            if (!(var7 instanceof EntityLiving)) continue;
            EntityLiving var8 = (EntityLiving)var7;
            double var9 = var7.getX() - var2;
            double var11 = var7.getZ() - var4;
            double var13 = Math.max(var9 * var9 + var11 * var11, 0.1);
            var7.push(var9 / var13 * 4.0, 0.2f, var11 / var13 * 4.0);
            if (this.phaseManager.getCurrentPhase().isSitting() || var8.getLastHurtByMobTimestamp() >= var7.tickCount - 2) continue;
            DamageSource var15 = this.damageSources().mobAttack(this);
            var7.hurtServer(var0, var15, 5.0f);
            EnchantmentManager.doPostAttackEffects(var0, var7, var15);
        }
    }

    private void hurt(WorldServer var0, List<Entity> var1) {
        for (Entity var3 : var1) {
            if (!(var3 instanceof EntityLiving)) continue;
            DamageSource var4 = this.damageSources().mobAttack(this);
            var3.hurtServer(var0, var4, 10.0f);
            EnchantmentManager.doPostAttackEffects(var0, var3, var4);
        }
    }

    private float rotWrap(double var0) {
        return (float)MathHelper.wrapDegrees(var0);
    }

    private boolean checkWalls(WorldServer var0, AxisAlignedBB var1) {
        int var2 = MathHelper.floor(var1.minX);
        int var3 = MathHelper.floor(var1.minY);
        int var4 = MathHelper.floor(var1.minZ);
        int var5 = MathHelper.floor(var1.maxX);
        int var6 = MathHelper.floor(var1.maxY);
        int var7 = MathHelper.floor(var1.maxZ);
        boolean var8 = false;
        boolean var9 = false;
        for (int var10 = var2; var10 <= var5; ++var10) {
            for (int var11 = var3; var11 <= var6; ++var11) {
                for (int var12 = var4; var12 <= var7; ++var12) {
                    BlockPosition var13 = new BlockPosition(var10, var11, var12);
                    IBlockData var14 = var0.getBlockState(var13);
                    if (var14.isAir() || var14.is(TagsBlock.DRAGON_TRANSPARENT)) continue;
                    if (!var0.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) || var14.is(TagsBlock.DRAGON_IMMUNE)) {
                        var8 = true;
                        continue;
                    }
                    var9 = var0.removeBlock(var13, false) || var9;
                }
            }
        }
        if (var9) {
            BlockPosition var10 = new BlockPosition(var2 + this.random.nextInt(var5 - var2 + 1), var3 + this.random.nextInt(var6 - var3 + 1), var4 + this.random.nextInt(var7 - var4 + 1));
            var0.levelEvent(2008, var10, 0);
        }
        return var8;
    }

    public boolean hurt(WorldServer var0, EntityComplexPart var1, DamageSource var2, float var3) {
        if (this.phaseManager.getCurrentPhase().getPhase() == DragonControllerPhase.DYING) {
            return false;
        }
        var3 = this.phaseManager.getCurrentPhase().onHurt(var2, var3);
        if (var1 != this.head) {
            var3 = var3 / 4.0f + Math.min(var3, 1.0f);
        }
        if (var3 < 0.01f) {
            return false;
        }
        if (var2.getEntity() instanceof EntityHuman || var2.is(DamageTypeTags.ALWAYS_HURTS_ENDER_DRAGONS)) {
            float var4 = this.getHealth();
            this.reallyHurt(var0, var2, var3);
            if (this.isDeadOrDying() && !this.phaseManager.getCurrentPhase().isSitting()) {
                this.setHealth(1.0f);
                this.phaseManager.setPhase(DragonControllerPhase.DYING);
            }
            if (this.phaseManager.getCurrentPhase().isSitting()) {
                this.sittingDamageReceived = this.sittingDamageReceived + var4 - this.getHealth();
                if (this.sittingDamageReceived > 0.25f * this.getMaxHealth()) {
                    this.sittingDamageReceived = 0.0f;
                    this.phaseManager.setPhase(DragonControllerPhase.TAKEOFF);
                }
            }
        }
        return true;
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        return this.hurt(var0, this.body, var1, var2);
    }

    protected void reallyHurt(WorldServer var0, DamageSource var1, float var2) {
        super.hurtServer(var0, var1, var2);
    }

    @Override
    public void kill(WorldServer var0) {
        this.remove(Entity.RemovalReason.KILLED);
        this.gameEvent(GameEvent.ENTITY_DIE);
        if (this.dragonFight != null) {
            this.dragonFight.updateDragon(this);
            this.dragonFight.setDragonKilled(this);
        }
    }

    @Override
    protected void tickDeath() {
        World world;
        Object var22;
        if (this.dragonFight != null) {
            this.dragonFight.updateDragon(this);
        }
        ++this.dragonDeathTime;
        if (this.dragonDeathTime >= 180 && this.dragonDeathTime <= 200) {
            float var0 = (this.random.nextFloat() - 0.5f) * 8.0f;
            float var1 = (this.random.nextFloat() - 0.5f) * 4.0f;
            float var22 = (this.random.nextFloat() - 0.5f) * 8.0f;
            this.level().addParticle(Particles.EXPLOSION_EMITTER, this.getX() + (double)var0, this.getY() + 2.0 + (double)var1, this.getZ() + (double)var22, 0.0, 0.0, 0.0);
        }
        int var0 = 500;
        if (this.dragonFight != null && !this.dragonFight.hasPreviouslyKilledDragon()) {
            var0 = 12000;
        }
        if ((var22 = this.level()) instanceof WorldServer) {
            WorldServer var1 = (WorldServer)var22;
            if (this.dragonDeathTime > 150 && this.dragonDeathTime % 5 == 0 && var1.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
                EntityExperienceOrb.award(var1, this.position(), MathHelper.floor((float)var0 * 0.08f));
            }
            if (this.dragonDeathTime == 1 && !this.isSilent()) {
                var1.globalLevelEvent(1028, this.blockPosition(), 0);
            }
        }
        Vec3D var1 = new Vec3D(0.0, 0.1f, 0.0);
        this.move(EnumMoveType.SELF, var1);
        for (EntityComplexPart var5 : this.subEntities) {
            var5.setOldPosAndRot();
            var5.setPos(var5.position().add(var1));
        }
        if (this.dragonDeathTime == 200 && (world = this.level()) instanceof WorldServer) {
            var22 = (WorldServer)world;
            if (((WorldServer)var22).getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
                EntityExperienceOrb.award((WorldServer)var22, this.position(), MathHelper.floor((float)var0 * 0.2f));
            }
            if (this.dragonFight != null) {
                this.dragonFight.setDragonKilled(this);
            }
            this.remove(Entity.RemovalReason.KILLED);
            this.gameEvent(GameEvent.ENTITY_DIE);
        }
    }

    public int findClosestNode() {
        if (this.nodes[0] == null) {
            for (int var0 = 0; var0 < 24; ++var0) {
                int var4;
                int var3;
                int var1 = 5;
                int var2 = var0;
                if (var0 < 12) {
                    var3 = MathHelper.floor(60.0f * MathHelper.cos(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)var2)));
                    var4 = MathHelper.floor(60.0f * MathHelper.sin(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)var2)));
                } else if (var0 < 20) {
                    var3 = MathHelper.floor(40.0f * MathHelper.cos(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)(var2 -= 12))));
                    var4 = MathHelper.floor(40.0f * MathHelper.sin(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)var2)));
                    var1 += 10;
                } else {
                    var3 = MathHelper.floor(20.0f * MathHelper.cos(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)(var2 -= 20))));
                    var4 = MathHelper.floor(20.0f * MathHelper.sin(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)var2)));
                }
                int var5 = Math.max(73, this.level().getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPosition(var3, 0, var4)).getY() + var1);
                this.nodes[var0] = new PathPoint(var3, var5, var4);
            }
            this.nodeAdjacency[0] = 6146;
            this.nodeAdjacency[1] = 8197;
            this.nodeAdjacency[2] = 8202;
            this.nodeAdjacency[3] = 16404;
            this.nodeAdjacency[4] = 32808;
            this.nodeAdjacency[5] = 32848;
            this.nodeAdjacency[6] = 65696;
            this.nodeAdjacency[7] = 131392;
            this.nodeAdjacency[8] = 131712;
            this.nodeAdjacency[9] = 263424;
            this.nodeAdjacency[10] = 526848;
            this.nodeAdjacency[11] = 525313;
            this.nodeAdjacency[12] = 1581057;
            this.nodeAdjacency[13] = 3166214;
            this.nodeAdjacency[14] = 2138120;
            this.nodeAdjacency[15] = 6373424;
            this.nodeAdjacency[16] = 4358208;
            this.nodeAdjacency[17] = 12910976;
            this.nodeAdjacency[18] = 9044480;
            this.nodeAdjacency[19] = 9706496;
            this.nodeAdjacency[20] = 15216640;
            this.nodeAdjacency[21] = 0xD0E000;
            this.nodeAdjacency[22] = 11763712;
            this.nodeAdjacency[23] = 0x7E0000;
        }
        return this.findClosestNode(this.getX(), this.getY(), this.getZ());
    }

    public int findClosestNode(double var0, double var2, double var4) {
        float var6 = 10000.0f;
        int var7 = 0;
        PathPoint var8 = new PathPoint(MathHelper.floor(var0), MathHelper.floor(var2), MathHelper.floor(var4));
        int var9 = 0;
        if (this.dragonFight == null || this.dragonFight.getCrystalsAlive() == 0) {
            var9 = 12;
        }
        for (int var10 = var9; var10 < 24; ++var10) {
            float var11;
            if (this.nodes[var10] == null || !((var11 = this.nodes[var10].distanceToSqr(var8)) < var6)) continue;
            var6 = var11;
            var7 = var10;
        }
        return var7;
    }

    @Nullable
    public PathEntity findPath(int var0, int var1, @Nullable PathPoint var2) {
        PathPoint var4;
        for (int var3 = 0; var3 < 24; ++var3) {
            var4 = this.nodes[var3];
            var4.closed = false;
            var4.f = 0.0f;
            var4.g = 0.0f;
            var4.h = 0.0f;
            var4.cameFrom = null;
            var4.heapIdx = -1;
        }
        PathPoint var3 = this.nodes[var0];
        var4 = this.nodes[var1];
        var3.g = 0.0f;
        var3.f = var3.h = var3.distanceTo(var4);
        this.openSet.clear();
        this.openSet.insert(var3);
        PathPoint var5 = var3;
        int var6 = 0;
        if (this.dragonFight == null || this.dragonFight.getCrystalsAlive() == 0) {
            var6 = 12;
        }
        while (!this.openSet.isEmpty()) {
            int var9;
            PathPoint var7 = this.openSet.pop();
            if (var7.equals(var4)) {
                if (var2 != null) {
                    var2.cameFrom = var4;
                    var4 = var2;
                }
                return this.reconstructPath(var3, var4);
            }
            if (var7.distanceTo(var4) < var5.distanceTo(var4)) {
                var5 = var7;
            }
            var7.closed = true;
            int var8 = 0;
            for (var9 = 0; var9 < 24; ++var9) {
                if (this.nodes[var9] != var7) continue;
                var8 = var9;
                break;
            }
            for (var9 = var6; var9 < 24; ++var9) {
                if ((this.nodeAdjacency[var8] & 1 << var9) <= 0) continue;
                PathPoint var10 = this.nodes[var9];
                if (var10.closed) continue;
                float var11 = var7.g + var7.distanceTo(var10);
                if (var10.inOpenSet() && !(var11 < var10.g)) continue;
                var10.cameFrom = var7;
                var10.g = var11;
                var10.h = var10.distanceTo(var4);
                if (var10.inOpenSet()) {
                    this.openSet.changeCost(var10, var10.g + var10.h);
                    continue;
                }
                var10.f = var10.g + var10.h;
                this.openSet.insert(var10);
            }
        }
        if (var5 == var3) {
            return null;
        }
        LOGGER.debug("Failed to find path from {} to {}", (Object)var0, (Object)var1);
        if (var2 != null) {
            var2.cameFrom = var5;
            var5 = var2;
        }
        return this.reconstructPath(var3, var5);
    }

    private PathEntity reconstructPath(PathPoint var0, PathPoint var1) {
        ArrayList var2 = Lists.newArrayList();
        PathPoint var3 = var1;
        var2.add(0, var3);
        while (var3.cameFrom != null) {
            var3 = var3.cameFrom;
            var2.add(0, var3);
        }
        return new PathEntity(var2, new BlockPosition(var1.x, var1.y, var1.z), true);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt(DRAGON_PHASE_KEY, this.phaseManager.getCurrentPhase().getPhase().getId());
        var0.putInt(DRAGON_DEATH_TIME_KEY, this.dragonDeathTime);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var02) {
        super.readAdditionalSaveData(var02);
        var02.getInt(DRAGON_PHASE_KEY).ifPresent(var0 -> this.phaseManager.setPhase(DragonControllerPhase.getById(var0)));
        this.dragonDeathTime = var02.getIntOr(DRAGON_DEATH_TIME_KEY, 0);
    }

    @Override
    public void checkDespawn() {
    }

    public EntityComplexPart[] getSubEntities() {
        return this.subEntities;
    }

    @Override
    public boolean isPickable() {
        return false;
    }

    @Override
    public SoundCategory getSoundSource() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.ENDER_DRAGON_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.ENDER_DRAGON_HURT;
    }

    @Override
    protected float getSoundVolume() {
        return 5.0f;
    }

    public Vec3D getHeadLookVector(float var0) {
        Vec3D var3;
        IDragonController var1 = this.phaseManager.getCurrentPhase();
        DragonControllerPhase<? extends IDragonController> var2 = var1.getPhase();
        if (var2 == DragonControllerPhase.LANDING || var2 == DragonControllerPhase.TAKEOFF) {
            BlockPosition var4 = this.level().getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, WorldGenEndTrophy.getLocation(this.fightOrigin));
            float var5 = Math.max((float)Math.sqrt(var4.distToCenterSqr(this.position())) / 4.0f, 1.0f);
            float var6 = 6.0f / var5;
            float var7 = this.getXRot();
            float var8 = 1.5f;
            this.setXRot(-var6 * 1.5f * 5.0f);
            var3 = this.getViewVector(var0);
            this.setXRot(var7);
        } else if (var1.isSitting()) {
            float var4 = this.getXRot();
            float var5 = 1.5f;
            this.setXRot(-45.0f);
            var3 = this.getViewVector(var0);
            this.setXRot(var4);
        } else {
            var3 = this.getViewVector(var0);
        }
        return var3;
    }

    public void onCrystalDestroyed(WorldServer var0, EntityEnderCrystal var1, BlockPosition var2, DamageSource var3) {
        EntityHuman var5;
        Entity entity = var3.getEntity();
        EntityHuman var4 = entity instanceof EntityHuman ? (var5 = (EntityHuman)entity) : var0.getNearestPlayer(CRYSTAL_DESTROY_TARGETING, var2.getX(), var2.getY(), var2.getZ());
        if (var1 == this.nearestCrystal) {
            this.hurt(var0, this.head, this.damageSources().explosion(var1, var4), 10.0f);
        }
        this.phaseManager.getCurrentPhase().onCrystalDestroyed(var1, var2, var3, var4);
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (DATA_PHASE.equals(var0) && this.level().isClientSide) {
            this.phaseManager.setPhase(DragonControllerPhase.getById(this.getEntityData().get(DATA_PHASE)));
        }
        super.onSyncedDataUpdated(var0);
    }

    public DragonControllerManager getPhaseManager() {
        return this.phaseManager;
    }

    @Nullable
    public EnderDragonBattle getDragonFight() {
        return this.dragonFight;
    }

    @Override
    public boolean addEffect(MobEffect var0, @Nullable Entity var1) {
        return false;
    }

    @Override
    protected boolean canRide(Entity var0) {
        return false;
    }

    @Override
    public boolean canUsePortal(boolean var0) {
        return false;
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity var0) {
        super.recreateFromPacket(var0);
        EntityComplexPart[] var1 = this.getSubEntities();
        for (int var2 = 0; var2 < var1.length; ++var2) {
            var1[var2].setId(var2 + var0.getId() + 1);
        }
    }

    @Override
    public boolean canAttack(EntityLiving var0) {
        return var0.canBeSeenAsEnemy();
    }

    @Override
    protected float sanitizeScale(float var0) {
        return 1.0f;
    }
}

