/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.sniffer;

import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.sniffer.SnifferAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;

public class Sniffer
extends EntityAnimal {
    private static final int DIGGING_PARTICLES_DELAY_TICKS = 1700;
    private static final int DIGGING_PARTICLES_DURATION_TICKS = 6000;
    private static final int DIGGING_PARTICLES_AMOUNT = 30;
    private static final int DIGGING_DROP_SEED_OFFSET_TICKS = 120;
    private static final int SNIFFER_BABY_AGE_TICKS = 48000;
    private static final float DIGGING_BB_HEIGHT_OFFSET = 0.4f;
    private static final EntitySize DIGGING_DIMENSIONS = EntitySize.scalable(EntityTypes.SNIFFER.getWidth(), EntityTypes.SNIFFER.getHeight() - 0.4f).withEyeHeight(0.81f);
    private static final DataWatcherObject<State> DATA_STATE = DataWatcher.defineId(Sniffer.class, DataWatcherRegistry.SNIFFER_STATE);
    private static final DataWatcherObject<Integer> DATA_DROP_SEED_AT_TICK = DataWatcher.defineId(Sniffer.class, DataWatcherRegistry.INT);
    public final AnimationState feelingHappyAnimationState = new AnimationState();
    public final AnimationState scentingAnimationState = new AnimationState();
    public final AnimationState sniffingAnimationState = new AnimationState();
    public final AnimationState diggingAnimationState = new AnimationState();
    public final AnimationState risingAnimationState = new AnimationState();

    public static AttributeProvider.Builder createAttributes() {
        return EntityAnimal.createAnimalAttributes().add(GenericAttributes.MOVEMENT_SPEED, 0.1f).add(GenericAttributes.MAX_HEALTH, 14.0);
    }

    public Sniffer(EntityTypes<? extends EntityAnimal> var0, World var1) {
        super(var0, var1);
        this.getNavigation().setCanFloat(true);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_CAUTIOUS, -1.0f);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_STATE, State.IDLING);
        var0.define(DATA_DROP_SEED_AT_TICK, 0);
    }

    @Override
    public void onPathfindingStart() {
        super.onPathfindingStart();
        if (this.isOnFire() || this.isInWater()) {
            this.setPathfindingMalus(PathType.WATER, 0.0f);
        }
    }

    @Override
    public void onPathfindingDone() {
        this.setPathfindingMalus(PathType.WATER, -1.0f);
    }

    @Override
    public EntitySize getDefaultDimensions(EntityPose var0) {
        if (this.getState() == State.DIGGING) {
            return DIGGING_DIMENSIONS.scale(this.getAgeScale());
        }
        return super.getDefaultDimensions(var0);
    }

    public boolean isSearching() {
        return this.getState() == State.SEARCHING;
    }

    public boolean isTempted() {
        return this.brain.getMemory(MemoryModuleType.IS_TEMPTED).orElse(false);
    }

    public boolean canSniff() {
        return !this.isTempted() && !this.isPanicking() && !this.isInWater() && !this.isInLove() && this.onGround() && !this.isPassenger() && !this.isLeashed();
    }

    public boolean canPlayDiggingSound() {
        return this.getState() == State.DIGGING || this.getState() == State.SEARCHING;
    }

    private BlockPosition getHeadBlock() {
        Vec3D var0 = this.getHeadPosition();
        return BlockPosition.containing(var0.x(), this.getY() + (double)0.2f, var0.z());
    }

    private Vec3D getHeadPosition() {
        return this.position().add(this.getForward().scale(2.25));
    }

    @Override
    public boolean supportQuadLeash() {
        return true;
    }

    @Override
    public Vec3D[] getQuadLeashOffsets() {
        return Leashable.createQuadLeashOffsets(this, -0.01, 0.63, 0.38, 1.15);
    }

    public State getState() {
        return this.entityData.get(DATA_STATE);
    }

    private Sniffer setState(State var0) {
        this.entityData.set(DATA_STATE, var0);
        return this;
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (DATA_STATE.equals(var0)) {
            State var1 = this.getState();
            this.resetAnimations();
            switch (var1.ordinal()) {
                case 2: {
                    this.scentingAnimationState.startIfStopped(this.tickCount);
                    break;
                }
                case 3: {
                    this.sniffingAnimationState.startIfStopped(this.tickCount);
                    break;
                }
                case 5: {
                    this.diggingAnimationState.startIfStopped(this.tickCount);
                    break;
                }
                case 6: {
                    this.risingAnimationState.startIfStopped(this.tickCount);
                    break;
                }
                case 1: {
                    this.feelingHappyAnimationState.startIfStopped(this.tickCount);
                }
            }
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(var0);
    }

    private void resetAnimations() {
        this.diggingAnimationState.stop();
        this.sniffingAnimationState.stop();
        this.risingAnimationState.stop();
        this.feelingHappyAnimationState.stop();
        this.scentingAnimationState.stop();
    }

    public Sniffer transitionTo(State var0) {
        switch (var0.ordinal()) {
            case 0: {
                this.setState(State.IDLING);
                break;
            }
            case 2: {
                this.setState(State.SCENTING).onScentingStart();
                break;
            }
            case 3: {
                this.playSound(SoundEffects.SNIFFER_SNIFFING, 1.0f, 1.0f);
                this.setState(State.SNIFFING);
                break;
            }
            case 4: {
                this.setState(State.SEARCHING);
                break;
            }
            case 5: {
                this.setState(State.DIGGING).onDiggingStart();
                break;
            }
            case 6: {
                this.playSound(SoundEffects.SNIFFER_DIGGING_STOP, 1.0f, 1.0f);
                this.setState(State.RISING);
                break;
            }
            case 1: {
                this.playSound(SoundEffects.SNIFFER_HAPPY, 1.0f, 1.0f);
                this.setState(State.FEELING_HAPPY);
            }
        }
        return this;
    }

    private Sniffer onScentingStart() {
        this.playSound(SoundEffects.SNIFFER_SCENTING, 1.0f, this.isBaby() ? 1.3f : 1.0f);
        return this;
    }

    private Sniffer onDiggingStart() {
        this.entityData.set(DATA_DROP_SEED_AT_TICK, this.tickCount + 120);
        this.level().broadcastEntityEvent(this, (byte)63);
        return this;
    }

    public Sniffer onDiggingComplete(boolean var0) {
        if (var0) {
            this.storeExploredPosition(this.getOnPos());
        }
        return this;
    }

    public Optional<BlockPosition> calculateDigPosition() {
        return IntStream.range(0, 5).mapToObj(var0 -> LandRandomPos.getPos(this, 10 + 2 * var0, 3)).filter(Objects::nonNull).map(BlockPosition::containing).filter(var0 -> this.level().getWorldBorder().isWithinBounds((BlockPosition)var0)).map(BlockPosition::below).filter(this::canDig).findFirst();
    }

    public boolean canDig() {
        return !this.isPanicking() && !this.isTempted() && !this.isBaby() && !this.isInWater() && this.onGround() && !this.isPassenger() && this.canDig(this.getHeadBlock().below());
    }

    private boolean canDig(BlockPosition var0) {
        return this.level().getBlockState(var0).is(TagsBlock.SNIFFER_DIGGABLE_BLOCK) && this.getExploredPositions().noneMatch(var1 -> GlobalPos.of(this.level().dimension(), var0).equals(var1)) && Optional.ofNullable(this.getNavigation().createPath(var0, 1)).map(PathEntity::canReach).orElse(false) != false;
    }

    private void dropSeed() {
        WorldServer var0;
        block3: {
            block2: {
                World world = this.level();
                if (!(world instanceof WorldServer)) break block2;
                var0 = (WorldServer)world;
                if (this.entityData.get(DATA_DROP_SEED_AT_TICK) == this.tickCount) break block3;
            }
            return;
        }
        BlockPosition var12 = this.getHeadBlock();
        this.dropFromGiftLootTable(var0, LootTables.SNIFFER_DIGGING, (var1, var2) -> {
            EntityItem var3 = new EntityItem(this.level(), var12.getX(), var12.getY(), var12.getZ(), (ItemStack)var2);
            var3.setDefaultPickUpDelay();
            var1.addFreshEntity(var3);
        });
        this.playSound(SoundEffects.SNIFFER_DROP_SEED, 1.0f, 1.0f);
    }

    private Sniffer emitDiggingParticles(AnimationState var0) {
        boolean var1;
        boolean bl = var1 = var0.getTimeInMillis(this.tickCount) > 1700L && var0.getTimeInMillis(this.tickCount) < 6000L;
        if (var1) {
            BlockPosition var2 = this.getHeadBlock();
            IBlockData var3 = this.level().getBlockState(var2.below());
            if (var3.getRenderShape() != EnumRenderType.INVISIBLE) {
                for (int var4 = 0; var4 < 30; ++var4) {
                    Vec3D var5 = Vec3D.atCenterOf(var2).add(0.0, -0.65f, 0.0);
                    this.level().addParticle(new ParticleParamBlock(Particles.BLOCK, var3), var5.x, var5.y, var5.z, 0.0, 0.0, 0.0);
                }
                if (this.tickCount % 10 == 0) {
                    this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), var3.getSoundType().getHitSound(), this.getSoundSource(), 0.5f, 0.5f, false);
                }
            }
        }
        if (this.tickCount % 10 == 0) {
            this.level().gameEvent(GameEvent.ENTITY_ACTION, this.getHeadBlock(), GameEvent.a.of(this));
        }
        return this;
    }

    public Sniffer storeExploredPosition(BlockPosition var0) {
        List var1 = this.getExploredPositions().limit(20L).collect(Collectors.toList());
        var1.add(0, GlobalPos.of(this.level().dimension(), var0));
        this.getBrain().setMemory(MemoryModuleType.SNIFFER_EXPLORED_POSITIONS, var1);
        return this;
    }

    public Stream<GlobalPos> getExploredPositions() {
        return this.getBrain().getMemory(MemoryModuleType.SNIFFER_EXPLORED_POSITIONS).stream().flatMap(Collection::stream);
    }

    @Override
    public void jumpFromGround() {
        double var2;
        super.jumpFromGround();
        double var0 = this.moveControl.getSpeedModifier();
        if (var0 > 0.0 && (var2 = this.getDeltaMovement().horizontalDistanceSqr()) < 0.01) {
            this.moveRelative(0.1f, new Vec3D(0.0, 0.0, 1.0));
        }
    }

    @Override
    public void spawnChildFromBreeding(WorldServer var0, EntityAnimal var1) {
        ItemStack var2 = new ItemStack(Items.SNIFFER_EGG);
        EntityItem var3 = new EntityItem(var0, this.position().x(), this.position().y(), this.position().z(), var2);
        var3.setDefaultPickUpDelay();
        this.finalizeSpawnChildFromBreeding(var0, var1, null);
        this.playSound(SoundEffects.SNIFFER_EGG_PLOP, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.5f);
        var0.addFreshEntity(var3);
    }

    @Override
    public void die(DamageSource var0) {
        this.transitionTo(State.IDLING);
        super.die(var0);
    }

    @Override
    public void tick() {
        switch (this.getState().ordinal()) {
            case 5: {
                this.emitDiggingParticles(this.diggingAnimationState).dropSeed();
                break;
            }
            case 4: {
                this.playSearchingSound();
            }
        }
        super.tick();
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        boolean var3 = this.isFood(var2);
        EnumInteractionResult var4 = super.mobInteract(var0, var1);
        if (var4.consumesAction() && var3) {
            this.playEatingSound();
        }
        return var4;
    }

    @Override
    protected void playEatingSound() {
        this.level().playSound(null, this, SoundEffects.SNIFFER_EAT, SoundCategory.NEUTRAL, 1.0f, MathHelper.randomBetween(this.level().random, 0.8f, 1.2f));
    }

    private void playSearchingSound() {
        if (this.level().isClientSide() && this.tickCount % 20 == 0) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEffects.SNIFFER_SEARCHING, this.getSoundSource(), 1.0f, 1.0f, false);
        }
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.SNIFFER_STEP, 0.15f, 1.0f);
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return Set.of(State.DIGGING, State.SEARCHING).contains((Object)this.getState()) ? null : SoundEffects.SNIFFER_IDLE;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.SNIFFER_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.SNIFFER_DEATH;
    }

    @Override
    public int getMaxHeadYRot() {
        return 50;
    }

    @Override
    public void setBaby(boolean var0) {
        this.setAge(var0 ? -48000 : 0);
    }

    @Override
    public EntityAgeable getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        return EntityTypes.SNIFFER.create(var0, EntitySpawnReason.BREEDING);
    }

    @Override
    public boolean canMate(EntityAnimal var0) {
        if (var0 instanceof Sniffer) {
            Sniffer var1 = (Sniffer)var0;
            Set<State> var2 = Set.of(State.IDLING, State.SCENTING, State.FEELING_HAPPY);
            return var2.contains((Object)this.getState()) && var2.contains((Object)var1.getState()) && super.canMate(var0);
        }
        return false;
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return var0.is(TagsItem.SNIFFER_FOOD);
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        return SnifferAi.makeBrain(this.brainProvider().makeBrain(var0));
    }

    public BehaviorController<Sniffer> getBrain() {
        return super.getBrain();
    }

    protected BehaviorController.b<Sniffer> brainProvider() {
        return BehaviorController.provider(SnifferAi.MEMORY_TYPES, SnifferAi.SENSOR_TYPES);
    }

    @Override
    protected void customServerAiStep(WorldServer var0) {
        GameProfilerFiller var1 = Profiler.get();
        var1.push("snifferBrain");
        this.getBrain().tick(var0, this);
        var1.popPush("snifferActivityUpdate");
        SnifferAi.updateActivity(this);
        var1.pop();
        super.customServerAiStep(var0);
    }

    @Override
    protected void sendDebugPackets() {
        super.sendDebugPackets();
        PacketDebug.sendEntityBrain(this);
    }

    public static final class State
    extends Enum<State> {
        public static final /* enum */ State IDLING = new State(0);
        public static final /* enum */ State FEELING_HAPPY = new State(1);
        public static final /* enum */ State SCENTING = new State(2);
        public static final /* enum */ State SNIFFING = new State(3);
        public static final /* enum */ State SEARCHING = new State(4);
        public static final /* enum */ State DIGGING = new State(5);
        public static final /* enum */ State RISING = new State(6);
        public static final IntFunction<State> BY_ID;
        public static final StreamCodec<ByteBuf, State> STREAM_CODEC;
        private final int id;
        private static final /* synthetic */ State[] k;

        public static State[] values() {
            return (State[])k.clone();
        }

        public static State valueOf(String var0) {
            return Enum.valueOf(State.class, var0);
        }

        private State(int var2) {
            this.id = var2;
        }

        public int id() {
            return this.id;
        }

        private static /* synthetic */ State[] b() {
            return new State[]{IDLING, FEELING_HAPPY, SCENTING, SNIFFING, SEARCHING, DIGGING, RISING};
        }

        static {
            k = State.b();
            BY_ID = ByIdMap.continuous(State::id, State.values(), ByIdMap.a.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, State::id);
        }
    }
}

