/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.logging.LogUtils;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.TagValueOutput;
import org.slf4j.Logger;

public abstract class EntityPerchable
extends EntityTameableAnimal {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int RIDE_COOLDOWN = 100;
    private int rideCooldownCounter;

    protected EntityPerchable(EntityTypes<? extends EntityPerchable> var0, World var1) {
        super((EntityTypes<? extends EntityTameableAnimal>)var0, var1);
    }

    public boolean setEntityOnShoulder(EntityPlayer var0) {
        try (ProblemReporter.j var1 = new ProblemReporter.j(this.problemPath(), LOGGER);){
            TagValueOutput var2 = TagValueOutput.createWithContext(var1, this.registryAccess());
            this.saveWithoutId(var2);
            var2.putString("id", this.getEncodeId());
            if (var0.setEntityOnShoulder(var2.buildResult())) {
                this.discard();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public void tick() {
        ++this.rideCooldownCounter;
        super.tick();
    }

    public boolean canSitOnShoulder() {
        return this.rideCooldownCounter > 100;
    }
}

