/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.animal.AbstractCow;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;

public class EntityMushroomCow
extends AbstractCow
implements IShearable {
    private static final DataWatcherObject<Integer> DATA_TYPE = DataWatcher.defineId(EntityMushroomCow.class, DataWatcherRegistry.INT);
    private static final int MUTATE_CHANCE = 1024;
    private static final String TAG_STEW_EFFECTS = "stew_effects";
    @Nullable
    public SuspiciousStewEffects stewEffects;
    @Nullable
    private UUID lastLightningBoltUUID;

    public EntityMushroomCow(EntityTypes<? extends EntityMushroomCow> var0, World var1) {
        super((EntityTypes<? extends AbstractCow>)var0, var1);
    }

    @Override
    public float getWalkTargetValue(BlockPosition var0, IWorldReader var1) {
        if (var1.getBlockState(var0.below()).is(Blocks.MYCELIUM)) {
            return 10.0f;
        }
        return var1.getPathfindingCostFromLightLevels(var0);
    }

    public static boolean checkMushroomSpawnRules(EntityTypes<EntityMushroomCow> var0, GeneratorAccess var1, EntitySpawnReason var2, BlockPosition var3, RandomSource var4) {
        return var1.getBlockState(var3.below()).is(TagsBlock.MOOSHROOMS_SPAWNABLE_ON) && EntityMushroomCow.isBrightEnoughToSpawn(var1, var3);
    }

    @Override
    public void thunderHit(WorldServer var0, EntityLightning var1) {
        UUID var2 = var1.getUUID();
        if (!var2.equals(this.lastLightningBoltUUID)) {
            this.setVariant(this.getVariant() == Type.RED ? Type.BROWN : Type.RED);
            this.lastLightningBoltUUID = var2;
            this.playSound(SoundEffects.MOOSHROOM_CONVERT, 2.0f, 1.0f);
        }
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_TYPE, Type.DEFAULT.id);
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        if (var2.is(Items.BOWL) && !this.isBaby()) {
            ItemStack var3;
            boolean var4 = false;
            if (this.stewEffects != null) {
                var4 = true;
                var3 = new ItemStack(Items.SUSPICIOUS_STEW);
                var3.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, this.stewEffects);
                this.stewEffects = null;
            } else {
                var3 = new ItemStack(Items.MUSHROOM_STEW);
            }
            ItemStack var5 = ItemLiquidUtil.createFilledResult(var2, var0, var3, false);
            var0.setItemInHand(var1, var5);
            SoundEffect var6 = var4 ? SoundEffects.MOOSHROOM_MILK_SUSPICIOUSLY : SoundEffects.MOOSHROOM_MILK;
            this.playSound(var6, 1.0f, 1.0f);
            return EnumInteractionResult.SUCCESS;
        }
        if (var2.is(Items.SHEARS) && this.readyForShearing()) {
            World var4 = this.level();
            if (var4 instanceof WorldServer) {
                WorldServer var3 = (WorldServer)var4;
                this.shear(var3, SoundCategory.PLAYERS, var2);
                this.gameEvent(GameEvent.SHEAR, var0);
                var2.hurtAndBreak(1, (EntityLiving)var0, EntityMushroomCow.getSlotForHand(var1));
            }
            return EnumInteractionResult.SUCCESS;
        }
        if (this.getVariant() == Type.BROWN) {
            Optional<SuspiciousStewEffects> var3 = this.getEffectsFromItemStack(var2);
            if (var3.isEmpty()) {
                return super.mobInteract(var0, var1);
            }
            if (this.stewEffects != null) {
                for (int var4 = 0; var4 < 2; ++var4) {
                    this.level().addParticle(Particles.SMOKE, this.getX() + this.random.nextDouble() / 2.0, this.getY(0.5), this.getZ() + this.random.nextDouble() / 2.0, 0.0, this.random.nextDouble() / 5.0, 0.0);
                }
            } else {
                var2.consume(1, var0);
                for (int var4 = 0; var4 < 4; ++var4) {
                    this.level().addParticle(Particles.EFFECT, this.getX() + this.random.nextDouble() / 2.0, this.getY(0.5), this.getZ() + this.random.nextDouble() / 2.0, 0.0, this.random.nextDouble() / 5.0, 0.0);
                }
                this.stewEffects = var3.get();
                this.playSound(SoundEffects.MOOSHROOM_EAT, 2.0f, 1.0f);
            }
            return EnumInteractionResult.SUCCESS;
        }
        return super.mobInteract(var0, var1);
    }

    @Override
    public void shear(WorldServer var0, SoundCategory var1, ItemStack var22) {
        var0.playSound(null, this, SoundEffects.MOOSHROOM_SHEAR, var1, 1.0f, 1.0f);
        this.convertTo(EntityTypes.COW, ConversionParams.single(this, false, false), var2 -> {
            var0.sendParticles(Particles.EXPLOSION, this.getX(), this.getY(0.5), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
            this.dropFromShearingLootTable(var0, LootTables.SHEAR_MOOSHROOM, var22, (var0, var1) -> {
                for (EntityInsentient var2 = 0; var2 < var1.getCount(); ++var2) {
                    var0.addFreshEntity(new EntityItem(this.level(), this.getX(), this.getY(1.0), this.getZ(), var1.copyWithCount(1)));
                }
            });
        });
    }

    @Override
    public boolean readyForShearing() {
        return this.isAlive() && !this.isBaby();
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.store("Type", Type.CODEC, this.getVariant());
        var0.storeNullable(TAG_STEW_EFFECTS, SuspiciousStewEffects.CODEC, this.stewEffects);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.setVariant(var0.read("Type", Type.CODEC).orElse(Type.DEFAULT));
        this.stewEffects = var0.read(TAG_STEW_EFFECTS, SuspiciousStewEffects.CODEC).orElse(null);
    }

    private Optional<SuspiciousStewEffects> getEffectsFromItemStack(ItemStack var0) {
        SuspiciousEffectHolder var1 = SuspiciousEffectHolder.tryGet(var0.getItem());
        if (var1 != null) {
            return Optional.of(var1.getSuspiciousEffects());
        }
        return Optional.empty();
    }

    public void setVariant(Type var0) {
        this.entityData.set(DATA_TYPE, var0.id);
    }

    public Type getVariant() {
        return Type.byId(this.entityData.get(DATA_TYPE));
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> var0) {
        if (var0 == DataComponents.MOOSHROOM_VARIANT) {
            return EntityMushroomCow.castComponentValue(var0, this.getVariant());
        }
        return super.get(var0);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter var0) {
        this.applyImplicitComponentIfPresent(var0, DataComponents.MOOSHROOM_VARIANT);
        super.applyImplicitComponents(var0);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> var0, T var1) {
        if (var0 == DataComponents.MOOSHROOM_VARIANT) {
            this.setVariant(EntityMushroomCow.castComponentValue(DataComponents.MOOSHROOM_VARIANT, var1));
            return true;
        }
        return super.applyImplicitComponent(var0, var1);
    }

    @Override
    @Nullable
    public EntityMushroomCow getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        EntityMushroomCow var2 = EntityTypes.MOOSHROOM.create(var0, EntitySpawnReason.BREEDING);
        if (var2 != null) {
            var2.setVariant(this.getOffspringVariant((EntityMushroomCow)var1));
        }
        return var2;
    }

    private Type getOffspringVariant(EntityMushroomCow var0) {
        Type var2;
        Type var1 = this.getVariant();
        Type var3 = var1 == (var2 = var0.getVariant()) && this.random.nextInt(1024) == 0 ? (var1 == Type.BROWN ? Type.RED : Type.BROWN) : (this.random.nextBoolean() ? var1 : var2);
        return var3;
    }

    @Override
    @Nullable
    public /* synthetic */ EntityAgeable getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }

    public static final class Type
    extends Enum<Type>
    implements INamable {
        public static final /* enum */ Type RED = new Type("red", 0, Blocks.RED_MUSHROOM.defaultBlockState());
        public static final /* enum */ Type BROWN = new Type("brown", 1, Blocks.BROWN_MUSHROOM.defaultBlockState());
        public static final Type DEFAULT;
        public static final Codec<Type> CODEC;
        private static final IntFunction<Type> BY_ID;
        public static final StreamCodec<ByteBuf, Type> STREAM_CODEC;
        private final String type;
        final int id;
        private final IBlockData blockState;
        private static final /* synthetic */ Type[] j;

        public static Type[] values() {
            return (Type[])j.clone();
        }

        public static Type valueOf(String var0) {
            return Enum.valueOf(Type.class, var0);
        }

        private Type(String var2, int var3, IBlockData var4) {
            this.type = var2;
            this.id = var3;
            this.blockState = var4;
        }

        public IBlockData getBlockState() {
            return this.blockState;
        }

        @Override
        public String getSerializedName() {
            return this.type;
        }

        private int id() {
            return this.id;
        }

        static Type byId(int var0) {
            return BY_ID.apply(var0);
        }

        private static /* synthetic */ Type[] d() {
            return new Type[]{RED, BROWN};
        }

        static {
            j = Type.d();
            DEFAULT = RED;
            CODEC = INamable.fromEnum(Type::values);
            BY_ID = ByIdMap.continuous(Type::id, Type.values(), ByIdMap.a.CLAMP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Type::id);
        }
    }
}

