/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IReloadable;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ReloadableProfiled;
import net.minecraft.util.Unit;

public class Reloadable<S>
implements IReloadable {
    private static final int PREPARATION_PROGRESS_WEIGHT = 2;
    private static final int EXTRA_RELOAD_PROGRESS_WEIGHT = 2;
    private static final int LISTENER_PROGRESS_WEIGHT = 1;
    final CompletableFuture<Unit> allPreparations = new CompletableFuture();
    @Nullable
    private CompletableFuture<List<S>> allDone;
    final Set<IReloadListener> preparingListeners;
    private final int listenerCount;
    private final AtomicInteger startedTasks = new AtomicInteger();
    private final AtomicInteger finishedTasks = new AtomicInteger();
    private final AtomicInteger startedReloads = new AtomicInteger();
    private final AtomicInteger finishedReloads = new AtomicInteger();

    public static IReloadable of(IResourceManager var0, List<IReloadListener> var1, Executor var2, Executor var3, CompletableFuture<Unit> var4) {
        Reloadable<Void> var5 = new Reloadable<Void>(var1);
        var5.startTasks(var2, var3, var0, var1, a.SIMPLE, var4);
        return var5;
    }

    protected Reloadable(List<IReloadListener> var0) {
        this.listenerCount = var0.size();
        this.preparingListeners = new HashSet<IReloadListener>(var0);
    }

    protected void startTasks(Executor var0, Executor var1, IResourceManager var2, List<IReloadListener> var3, a<S> var4, CompletableFuture<?> var5) {
        this.allDone = this.prepareTasks(var0, var1, var2, var3, var4, var5);
    }

    protected CompletableFuture<List<S>> prepareTasks(Executor var0, Executor var12, IResourceManager var2, List<IReloadListener> var3, a<S> var4, CompletableFuture<?> var5) {
        Executor var6 = var1 -> {
            this.startedTasks.incrementAndGet();
            var0.execute(() -> {
                var1.run();
                this.finishedTasks.incrementAndGet();
            });
        };
        Executor var7 = var1 -> {
            this.startedReloads.incrementAndGet();
            var12.execute(() -> {
                var1.run();
                this.finishedReloads.incrementAndGet();
            });
        };
        this.startedTasks.incrementAndGet();
        var5.thenRun(this.finishedTasks::incrementAndGet);
        CompletableFuture<Object> var8 = var5;
        ArrayList<CompletableFuture<S>> var9 = new ArrayList<CompletableFuture<S>>();
        for (IReloadListener var11 : var3) {
            IReloadListener.a var122 = this.createBarrierForListener(var11, var8, var12);
            CompletableFuture<S> var13 = var4.create(var122, var2, var11, var6, var7);
            var9.add(var13);
            var8 = var13;
        }
        return SystemUtils.sequenceFailFast(var9);
    }

    private IReloadListener.a createBarrierForListener(final IReloadListener var0, final CompletableFuture<?> var1, final Executor var2) {
        return new IReloadListener.a(){

            @Override
            public <T> CompletableFuture<T> wait(T var02) {
                var2.execute(() -> {
                    Reloadable.this.preparingListeners.remove(var0);
                    if (Reloadable.this.preparingListeners.isEmpty()) {
                        Reloadable.this.allPreparations.complete(Unit.INSTANCE);
                    }
                });
                return Reloadable.this.allPreparations.thenCombine((CompletionStage)var1, (var1, var2) -> var02);
            }
        };
    }

    @Override
    public CompletableFuture<?> done() {
        return Objects.requireNonNull(this.allDone, "not started");
    }

    @Override
    public float getActualProgress() {
        int var0 = this.listenerCount - this.preparingListeners.size();
        float var1 = Reloadable.weightProgress(this.finishedTasks.get(), this.finishedReloads.get(), var0);
        float var2 = Reloadable.weightProgress(this.startedTasks.get(), this.startedReloads.get(), this.listenerCount);
        return var1 / var2;
    }

    private static int weightProgress(int var0, int var1, int var2) {
        return var0 * 2 + var1 * 2 + var2 * 1;
    }

    public static IReloadable create(IResourceManager var0, List<IReloadListener> var1, Executor var2, Executor var3, CompletableFuture<Unit> var4, boolean var5) {
        if (var5) {
            return ReloadableProfiled.of(var0, var1, var2, var3, var4);
        }
        return Reloadable.of(var0, var1, var2, var3, var4);
    }

    @FunctionalInterface
    protected static interface a<S> {
        public static final a<Void> SIMPLE = (var0, var1, var2, var3, var4) -> var2.reload(var0, var1, var3, var4);

        public CompletableFuture<S> create(IReloadListener.a var1, IResourceManager var2, IReloadListener var3, Executor var4, Executor var5);
    }
}

