/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.ChatDeserializer;
import org.slf4j.Logger;

public abstract class ResourcePackAbstract
implements IResourcePack {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackLocationInfo location;

    protected ResourcePackAbstract(PackLocationInfo var0) {
        this.location = var0;
    }

    @Override
    @Nullable
    public <T> T getMetadataSection(MetadataSectionType<T> var0) throws IOException {
        IoSupplier<InputStream> var1 = this.getRootResource("pack.mcmeta");
        if (var1 == null) {
            return null;
        }
        try (InputStream var2 = var1.get();){
            T t2 = ResourcePackAbstract.getMetadataFromStream(var0, var2);
            return t2;
        }
    }

    @Nullable
    public static <T> T getMetadataFromStream(MetadataSectionType<T> var0, InputStream var12) {
        JsonObject var2;
        try (BufferedReader var3 = new BufferedReader(new InputStreamReader(var12, StandardCharsets.UTF_8));){
            var2 = ChatDeserializer.parse(var3);
        }
        catch (Exception var32) {
            LOGGER.error("Couldn't load {} metadata", (Object)var0.name(), (Object)var32);
            return null;
        }
        if (!var2.has(var0.name())) {
            return null;
        }
        return var0.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)var2.get(var0.name())).ifError(var1 -> LOGGER.error("Couldn't load {} metadata: {}", (Object)var0.name(), var1)).result().orElse(null);
    }

    @Override
    public PackLocationInfo location() {
        return this.location;
    }
}

