/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentUUID;
import net.minecraft.commands.arguments.ResourceOrIdArgument;
import net.minecraft.core.Holder;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.common.ClientboundShowDialogPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;

public class DebugConfigCommand {
    public static void register(CommandDispatcher<CommandListenerWrapper> var02, CommandBuildContext var12) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("debugconfig").requires(net.minecraft.commands.CommandDispatcher.hasPermission(3))).then(net.minecraft.commands.CommandDispatcher.literal("config").then(net.minecraft.commands.CommandDispatcher.argument("target", ArgumentEntity.player()).executes(var0 -> DebugConfigCommand.config((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayer((CommandContext<CommandListenerWrapper>)var0, "target")))))).then(net.minecraft.commands.CommandDispatcher.literal("unconfig").then(net.minecraft.commands.CommandDispatcher.argument("target", ArgumentUUID.uuid()).suggests((var0, var1) -> ICompletionProvider.suggest(DebugConfigCommand.getUuidsInConfig(((CommandListenerWrapper)var0.getSource()).getServer()), var1)).executes(var0 -> DebugConfigCommand.unconfig((CommandListenerWrapper)var0.getSource(), ArgumentUUID.getUuid((CommandContext<CommandListenerWrapper>)var0, "target")))))).then(net.minecraft.commands.CommandDispatcher.literal("dialog").then(net.minecraft.commands.CommandDispatcher.argument("target", ArgumentUUID.uuid()).suggests((var0, var1) -> ICompletionProvider.suggest(DebugConfigCommand.getUuidsInConfig(((CommandListenerWrapper)var0.getSource()).getServer()), var1)).then(net.minecraft.commands.CommandDispatcher.argument("dialog", ResourceOrIdArgument.dialog(var12)).executes(var0 -> DebugConfigCommand.showDialog((CommandListenerWrapper)var0.getSource(), ArgumentUUID.getUuid((CommandContext<CommandListenerWrapper>)var0, "target"), ResourceOrIdArgument.getDialog((CommandContext<CommandListenerWrapper>)var0, "dialog")))))));
    }

    private static Iterable<String> getUuidsInConfig(MinecraftServer var0) {
        HashSet<String> var1 = new HashSet<String>();
        for (NetworkManager var3 : var0.getConnection().getConnections()) {
            PacketListener packetListener = var3.getPacketListener();
            if (!(packetListener instanceof ServerConfigurationPacketListenerImpl)) continue;
            ServerConfigurationPacketListenerImpl var4 = (ServerConfigurationPacketListenerImpl)packetListener;
            var1.add(var4.getOwner().getId().toString());
        }
        return var1;
    }

    private static int config(CommandListenerWrapper var0, EntityPlayer var1) {
        GameProfile var2 = var1.getGameProfile();
        var1.connection.switchToConfig();
        var0.sendSuccess(() -> IChatBaseComponent.literal("Switched player " + var2.getName() + "(" + String.valueOf(var2.getId()) + ") to config mode"), false);
        return 1;
    }

    @Nullable
    private static ServerConfigurationPacketListenerImpl findConfigPlayer(MinecraftServer var0, UUID var1) {
        for (NetworkManager var3 : var0.getConnection().getConnections()) {
            ServerConfigurationPacketListenerImpl var4;
            PacketListener packetListener = var3.getPacketListener();
            if (!(packetListener instanceof ServerConfigurationPacketListenerImpl) || !(var4 = (ServerConfigurationPacketListenerImpl)packetListener).getOwner().getId().equals(var1)) continue;
            return var4;
        }
        return null;
    }

    private static int unconfig(CommandListenerWrapper var0, UUID var1) {
        ServerConfigurationPacketListenerImpl var2 = DebugConfigCommand.findConfigPlayer(var0.getServer(), var1);
        if (var2 != null) {
            var2.returnToWorld();
            return 1;
        }
        var0.sendFailure(IChatBaseComponent.literal("Can't find player to unconfig"));
        return 0;
    }

    private static int showDialog(CommandListenerWrapper var0, UUID var1, Holder<Dialog> var2) {
        ServerConfigurationPacketListenerImpl var3 = DebugConfigCommand.findConfigPlayer(var0.getServer(), var1);
        if (var3 != null) {
            var3.send(new ClientboundShowDialogPacket(var2));
            return 1;
        }
        var0.sendFailure(IChatBaseComponent.literal("Can't find player to talk to"));
        return 0;
    }
}

