/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;

public class PacketPlayOutEntityHeadRotation
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayOutEntityHeadRotation> STREAM_CODEC = Packet.codec(PacketPlayOutEntityHeadRotation::write, PacketPlayOutEntityHeadRotation::new);
    private final int entityId;
    private final byte yHeadRot;

    public PacketPlayOutEntityHeadRotation(Entity var0, byte var1) {
        this.entityId = var0.getId();
        this.yHeadRot = var1;
    }

    private PacketPlayOutEntityHeadRotation(PacketDataSerializer var0) {
        this.entityId = var0.readVarInt();
        this.yHeadRot = var0.readByte();
    }

    private void write(PacketDataSerializer var0) {
        var0.writeVarInt(this.entityId);
        var0.writeByte(this.yHeadRot);
    }

    @Override
    public PacketType<PacketPlayOutEntityHeadRotation> type() {
        return GamePacketTypes.CLIENTBOUND_ROTATE_HEAD;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleRotateMob(this);
    }

    public Entity getEntity(World var0) {
        return var0.getEntity(this.entityId);
    }

    public float getYHeadRot() {
        return MathHelper.unpackDegrees(this.yHeadRot);
    }
}

