/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;

public interface DataComponentMap
extends Iterable<TypedDataComponent<?>>,
DataComponentGetter {
    public static final DataComponentMap EMPTY = new DataComponentMap(){

        @Override
        @Nullable
        public <T> T get(DataComponentType<? extends T> var0) {
            return null;
        }

        @Override
        public Set<DataComponentType<?>> keySet() {
            return Set.of();
        }

        @Override
        public Iterator<TypedDataComponent<?>> iterator() {
            return Collections.emptyIterator();
        }
    };
    public static final Codec<DataComponentMap> CODEC = DataComponentMap.makeCodecFromMap(DataComponentType.VALUE_MAP_CODEC);

    public static Codec<DataComponentMap> makeCodec(Codec<DataComponentType<?>> var0) {
        return DataComponentMap.makeCodecFromMap(Codec.dispatchedMap(var0, DataComponentType::codecOrThrow));
    }

    public static Codec<DataComponentMap> makeCodecFromMap(Codec<Map<DataComponentType<?>, Object>> var02) {
        return var02.flatComapMap(a::buildFromMapTrusted, var0 -> {
            int var1 = var0.size();
            if (var1 == 0) {
                return DataResult.success((Object)Reference2ObjectMaps.emptyMap());
            }
            Reference2ObjectArrayMap var2 = new Reference2ObjectArrayMap(var1);
            for (TypedDataComponent<?> var4 : var0) {
                if (var4.type().isTransient()) continue;
                var2.put(var4.type(), var4.value());
            }
            return DataResult.success((Object)var2);
        });
    }

    public static DataComponentMap composite(final DataComponentMap var0, final DataComponentMap var1) {
        return new DataComponentMap(){

            @Override
            @Nullable
            public <T> T get(DataComponentType<? extends T> var02) {
                T var12 = var1.get(var02);
                if (var12 != null) {
                    return var12;
                }
                return var0.get(var02);
            }

            @Override
            public Set<DataComponentType<?>> keySet() {
                return Sets.union(var0.keySet(), var1.keySet());
            }
        };
    }

    public static a builder() {
        return new a();
    }

    public Set<DataComponentType<?>> keySet();

    default public boolean has(DataComponentType<?> var0) {
        return this.get(var0) != null;
    }

    @Override
    default public Iterator<TypedDataComponent<?>> iterator() {
        return Iterators.transform(this.keySet().iterator(), var0 -> Objects.requireNonNull(this.getTyped(var0)));
    }

    default public Stream<TypedDataComponent<?>> stream() {
        return StreamSupport.stream(Spliterators.spliterator(this.iterator(), (long)this.size(), 1345), false);
    }

    default public int size() {
        return this.keySet().size();
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public DataComponentMap filter(final Predicate<DataComponentType<?>> var0) {
        return new DataComponentMap(){

            @Override
            @Nullable
            public <T> T get(DataComponentType<? extends T> var02) {
                return var0.test(var02) ? (T)DataComponentMap.this.get(var02) : null;
            }

            @Override
            public Set<DataComponentType<?>> keySet() {
                return Sets.filter(DataComponentMap.this.keySet(), var0::test);
            }
        };
    }

    public static class net.minecraft.core.component.DataComponentMap$a {
        private final Reference2ObjectMap<DataComponentType<?>, Object> map = new Reference2ObjectArrayMap();

        net.minecraft.core.component.DataComponentMap$a() {
        }

        public <T> net.minecraft.core.component.DataComponentMap$a set(DataComponentType<T> var0, @Nullable T var1) {
            this.setUnchecked(var0, var1);
            return this;
        }

        <T> void setUnchecked(DataComponentType<T> var0, @Nullable Object var1) {
            if (var1 != null) {
                this.map.put(var0, var1);
            } else {
                this.map.remove(var0);
            }
        }

        public net.minecraft.core.component.DataComponentMap$a addAll(DataComponentMap var0) {
            for (TypedDataComponent<?> var2 : var0) {
                this.map.put(var2.type(), var2.value());
            }
            return this;
        }

        public DataComponentMap build() {
            return net.minecraft.core.component.DataComponentMap$a.buildFromMapTrusted(this.map);
        }

        private static DataComponentMap buildFromMapTrusted(Map<DataComponentType<?>, Object> var0) {
            if (var0.isEmpty()) {
                return EMPTY;
            }
            if (var0.size() < 8) {
                return new a((Reference2ObjectMap<DataComponentType<?>, Object>)new Reference2ObjectArrayMap(var0));
            }
            return new a((Reference2ObjectMap<DataComponentType<?>, Object>)new Reference2ObjectOpenHashMap(var0));
        }

        record a(Reference2ObjectMap<DataComponentType<?>, Object> map) implements DataComponentMap
        {
            @Override
            @Nullable
            public <T> T get(DataComponentType<? extends T> var0) {
                return (T)this.map.get(var0);
            }

            @Override
            public boolean has(DataComponentType<?> var0) {
                return this.map.containsKey(var0);
            }

            @Override
            public Set<DataComponentType<?>> keySet() {
                return this.map.keySet();
            }

            @Override
            public Iterator<TypedDataComponent<?>> iterator() {
                return Iterators.transform((Iterator)Reference2ObjectMaps.fastIterator(this.map), TypedDataComponent::fromEntryUnchecked);
            }

            @Override
            public int size() {
                return this.map.size();
            }

            @Override
            public String toString() {
                return this.map.toString();
            }
        }
    }
}

