/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Iterators;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3D;
import org.jetbrains.annotations.Contract;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class EnumDirection
extends Enum<EnumDirection>
implements INamable {
    public static final /* enum */ EnumDirection DOWN = new EnumDirection(0, 1, -1, "down", EnumAxisDirection.NEGATIVE, EnumAxis.Y, new BaseBlockPosition(0, -1, 0));
    public static final /* enum */ EnumDirection UP = new EnumDirection(1, 0, -1, "up", EnumAxisDirection.POSITIVE, EnumAxis.Y, new BaseBlockPosition(0, 1, 0));
    public static final /* enum */ EnumDirection NORTH = new EnumDirection(2, 3, 2, "north", EnumAxisDirection.NEGATIVE, EnumAxis.Z, new BaseBlockPosition(0, 0, -1));
    public static final /* enum */ EnumDirection SOUTH = new EnumDirection(3, 2, 0, "south", EnumAxisDirection.POSITIVE, EnumAxis.Z, new BaseBlockPosition(0, 0, 1));
    public static final /* enum */ EnumDirection WEST = new EnumDirection(4, 5, 1, "west", EnumAxisDirection.NEGATIVE, EnumAxis.X, new BaseBlockPosition(-1, 0, 0));
    public static final /* enum */ EnumDirection EAST = new EnumDirection(5, 4, 3, "east", EnumAxisDirection.POSITIVE, EnumAxis.X, new BaseBlockPosition(1, 0, 0));
    public static final INamable.a<EnumDirection> CODEC;
    public static final Codec<EnumDirection> VERTICAL_CODEC;
    public static final IntFunction<EnumDirection> BY_ID;
    public static final StreamCodec<ByteBuf, EnumDirection> STREAM_CODEC;
    @Deprecated
    public static final Codec<EnumDirection> LEGACY_ID_CODEC;
    @Deprecated
    public static final Codec<EnumDirection> LEGACY_ID_CODEC_2D;
    private final int data3d;
    private final int oppositeIndex;
    private final int data2d;
    private final String name;
    private final EnumAxis axis;
    private final EnumAxisDirection axisDirection;
    private final BaseBlockPosition normal;
    private final Vec3D normalVec3;
    private final Vector3fc normalVec3f;
    private static final EnumDirection[] VALUES;
    private static final EnumDirection[] BY_3D_DATA;
    private static final EnumDirection[] BY_2D_DATA;
    private static final /* synthetic */ EnumDirection[] y;

    public static EnumDirection[] values() {
        return (EnumDirection[])y.clone();
    }

    public static EnumDirection valueOf(String var0) {
        return Enum.valueOf(EnumDirection.class, var0);
    }

    private EnumDirection(int var2, int var3, int var4, String var5, EnumAxisDirection var6, EnumAxis var7, BaseBlockPosition var8) {
        this.data3d = var2;
        this.data2d = var4;
        this.oppositeIndex = var3;
        this.name = var5;
        this.axis = var7;
        this.axisDirection = var6;
        this.normal = var8;
        this.normalVec3 = Vec3D.atLowerCornerOf(var8);
        this.normalVec3f = new Vector3f((float)var8.getX(), (float)var8.getY(), (float)var8.getZ());
    }

    public static EnumDirection[] orderedByNearest(Entity var0) {
        EnumDirection var17;
        float var1 = var0.getViewXRot(1.0f) * ((float)Math.PI / 180);
        float var2 = -var0.getViewYRot(1.0f) * ((float)Math.PI / 180);
        float var3 = MathHelper.sin(var1);
        float var4 = MathHelper.cos(var1);
        float var5 = MathHelper.sin(var2);
        float var6 = MathHelper.cos(var2);
        boolean var7 = var5 > 0.0f;
        boolean var8 = var3 < 0.0f;
        boolean var9 = var6 > 0.0f;
        float var10 = var7 ? var5 : -var5;
        float var11 = var8 ? -var3 : var3;
        float var12 = var9 ? var6 : -var6;
        float var13 = var10 * var4;
        float var14 = var12 * var4;
        EnumDirection var15 = var7 ? EAST : WEST;
        EnumDirection var16 = var8 ? UP : DOWN;
        EnumDirection enumDirection = var17 = var9 ? SOUTH : NORTH;
        if (var10 > var12) {
            if (var11 > var13) {
                return EnumDirection.makeDirectionArray(var16, var15, var17);
            }
            if (var14 > var11) {
                return EnumDirection.makeDirectionArray(var15, var17, var16);
            }
            return EnumDirection.makeDirectionArray(var15, var16, var17);
        }
        if (var11 > var14) {
            return EnumDirection.makeDirectionArray(var16, var17, var15);
        }
        if (var13 > var11) {
            return EnumDirection.makeDirectionArray(var17, var15, var16);
        }
        return EnumDirection.makeDirectionArray(var17, var16, var15);
    }

    private static EnumDirection[] makeDirectionArray(EnumDirection var0, EnumDirection var1, EnumDirection var2) {
        return new EnumDirection[]{var0, var1, var2, var2.getOpposite(), var1.getOpposite(), var0.getOpposite()};
    }

    public static EnumDirection rotate(Matrix4fc var0, EnumDirection var1) {
        Vector3f var2 = var0.transformDirection(var1.normalVec3f, new Vector3f());
        return EnumDirection.getApproximateNearest(var2.x(), var2.y(), var2.z());
    }

    public static Collection<EnumDirection> allShuffled(RandomSource var0) {
        return SystemUtils.shuffledCopy(EnumDirection.values(), var0);
    }

    public static Stream<EnumDirection> stream() {
        return Stream.of(VALUES);
    }

    public static float getYRot(EnumDirection var0) {
        return switch (var0.ordinal()) {
            case 2 -> 180.0f;
            case 3 -> 0.0f;
            case 4 -> 90.0f;
            case 5 -> -90.0f;
            default -> throw new IllegalStateException("No y-Rot for vertical axis: " + String.valueOf(var0));
        };
    }

    public Quaternionf getRotation() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new Quaternionf().rotationX((float)Math.PI);
            case 1 -> new Quaternionf();
            case 2 -> new Quaternionf().rotationXYZ(1.5707964f, 0.0f, (float)Math.PI);
            case 3 -> new Quaternionf().rotationX(1.5707964f);
            case 4 -> new Quaternionf().rotationXYZ(1.5707964f, 0.0f, 1.5707964f);
            case 5 -> new Quaternionf().rotationXYZ(1.5707964f, 0.0f, -1.5707964f);
        };
    }

    public int get3DDataValue() {
        return this.data3d;
    }

    public int get2DDataValue() {
        return this.data2d;
    }

    public EnumAxisDirection getAxisDirection() {
        return this.axisDirection;
    }

    public static EnumDirection getFacingAxis(Entity var0, EnumAxis var1) {
        return switch (var1.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (EAST.isFacingAngle(var0.getViewYRot(1.0f))) {
                    yield EAST;
                }
                yield WEST;
            }
            case 2 -> {
                if (SOUTH.isFacingAngle(var0.getViewYRot(1.0f))) {
                    yield SOUTH;
                }
                yield NORTH;
            }
            case 1 -> var0.getViewXRot(1.0f) < 0.0f ? UP : DOWN;
        };
    }

    public EnumDirection getOpposite() {
        return EnumDirection.from3DDataValue(this.oppositeIndex);
    }

    public EnumDirection getClockWise(EnumAxis var0) {
        return switch (var0.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (this == WEST || this == EAST) {
                    yield this;
                }
                yield this.getClockWiseX();
            }
            case 1 -> {
                if (this == UP || this == DOWN) {
                    yield this;
                }
                yield this.getClockWise();
            }
            case 2 -> this == NORTH || this == SOUTH ? this : this.getClockWiseZ();
        };
    }

    public EnumDirection getCounterClockWise(EnumAxis var0) {
        return switch (var0.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (this == WEST || this == EAST) {
                    yield this;
                }
                yield this.getCounterClockWiseX();
            }
            case 1 -> {
                if (this == UP || this == DOWN) {
                    yield this;
                }
                yield this.getCounterClockWise();
            }
            case 2 -> this == NORTH || this == SOUTH ? this : this.getCounterClockWiseZ();
        };
    }

    public EnumDirection getClockWise() {
        return switch (this.ordinal()) {
            case 2 -> EAST;
            case 5 -> SOUTH;
            case 3 -> WEST;
            case 4 -> NORTH;
            default -> throw new IllegalStateException("Unable to get Y-rotated facing of " + String.valueOf(this));
        };
    }

    private EnumDirection getClockWiseX() {
        return switch (this.ordinal()) {
            case 1 -> NORTH;
            case 2 -> DOWN;
            case 0 -> SOUTH;
            case 3 -> UP;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + String.valueOf(this));
        };
    }

    private EnumDirection getCounterClockWiseX() {
        return switch (this.ordinal()) {
            case 1 -> SOUTH;
            case 3 -> DOWN;
            case 0 -> NORTH;
            case 2 -> UP;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + String.valueOf(this));
        };
    }

    private EnumDirection getClockWiseZ() {
        return switch (this.ordinal()) {
            case 1 -> EAST;
            case 5 -> DOWN;
            case 0 -> WEST;
            case 4 -> UP;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + String.valueOf(this));
        };
    }

    private EnumDirection getCounterClockWiseZ() {
        return switch (this.ordinal()) {
            case 1 -> WEST;
            case 4 -> DOWN;
            case 0 -> EAST;
            case 5 -> UP;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + String.valueOf(this));
        };
    }

    public EnumDirection getCounterClockWise() {
        return switch (this.ordinal()) {
            case 2 -> WEST;
            case 5 -> NORTH;
            case 3 -> EAST;
            case 4 -> SOUTH;
            default -> throw new IllegalStateException("Unable to get CCW facing of " + String.valueOf(this));
        };
    }

    public int getStepX() {
        return this.normal.getX();
    }

    public int getStepY() {
        return this.normal.getY();
    }

    public int getStepZ() {
        return this.normal.getZ();
    }

    public Vector3f step() {
        return new Vector3f(this.normalVec3f);
    }

    public String getName() {
        return this.name;
    }

    public EnumAxis getAxis() {
        return this.axis;
    }

    @Nullable
    public static EnumDirection byName(@Nullable String var0) {
        return CODEC.byName(var0);
    }

    public static EnumDirection from3DDataValue(int var0) {
        return BY_3D_DATA[MathHelper.abs(var0 % BY_3D_DATA.length)];
    }

    public static EnumDirection from2DDataValue(int var0) {
        return BY_2D_DATA[MathHelper.abs(var0 % BY_2D_DATA.length)];
    }

    public static EnumDirection fromYRot(double var0) {
        return EnumDirection.from2DDataValue(MathHelper.floor(var0 / 90.0 + 0.5) & 3);
    }

    public static EnumDirection fromAxisAndDirection(EnumAxis var0, EnumAxisDirection var1) {
        return switch (var0.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (var1 == EnumAxisDirection.POSITIVE) {
                    yield EAST;
                }
                yield WEST;
            }
            case 1 -> {
                if (var1 == EnumAxisDirection.POSITIVE) {
                    yield UP;
                }
                yield DOWN;
            }
            case 2 -> var1 == EnumAxisDirection.POSITIVE ? SOUTH : NORTH;
        };
    }

    public float toYRot() {
        return (this.data2d & 3) * 90;
    }

    public static EnumDirection getRandom(RandomSource var0) {
        return SystemUtils.getRandom(VALUES, var0);
    }

    public static EnumDirection getApproximateNearest(double var0, double var2, double var4) {
        return EnumDirection.getApproximateNearest((float)var0, (float)var2, (float)var4);
    }

    public static EnumDirection getApproximateNearest(float var0, float var1, float var2) {
        EnumDirection var3 = NORTH;
        float var4 = Float.MIN_VALUE;
        for (EnumDirection var8 : VALUES) {
            float var9 = var0 * (float)var8.normal.getX() + var1 * (float)var8.normal.getY() + var2 * (float)var8.normal.getZ();
            if (!(var9 > var4)) continue;
            var4 = var9;
            var3 = var8;
        }
        return var3;
    }

    public static EnumDirection getApproximateNearest(Vec3D var0) {
        return EnumDirection.getApproximateNearest(var0.x, var0.y, var0.z);
    }

    @Nullable
    @Contract(value="_,_,_,!null->!null;_,_,_,_->_")
    public static EnumDirection getNearest(int var0, int var1, int var2, @Nullable EnumDirection var3) {
        int var4 = Math.abs(var0);
        int var5 = Math.abs(var1);
        int var6 = Math.abs(var2);
        if (var4 > var6 && var4 > var5) {
            return var0 < 0 ? WEST : EAST;
        }
        if (var6 > var4 && var6 > var5) {
            return var2 < 0 ? NORTH : SOUTH;
        }
        if (var5 > var4 && var5 > var6) {
            return var1 < 0 ? DOWN : UP;
        }
        return var3;
    }

    @Nullable
    @Contract(value="_,!null->!null;_,_->_")
    public static EnumDirection getNearest(BaseBlockPosition var0, @Nullable EnumDirection var1) {
        return EnumDirection.getNearest(var0.getX(), var0.getY(), var0.getZ(), var1);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    private static DataResult<EnumDirection> verifyVertical(EnumDirection var0) {
        return var0.getAxis().isVertical() ? DataResult.success((Object)var0) : DataResult.error(() -> "Expected a vertical direction");
    }

    public static EnumDirection get(EnumAxisDirection var0, EnumAxis var1) {
        for (EnumDirection var5 : VALUES) {
            if (var5.getAxisDirection() != var0 || var5.getAxis() != var1) continue;
            return var5;
        }
        throw new IllegalArgumentException("No such direction: " + String.valueOf((Object)var0) + " " + String.valueOf(var1));
    }

    public BaseBlockPosition getUnitVec3i() {
        return this.normal;
    }

    public Vec3D getUnitVec3() {
        return this.normalVec3;
    }

    public Vector3fc getUnitVec3f() {
        return this.normalVec3f;
    }

    public boolean isFacingAngle(float var0) {
        float var1 = var0 * ((float)Math.PI / 180);
        float var2 = -MathHelper.sin(var1);
        float var3 = MathHelper.cos(var1);
        return (float)this.normal.getX() * var2 + (float)this.normal.getZ() * var3 > 0.0f;
    }

    private static /* synthetic */ EnumDirection[] y() {
        return new EnumDirection[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
    }

    static {
        y = EnumDirection.y();
        CODEC = INamable.fromEnum(EnumDirection::values);
        VERTICAL_CODEC = CODEC.validate(EnumDirection::verifyVertical);
        BY_ID = ByIdMap.continuous(EnumDirection::get3DDataValue, EnumDirection.values(), ByIdMap.a.WRAP);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, EnumDirection::get3DDataValue);
        LEGACY_ID_CODEC = Codec.BYTE.xmap(EnumDirection::from3DDataValue, var0 -> (byte)var0.get3DDataValue());
        LEGACY_ID_CODEC_2D = Codec.BYTE.xmap(EnumDirection::from2DDataValue, var0 -> (byte)var0.get2DDataValue());
        VALUES = EnumDirection.values();
        BY_3D_DATA = (EnumDirection[])Arrays.stream(VALUES).sorted(Comparator.comparingInt(var0 -> var0.data3d)).toArray(EnumDirection[]::new);
        BY_2D_DATA = (EnumDirection[])Arrays.stream(VALUES).filter(var0 -> var0.getAxis().isHorizontal()).sorted(Comparator.comparingInt(var0 -> var0.data2d)).toArray(EnumDirection[]::new);
    }

    public static abstract sealed class EnumAxis
    extends Enum<EnumAxis>
    implements INamable,
    Predicate<EnumDirection> {
        public static final /* enum */ EnumAxis X = new EnumAxis("x"){

            @Override
            public int choose(int var0, int var1, int var2) {
                return var0;
            }

            @Override
            public boolean choose(boolean var0, boolean var1, boolean var2) {
                return var0;
            }

            @Override
            public double choose(double var0, double var2, double var4) {
                return var0;
            }

            @Override
            public EnumDirection getPositive() {
                return EAST;
            }

            @Override
            public EnumDirection getNegative() {
                return WEST;
            }

            @Override
            public /* synthetic */ boolean test(@Nullable Object object) {
                return super.test((EnumDirection)object);
            }
        };
        public static final /* enum */ EnumAxis Y = new EnumAxis("y"){

            @Override
            public int choose(int var0, int var1, int var2) {
                return var1;
            }

            @Override
            public double choose(double var0, double var2, double var4) {
                return var2;
            }

            @Override
            public boolean choose(boolean var0, boolean var1, boolean var2) {
                return var1;
            }

            @Override
            public EnumDirection getPositive() {
                return UP;
            }

            @Override
            public EnumDirection getNegative() {
                return DOWN;
            }

            @Override
            public /* synthetic */ boolean test(@Nullable Object object) {
                return super.test((EnumDirection)object);
            }
        };
        public static final /* enum */ EnumAxis Z = new EnumAxis("z"){

            @Override
            public int choose(int var0, int var1, int var2) {
                return var2;
            }

            @Override
            public double choose(double var0, double var2, double var4) {
                return var4;
            }

            @Override
            public boolean choose(boolean var0, boolean var1, boolean var2) {
                return var2;
            }

            @Override
            public EnumDirection getPositive() {
                return SOUTH;
            }

            @Override
            public EnumDirection getNegative() {
                return NORTH;
            }

            @Override
            public /* synthetic */ boolean test(@Nullable Object object) {
                return super.test((EnumDirection)object);
            }
        };
        public static final EnumAxis[] VALUES;
        public static final INamable.a<EnumAxis> CODEC;
        private final String name;
        private static final /* synthetic */ EnumAxis[] g;

        public static EnumAxis[] values() {
            return (EnumAxis[])g.clone();
        }

        public static EnumAxis valueOf(String var0) {
            return Enum.valueOf(EnumAxis.class, var0);
        }

        EnumAxis(String var2) {
            this.name = var2;
        }

        @Nullable
        public static EnumAxis byName(String var0) {
            return CODEC.byName(var0);
        }

        public String getName() {
            return this.name;
        }

        public boolean isVertical() {
            return this == Y;
        }

        public boolean isHorizontal() {
            return this == X || this == Z;
        }

        public abstract EnumDirection getPositive();

        public abstract EnumDirection getNegative();

        public EnumDirection[] getDirections() {
            return new EnumDirection[]{this.getPositive(), this.getNegative()};
        }

        public String toString() {
            return this.name;
        }

        public static EnumAxis getRandom(RandomSource var0) {
            return SystemUtils.getRandom(VALUES, var0);
        }

        @Override
        public boolean test(@Nullable EnumDirection var0) {
            return var0 != null && var0.getAxis() == this;
        }

        public EnumDirectionLimit getPlane() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 2 -> EnumDirectionLimit.HORIZONTAL;
                case 1 -> EnumDirectionLimit.VERTICAL;
            };
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public abstract int choose(int var1, int var2, int var3);

        public abstract double choose(double var1, double var3, double var5);

        public abstract boolean choose(boolean var1, boolean var2, boolean var3);

        @Override
        public /* synthetic */ boolean test(@Nullable Object object) {
            return this.test((EnumDirection)object);
        }

        private static /* synthetic */ EnumAxis[] i() {
            return new EnumAxis[]{X, Y, Z};
        }

        static {
            g = EnumAxis.i();
            VALUES = EnumAxis.values();
            CODEC = INamable.fromEnum(EnumAxis::values);
        }
    }

    public static final class EnumAxisDirection
    extends Enum<EnumAxisDirection> {
        public static final /* enum */ EnumAxisDirection POSITIVE = new EnumAxisDirection(1, "Towards positive");
        public static final /* enum */ EnumAxisDirection NEGATIVE = new EnumAxisDirection(-1, "Towards negative");
        private final int step;
        private final String name;
        private static final /* synthetic */ EnumAxisDirection[] e;

        public static EnumAxisDirection[] values() {
            return (EnumAxisDirection[])e.clone();
        }

        public static EnumAxisDirection valueOf(String var0) {
            return Enum.valueOf(EnumAxisDirection.class, var0);
        }

        private EnumAxisDirection(int var2, String var3) {
            this.step = var2;
            this.name = var3;
        }

        public int getStep() {
            return this.step;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public EnumAxisDirection opposite() {
            return this == POSITIVE ? NEGATIVE : POSITIVE;
        }

        private static /* synthetic */ EnumAxisDirection[] d() {
            return new EnumAxisDirection[]{POSITIVE, NEGATIVE};
        }

        static {
            e = EnumAxisDirection.d();
        }
    }

    public static final class EnumDirectionLimit
    extends Enum<EnumDirectionLimit>
    implements Iterable<EnumDirection>,
    Predicate<EnumDirection> {
        public static final /* enum */ EnumDirectionLimit HORIZONTAL = new EnumDirectionLimit(new EnumDirection[]{NORTH, EAST, SOUTH, WEST}, new EnumAxis[]{EnumAxis.X, EnumAxis.Z});
        public static final /* enum */ EnumDirectionLimit VERTICAL = new EnumDirectionLimit(new EnumDirection[]{UP, DOWN}, new EnumAxis[]{EnumAxis.Y});
        private final EnumDirection[] faces;
        private final EnumAxis[] axis;
        private static final /* synthetic */ EnumDirectionLimit[] e;

        public static EnumDirectionLimit[] values() {
            return (EnumDirectionLimit[])e.clone();
        }

        public static EnumDirectionLimit valueOf(String var0) {
            return Enum.valueOf(EnumDirectionLimit.class, var0);
        }

        private EnumDirectionLimit(EnumDirection[] var2, EnumAxis[] var3) {
            this.faces = var2;
            this.axis = var3;
        }

        public EnumDirection getRandomDirection(RandomSource var0) {
            return SystemUtils.getRandom(this.faces, var0);
        }

        public EnumAxis getRandomAxis(RandomSource var0) {
            return SystemUtils.getRandom(this.axis, var0);
        }

        @Override
        public boolean test(@Nullable EnumDirection var0) {
            return var0 != null && var0.getAxis().getPlane() == this;
        }

        @Override
        public Iterator<EnumDirection> iterator() {
            return Iterators.forArray((Object[])this.faces);
        }

        public Stream<EnumDirection> stream() {
            return Arrays.stream(this.faces);
        }

        public List<EnumDirection> shuffledCopy(RandomSource var0) {
            return SystemUtils.shuffledCopy(this.faces, var0);
        }

        public int length() {
            return this.faces.length;
        }

        @Override
        public /* synthetic */ boolean test(@Nullable Object object) {
            return this.test((EnumDirection)object);
        }

        private static /* synthetic */ EnumDirectionLimit[] c() {
            return new EnumDirectionLimit[]{HORIZONTAL, VERTICAL};
        }

        static {
            e = EnumDirectionLimit.c();
        }
    }
}

