/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.ARGB;

public class HexColorArgument
implements ArgumentType<Integer> {
    private static final Collection<String> EXAMPLES = Arrays.asList("F00", "FF0000");
    public static final DynamicCommandExceptionType ERROR_INVALID_HEX = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("argument.hexcolor.invalid", var0));

    private HexColorArgument() {
    }

    public static HexColorArgument hexColor() {
        return new HexColorArgument();
    }

    public static Integer getHexColor(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (Integer)var0.getArgument(var1, Integer.class);
    }

    public Integer parse(StringReader var0) throws CommandSyntaxException {
        String var1 = var0.readUnquotedString();
        return switch (var1.length()) {
            case 3 -> ARGB.color(Integer.valueOf(MessageFormat.format("{0}{0}", Character.valueOf(var1.charAt(0))), 16), Integer.valueOf(MessageFormat.format("{0}{0}", Character.valueOf(var1.charAt(1))), 16), Integer.valueOf(MessageFormat.format("{0}{0}", Character.valueOf(var1.charAt(2))), 16));
            case 6 -> ARGB.color(Integer.valueOf(var1.substring(0, 2), 16), Integer.valueOf(var1.substring(2, 4), 16), Integer.valueOf(var1.substring(4, 6), 16));
            default -> throw ERROR_INVALID_HEX.createWithContext((ImmutableStringReader)var0, (Object)var1);
        };
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        return ICompletionProvider.suggest(EXAMPLES, var1);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

