/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.phys.Vec3D;

public record TeleportTransition(WorldServer newLevel, Vec3D position, Vec3D deltaMovement, float yRot, float xRot, boolean missingRespawnBlock, boolean asPassenger, Set<Relative> relatives, a postTeleportTransition) {
    public static final a DO_NOTHING = var0 -> {};
    public static final a PLAY_PORTAL_SOUND = TeleportTransition::playPortalSound;
    public static final a PLACE_PORTAL_TICKET = TeleportTransition::placePortalTicket;

    public TeleportTransition(WorldServer var0, Vec3D var1, Vec3D var2, float var3, float var4, a var5) {
        this(var0, var1, var2, var3, var4, Set.of(), var5);
    }

    public TeleportTransition(WorldServer var0, Vec3D var1, Vec3D var2, float var3, float var4, Set<Relative> var5, a var6) {
        this(var0, var1, var2, var3, var4, false, false, var5, var6);
    }

    public TeleportTransition(WorldServer var0, Entity var1, a var2) {
        this(var0, TeleportTransition.findAdjustedSharedSpawnPos(var0, var1), Vec3D.ZERO, 0.0f, 0.0f, false, false, Set.of(), var2);
    }

    private static void playPortalSound(Entity var0) {
        if (var0 instanceof EntityPlayer) {
            EntityPlayer var1 = (EntityPlayer)var0;
            var1.connection.send(new PacketPlayOutWorldEvent(1032, BlockPosition.ZERO, 0, false));
        }
    }

    private static void placePortalTicket(Entity var0) {
        var0.placePortalTicket(BlockPosition.containing(var0.position()));
    }

    public static TeleportTransition missingRespawnBlock(WorldServer var0, Entity var1, a var2) {
        return new TeleportTransition(var0, TeleportTransition.findAdjustedSharedSpawnPos(var0, var1), Vec3D.ZERO, 0.0f, 0.0f, true, false, Set.of(), var2);
    }

    private static Vec3D findAdjustedSharedSpawnPos(WorldServer var0, Entity var1) {
        return var1.adjustSpawnLocation(var0, var0.getSharedSpawnPos()).getBottomCenter();
    }

    public TeleportTransition withRotation(float var0, float var1) {
        return new TeleportTransition(this.newLevel(), this.position(), this.deltaMovement(), var0, var1, this.missingRespawnBlock(), this.asPassenger(), this.relatives(), this.postTeleportTransition());
    }

    public TeleportTransition withPosition(Vec3D var0) {
        return new TeleportTransition(this.newLevel(), var0, this.deltaMovement(), this.yRot(), this.xRot(), this.missingRespawnBlock(), this.asPassenger(), this.relatives(), this.postTeleportTransition());
    }

    public TeleportTransition transitionAsPassenger() {
        return new TeleportTransition(this.newLevel(), this.position(), this.deltaMovement(), this.yRot(), this.xRot(), this.missingRespawnBlock(), true, this.relatives(), this.postTeleportTransition());
    }

    @FunctionalInterface
    public static interface a {
        public void onTransition(Entity var1);

        default public a then(a var0) {
            return var1 -> {
                this.onTransition(var1);
                var0.onTransition(var1);
            };
        }
    }
}

