/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.phys.Vec3D;

public class PathEntity {
    private final List<PathPoint> nodes;
    @Nullable
    private a debugData;
    private int nextNodeIndex;
    private final BlockPosition target;
    private final float distToTarget;
    private final boolean reached;

    public PathEntity(List<PathPoint> var0, BlockPosition var1, boolean var2) {
        this.nodes = var0;
        this.target = var1;
        this.distToTarget = var0.isEmpty() ? Float.MAX_VALUE : this.nodes.get(this.nodes.size() - 1).distanceManhattan(this.target);
        this.reached = var2;
    }

    public void advance() {
        ++this.nextNodeIndex;
    }

    public boolean notStarted() {
        return this.nextNodeIndex <= 0;
    }

    public boolean isDone() {
        return this.nextNodeIndex >= this.nodes.size();
    }

    @Nullable
    public PathPoint getEndNode() {
        if (!this.nodes.isEmpty()) {
            return this.nodes.get(this.nodes.size() - 1);
        }
        return null;
    }

    public PathPoint getNode(int var0) {
        return this.nodes.get(var0);
    }

    public void truncateNodes(int var0) {
        if (this.nodes.size() > var0) {
            this.nodes.subList(var0, this.nodes.size()).clear();
        }
    }

    public void replaceNode(int var0, PathPoint var1) {
        this.nodes.set(var0, var1);
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public int getNextNodeIndex() {
        return this.nextNodeIndex;
    }

    public void setNextNodeIndex(int var0) {
        this.nextNodeIndex = var0;
    }

    public Vec3D getEntityPosAtNode(Entity var0, int var1) {
        PathPoint var2 = this.nodes.get(var1);
        double var3 = (double)var2.x + (double)((int)(var0.getBbWidth() + 1.0f)) * 0.5;
        double var5 = var2.y;
        double var7 = (double)var2.z + (double)((int)(var0.getBbWidth() + 1.0f)) * 0.5;
        return new Vec3D(var3, var5, var7);
    }

    public BlockPosition getNodePos(int var0) {
        return this.nodes.get(var0).asBlockPos();
    }

    public Vec3D getNextEntityPos(Entity var0) {
        return this.getEntityPosAtNode(var0, this.nextNodeIndex);
    }

    public BlockPosition getNextNodePos() {
        return this.nodes.get(this.nextNodeIndex).asBlockPos();
    }

    public PathPoint getNextNode() {
        return this.nodes.get(this.nextNodeIndex);
    }

    @Nullable
    public PathPoint getPreviousNode() {
        return this.nextNodeIndex > 0 ? this.nodes.get(this.nextNodeIndex - 1) : null;
    }

    public boolean sameAs(@Nullable PathEntity var0) {
        if (var0 == null) {
            return false;
        }
        if (var0.nodes.size() != this.nodes.size()) {
            return false;
        }
        for (int var1 = 0; var1 < this.nodes.size(); ++var1) {
            PathPoint var2 = this.nodes.get(var1);
            PathPoint var3 = var0.nodes.get(var1);
            if (var2.x == var3.x && var2.y == var3.y && var2.z == var3.z) continue;
            return false;
        }
        return true;
    }

    public boolean canReach() {
        return this.reached;
    }

    @VisibleForDebug
    void setDebug(PathPoint[] var0, PathPoint[] var1, Set<PathDestination> var2) {
        this.debugData = new a(var0, var1, var2);
    }

    @Nullable
    public a debugData() {
        return this.debugData;
    }

    public void writeToStream(PacketDataSerializer var02) {
        if (this.debugData == null || this.debugData.targetNodes.isEmpty()) {
            return;
        }
        var02.writeBoolean(this.reached);
        var02.writeInt(this.nextNodeIndex);
        var02.writeBlockPos(this.target);
        var02.writeCollection(this.nodes, (var0, var1) -> var1.writeToStream((PacketDataSerializer)((Object)var0)));
        this.debugData.write(var02);
    }

    public static PathEntity createFromStream(PacketDataSerializer var0) {
        boolean var1 = var0.readBoolean();
        int var2 = var0.readInt();
        BlockPosition var3 = var0.readBlockPos();
        List<PathPoint> var4 = var0.readList(PathPoint::createFromStream);
        a var5 = a.read(var0);
        PathEntity var6 = new PathEntity(var4, var3, var1);
        var6.debugData = var5;
        var6.nextNodeIndex = var2;
        return var6;
    }

    public String toString() {
        return "Path(length=" + this.nodes.size() + ")";
    }

    public BlockPosition getTarget() {
        return this.target;
    }

    public float getDistToTarget() {
        return this.distToTarget;
    }

    static PathPoint[] readNodeArray(PacketDataSerializer var0) {
        PathPoint[] var1 = new PathPoint[var0.readVarInt()];
        for (int var2 = 0; var2 < var1.length; ++var2) {
            var1[var2] = PathPoint.createFromStream(var0);
        }
        return var1;
    }

    static void writeNodeArray(PacketDataSerializer var0, PathPoint[] var1) {
        var0.writeVarInt(var1.length);
        for (PathPoint var5 : var1) {
            var5.writeToStream(var0);
        }
    }

    public PathEntity copy() {
        PathEntity var0 = new PathEntity(this.nodes, this.target, this.reached);
        var0.debugData = this.debugData;
        var0.nextNodeIndex = this.nextNodeIndex;
        return var0;
    }

    public static final class a
    extends Record {
        private final PathPoint[] openSet;
        private final PathPoint[] closedSet;
        final Set<PathDestination> targetNodes;

        public a(PathPoint[] var0, PathPoint[] var1, Set<PathDestination> var2) {
            this.openSet = var0;
            this.closedSet = var1;
            this.targetNodes = var2;
        }

        public void write(PacketDataSerializer var02) {
            var02.writeCollection(this.targetNodes, (var0, var1) -> var1.writeToStream((PacketDataSerializer)((Object)var0)));
            PathEntity.writeNodeArray(var02, this.openSet);
            PathEntity.writeNodeArray(var02, this.closedSet);
        }

        public static a read(PacketDataSerializer var0) {
            HashSet var1 = var0.readCollection(HashSet::new, PathDestination::createFromStream);
            PathPoint[] var2 = PathEntity.readNodeArray(var0);
            PathPoint[] var3 = PathEntity.readNodeArray(var0);
            return new a(var2, var3, var1);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "openSet;closedSet;targetNodes", "openSet", "closedSet", "targetNodes"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "openSet;closedSet;targetNodes", "openSet", "closedSet", "targetNodes"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "openSet;closedSet;targetNodes", "openSet", "closedSet", "targetNodes"}, this, var0);
        }

        public PathPoint[] openSet() {
            return this.openSet;
        }

        public PathPoint[] closedSet() {
            return this.closedSet;
        }

        public Set<PathDestination> targetNodes() {
            return this.targetNodes;
        }
    }
}

