/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolEmpty;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorGravity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.apache.commons.lang3.mutable.MutableObject;

public class WorldGenFeatureDefinedStructurePoolTemplate {
    private static final int SIZE_UNSET = Integer.MIN_VALUE;
    private static final MutableObject<Codec<Holder<WorldGenFeatureDefinedStructurePoolTemplate>>> CODEC_REFERENCE = new MutableObject();
    public static final Codec<WorldGenFeatureDefinedStructurePoolTemplate> DIRECT_CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.lazyInitialized(() -> CODEC_REFERENCE.getValue()).fieldOf("fallback").forGetter(WorldGenFeatureDefinedStructurePoolTemplate::getFallback), (App)Codec.mapPair((MapCodec)WorldGenFeatureDefinedStructurePoolStructure.CODEC.fieldOf("element"), (MapCodec)Codec.intRange((int)1, (int)150).fieldOf("weight")).codec().listOf().fieldOf("elements").forGetter(var0 -> var0.rawTemplates)).apply((Applicative)var02, WorldGenFeatureDefinedStructurePoolTemplate::new));
    public static final Codec<Holder<WorldGenFeatureDefinedStructurePoolTemplate>> CODEC = SystemUtils.make(RegistryFileCodec.create(Registries.TEMPLATE_POOL, DIRECT_CODEC), arg_0 -> CODEC_REFERENCE.setValue(arg_0));
    private final List<Pair<WorldGenFeatureDefinedStructurePoolStructure, Integer>> rawTemplates;
    private final ObjectArrayList<WorldGenFeatureDefinedStructurePoolStructure> templates;
    private final Holder<WorldGenFeatureDefinedStructurePoolTemplate> fallback;
    private int maxSize = Integer.MIN_VALUE;

    public WorldGenFeatureDefinedStructurePoolTemplate(Holder<WorldGenFeatureDefinedStructurePoolTemplate> var0, List<Pair<WorldGenFeatureDefinedStructurePoolStructure, Integer>> var1) {
        this.rawTemplates = var1;
        this.templates = new ObjectArrayList();
        for (Pair<WorldGenFeatureDefinedStructurePoolStructure, Integer> var3 : var1) {
            WorldGenFeatureDefinedStructurePoolStructure var4 = (WorldGenFeatureDefinedStructurePoolStructure)var3.getFirst();
            for (int var5 = 0; var5 < (Integer)var3.getSecond(); ++var5) {
                this.templates.add((Object)var4);
            }
        }
        this.fallback = var0;
    }

    public WorldGenFeatureDefinedStructurePoolTemplate(Holder<WorldGenFeatureDefinedStructurePoolTemplate> var0, List<Pair<Function<Matching, ? extends WorldGenFeatureDefinedStructurePoolStructure>, Integer>> var1, Matching var2) {
        this.rawTemplates = Lists.newArrayList();
        this.templates = new ObjectArrayList();
        for (Pair<Function<Matching, ? extends WorldGenFeatureDefinedStructurePoolStructure>, Integer> var4 : var1) {
            WorldGenFeatureDefinedStructurePoolStructure var5 = (WorldGenFeatureDefinedStructurePoolStructure)((Function)var4.getFirst()).apply(var2);
            this.rawTemplates.add((Pair<WorldGenFeatureDefinedStructurePoolStructure, Integer>)Pair.of((Object)var5, (Object)((Integer)var4.getSecond())));
            for (int var6 = 0; var6 < (Integer)var4.getSecond(); ++var6) {
                this.templates.add((Object)var5);
            }
        }
        this.fallback = var0;
    }

    public int getMaxSize(StructureTemplateManager var02) {
        if (this.maxSize == Integer.MIN_VALUE) {
            this.maxSize = this.templates.stream().filter(var0 -> var0 != WorldGenFeatureDefinedStructurePoolEmpty.INSTANCE).mapToInt(var1 -> var1.getBoundingBox(var02, BlockPosition.ZERO, EnumBlockRotation.NONE).getYSpan()).max().orElse(0);
        }
        return this.maxSize;
    }

    @VisibleForTesting
    public List<Pair<WorldGenFeatureDefinedStructurePoolStructure, Integer>> getTemplates() {
        return this.rawTemplates;
    }

    public Holder<WorldGenFeatureDefinedStructurePoolTemplate> getFallback() {
        return this.fallback;
    }

    public WorldGenFeatureDefinedStructurePoolStructure getRandomTemplate(RandomSource var0) {
        if (this.templates.isEmpty()) {
            return WorldGenFeatureDefinedStructurePoolEmpty.INSTANCE;
        }
        return (WorldGenFeatureDefinedStructurePoolStructure)this.templates.get(var0.nextInt(this.templates.size()));
    }

    public List<WorldGenFeatureDefinedStructurePoolStructure> getShuffledTemplates(RandomSource var0) {
        return SystemUtils.shuffledCopy(this.templates, var0);
    }

    public int size() {
        return this.templates.size();
    }

    public static final class Matching
    extends Enum<Matching>
    implements INamable {
        public static final /* enum */ Matching TERRAIN_MATCHING = new Matching("terrain_matching", ImmutableList.of((Object)new DefinedStructureProcessorGravity(HeightMap.Type.WORLD_SURFACE_WG, -1)));
        public static final /* enum */ Matching RIGID = new Matching("rigid", ImmutableList.of());
        public static final INamable.a<Matching> CODEC;
        private final String name;
        private final ImmutableList<DefinedStructureProcessor> processors;
        private static final /* synthetic */ Matching[] f;

        public static Matching[] values() {
            return (Matching[])f.clone();
        }

        public static Matching valueOf(String var0) {
            return Enum.valueOf(Matching.class, var0);
        }

        private Matching(String var2, ImmutableList var3) {
            this.name = var2;
            this.processors = var3;
        }

        public String getName() {
            return this.name;
        }

        public static Matching byName(String var0) {
            return CODEC.byName(var0);
        }

        public ImmutableList<DefinedStructureProcessor> getProcessors() {
            return this.processors;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ Matching[] d() {
            return new Matching[]{TERRAIN_MATCHING, RIGID};
        }

        static {
            f = Matching.d();
            CODEC = INamable.fromEnum(Matching::values);
        }
    }
}

