/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class SurfaceWaterDepthFilter
extends PlacementFilter {
    public static final MapCodec<SurfaceWaterDepthFilter> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.INT.fieldOf("max_water_depth").forGetter(var0 -> var0.maxWaterDepth)).apply((Applicative)var02, SurfaceWaterDepthFilter::new));
    private final int maxWaterDepth;

    private SurfaceWaterDepthFilter(int var0) {
        this.maxWaterDepth = var0;
    }

    public static SurfaceWaterDepthFilter forMaxDepth(int var0) {
        return new SurfaceWaterDepthFilter(var0);
    }

    @Override
    protected boolean shouldPlace(PlacementContext var0, RandomSource var1, BlockPosition var2) {
        int var3 = var0.getHeight(HeightMap.Type.OCEAN_FLOOR, var2.getX(), var2.getZ());
        int var4 = var0.getHeight(HeightMap.Type.WORLD_SURFACE, var2.getX(), var2.getZ());
        return var4 - var3 <= this.maxWaterDepth;
    }

    @Override
    public PlacementModifierType<?> type() {
        return PlacementModifierType.SURFACE_WATER_DEPTH_FILTER;
    }
}

