/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.levelgen.feature.WorldGenTrees;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTree;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTrees;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;

public class PlaceOnGroundDecorator
extends WorldGenFeatureTree {
    public static final MapCodec<PlaceOnGroundDecorator> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)ExtraCodecs.POSITIVE_INT.fieldOf("tries").orElse((Object)128).forGetter(var0 -> var0.tries), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("radius").orElse((Object)2).forGetter(var0 -> var0.radius), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("height").orElse((Object)1).forGetter(var0 -> var0.height), (App)WorldGenFeatureStateProvider.CODEC.fieldOf("block_state_provider").forGetter(var0 -> var0.blockStateProvider)).apply((Applicative)var02, PlaceOnGroundDecorator::new));
    private final int tries;
    private final int radius;
    private final int height;
    private final WorldGenFeatureStateProvider blockStateProvider;

    public PlaceOnGroundDecorator(int var0, int var1, int var2, WorldGenFeatureStateProvider var3) {
        this.tries = var0;
        this.radius = var1;
        this.height = var2;
        this.blockStateProvider = var3;
    }

    @Override
    protected WorldGenFeatureTrees<?> type() {
        return WorldGenFeatureTrees.PLACE_ON_GROUND;
    }

    @Override
    public void place(WorldGenFeatureTree.a var0) {
        List<BlockPosition> var1 = WorldGenTrees.getLowestTrunkOrRootOfTree(var0);
        if (var1.isEmpty()) {
            return;
        }
        BlockPosition var2 = var1.getFirst();
        int var3 = var2.getY();
        int var4 = var2.getX();
        int var5 = var2.getX();
        int var6 = var2.getZ();
        int var7 = var2.getZ();
        for (BlockPosition blockPosition : var1) {
            if (blockPosition.getY() != var3) continue;
            var4 = Math.min(var4, blockPosition.getX());
            var5 = Math.max(var5, blockPosition.getX());
            var6 = Math.min(var6, blockPosition.getZ());
            var7 = Math.max(var7, blockPosition.getZ());
        }
        RandomSource var8 = var0.random();
        StructureBoundingBox structureBoundingBox = new StructureBoundingBox(var4, var3, var6, var5, var3, var7).inflatedBy(this.radius, this.height, this.radius);
        BlockPosition.MutableBlockPosition var10 = new BlockPosition.MutableBlockPosition();
        for (int var11 = 0; var11 < this.tries; ++var11) {
            var10.set(var8.nextIntBetweenInclusive(structureBoundingBox.minX(), structureBoundingBox.maxX()), var8.nextIntBetweenInclusive(structureBoundingBox.minY(), structureBoundingBox.maxY()), var8.nextIntBetweenInclusive(structureBoundingBox.minZ(), structureBoundingBox.maxZ()));
            this.attemptToPlaceBlockAbove(var0, var10);
        }
    }

    private void attemptToPlaceBlockAbove(WorldGenFeatureTree.a var02, BlockPosition var1) {
        BlockPosition var2 = var1.above();
        if (var02.level().isStateAtPosition(var2, var0 -> var0.isAir() || var0.is(Blocks.VINE)) && var02.checkBlock(var1, BlockBase.BlockData::isSolidRender)) {
            var02.setBlock(var2, this.blockStateProvider.getState(var02.random(), var2));
        }
    }
}

