/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.monster.EntityPhantom;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;

public class MobSpawnerPhantom
implements MobSpawner {
    private int nextTick;

    @Override
    public void tick(WorldServer var0, boolean var1, boolean var2) {
        if (!var1) {
            return;
        }
        if (!var0.getGameRules().getBoolean(GameRules.RULE_DOINSOMNIA)) {
            return;
        }
        RandomSource var3 = var0.random;
        --this.nextTick;
        if (this.nextTick > 0) {
            return;
        }
        this.nextTick += (60 + var3.nextInt(60)) * 20;
        if (var0.getSkyDarken() < 5 && var0.dimensionType().hasSkyLight()) {
            return;
        }
        for (EntityPlayer var5 : var0.players()) {
            Fluid var13;
            IBlockData var12;
            BlockPosition var11;
            DifficultyDamageScaler var7;
            if (var5.isSpectator()) continue;
            BlockPosition var6 = var5.blockPosition();
            if (var0.dimensionType().hasSkyLight() && (var6.getY() < var0.getSeaLevel() || !var0.canSeeSky(var6)) || !(var7 = var0.getCurrentDifficultyAt(var6)).isHarderThan(var3.nextFloat() * 3.0f)) continue;
            ServerStatisticManager var8 = var5.getStats();
            int var9 = MathHelper.clamp(var8.getValue(StatisticList.CUSTOM.get(StatisticList.TIME_SINCE_REST)), 1, Integer.MAX_VALUE);
            int var10 = 24000;
            if (var3.nextInt(var9) < 72000 || !SpawnerCreature.isValidEmptySpawnBlock(var0, var11 = var6.above(20 + var3.nextInt(15)).east(-10 + var3.nextInt(21)).south(-10 + var3.nextInt(21)), var12 = var0.getBlockState(var11), var13 = var0.getFluidState(var11), EntityTypes.PHANTOM)) continue;
            GroupDataEntity var14 = null;
            int var15 = 1 + var3.nextInt(var7.getDifficulty().getId() + 1);
            for (int var16 = 0; var16 < var15; ++var16) {
                EntityPhantom var17 = EntityTypes.PHANTOM.create(var0, EntitySpawnReason.NATURAL);
                if (var17 == null) continue;
                var17.snapTo(var11, 0.0f, 0.0f);
                var14 = var17.finalizeSpawn(var0, var7, EntitySpawnReason.NATURAL, var14);
                var0.addFreshEntityWithPassengers(var17);
            }
        }
    }
}

