/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.util.VisibleForDebug;

public class NibbleArray {
    public static final int LAYER_COUNT = 16;
    public static final int LAYER_SIZE = 128;
    public static final int SIZE = 2048;
    private static final int NIBBLE_SIZE = 4;
    @Nullable
    protected byte[] data;
    private int defaultValue;

    public NibbleArray() {
        this(0);
    }

    public NibbleArray(int var0) {
        this.defaultValue = var0;
    }

    public NibbleArray(byte[] var0) {
        this.data = var0;
        this.defaultValue = 0;
        if (var0.length != 2048) {
            throw SystemUtils.pauseInIde(new IllegalArgumentException("DataLayer should be 2048 bytes not: " + var0.length));
        }
    }

    public int get(int var0, int var1, int var2) {
        return this.get(NibbleArray.getIndex(var0, var1, var2));
    }

    public void set(int var0, int var1, int var2, int var3) {
        this.set(NibbleArray.getIndex(var0, var1, var2), var3);
    }

    private static int getIndex(int var0, int var1, int var2) {
        return var1 << 8 | var2 << 4 | var0;
    }

    private int get(int var0) {
        if (this.data == null) {
            return this.defaultValue;
        }
        int var1 = NibbleArray.getByteIndex(var0);
        int var2 = NibbleArray.getNibbleIndex(var0);
        return this.data[var1] >> 4 * var2 & 0xF;
    }

    private void set(int var0, int var1) {
        byte[] var2 = this.getData();
        int var3 = NibbleArray.getByteIndex(var0);
        int var4 = NibbleArray.getNibbleIndex(var0);
        int var5 = ~(15 << 4 * var4);
        int var6 = (var1 & 0xF) << 4 * var4;
        var2[var3] = (byte)(var2[var3] & var5 | var6);
    }

    private static int getNibbleIndex(int var0) {
        return var0 & 1;
    }

    private static int getByteIndex(int var0) {
        return var0 >> 1;
    }

    public void fill(int var0) {
        this.defaultValue = var0;
        this.data = null;
    }

    private static byte packFilled(int var0) {
        byte var1 = (byte)var0;
        for (int var2 = 4; var2 < 8; var2 += 4) {
            var1 = (byte)(var1 | var0 << var2);
        }
        return var1;
    }

    public byte[] getData() {
        if (this.data == null) {
            this.data = new byte[2048];
            if (this.defaultValue != 0) {
                Arrays.fill(this.data, NibbleArray.packFilled(this.defaultValue));
            }
        }
        return this.data;
    }

    public NibbleArray copy() {
        if (this.data == null) {
            return new NibbleArray(this.defaultValue);
        }
        return new NibbleArray((byte[])this.data.clone());
    }

    public String toString() {
        StringBuilder var0 = new StringBuilder();
        for (int var1 = 0; var1 < 4096; ++var1) {
            var0.append(Integer.toHexString(this.get(var1)));
            if ((var1 & 0xF) == 15) {
                var0.append("\n");
            }
            if ((var1 & 0xFF) != 255) continue;
            var0.append("\n");
        }
        return var0.toString();
    }

    @VisibleForDebug
    public String layerToString(int var0) {
        StringBuilder var1 = new StringBuilder();
        for (int var2 = 0; var2 < 256; ++var2) {
            var1.append(Integer.toHexString(this.get(var2)));
            if ((var2 & 0xF) != 15) continue;
            var1.append("\n");
        }
        return var1.toString();
    }

    public boolean isDefinitelyHomogenous() {
        return this.data == null;
    }

    public boolean isDefinitelyFilledWith(int var0) {
        return this.data == null && this.defaultValue == var0;
    }

    public boolean isEmpty() {
        return this.data == null && this.defaultValue == 0;
    }
}

