/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.lighting.ChunkSkyLightSources;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.ticks.TickContainerAccess;
import net.minecraft.world.ticks.TickListChunk;
import org.slf4j.Logger;

public abstract class IChunkAccess
implements BiomeManager.Provider,
LightChunk,
StructureAccess {
    public static final int NO_FILLED_SECTION = -1;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final LongSet EMPTY_REFERENCE_SET = new LongOpenHashSet();
    protected final ShortList[] postProcessing;
    private volatile boolean unsaved;
    private volatile boolean isLightCorrect;
    protected final ChunkCoordIntPair chunkPos;
    private long inhabitedTime;
    @Nullable
    @Deprecated
    private BiomeSettingsGeneration carverBiomeSettings;
    @Nullable
    protected NoiseChunk noiseChunk;
    protected final ChunkConverter upgradeData;
    @Nullable
    protected BlendingData blendingData;
    public final Map<HeightMap.Type, HeightMap> heightmaps = Maps.newEnumMap(HeightMap.Type.class);
    protected ChunkSkyLightSources skyLightSources;
    private final Map<Structure, StructureStart> structureStarts = Maps.newHashMap();
    private final Map<Structure, LongSet> structuresRefences = Maps.newHashMap();
    protected final Map<BlockPosition, NBTTagCompound> pendingBlockEntities = Maps.newHashMap();
    public final Map<BlockPosition, TileEntity> blockEntities = new Object2ObjectOpenHashMap();
    protected final LevelHeightAccessor levelHeightAccessor;
    protected final ChunkSection[] sections;

    public IChunkAccess(ChunkCoordIntPair var0, ChunkConverter var1, LevelHeightAccessor var2, IRegistry<BiomeBase> var3, long var4, @Nullable ChunkSection[] var6, @Nullable BlendingData var7) {
        this.chunkPos = var0;
        this.upgradeData = var1;
        this.levelHeightAccessor = var2;
        this.sections = new ChunkSection[var2.getSectionsCount()];
        this.inhabitedTime = var4;
        this.postProcessing = new ShortList[var2.getSectionsCount()];
        this.blendingData = var7;
        this.skyLightSources = new ChunkSkyLightSources(var2);
        if (var6 != null) {
            if (this.sections.length == var6.length) {
                System.arraycopy(var6, 0, this.sections, 0, this.sections.length);
            } else {
                LOGGER.warn("Could not set level chunk sections, array length is {} instead of {}", (Object)var6.length, (Object)this.sections.length);
            }
        }
        IChunkAccess.replaceMissingSections(var3, this.sections);
    }

    private static void replaceMissingSections(IRegistry<BiomeBase> var0, ChunkSection[] var1) {
        for (int var2 = 0; var2 < var1.length; ++var2) {
            if (var1[var2] != null) continue;
            var1[var2] = new ChunkSection(var0);
        }
    }

    public GameEventListenerRegistry getListenerRegistry(int var0) {
        return GameEventListenerRegistry.NOOP;
    }

    @Nullable
    public IBlockData setBlockState(BlockPosition var0, IBlockData var1) {
        return this.setBlockState(var0, var1, 3);
    }

    @Nullable
    public abstract IBlockData setBlockState(BlockPosition var1, IBlockData var2, int var3);

    public abstract void setBlockEntity(TileEntity var1);

    public abstract void addEntity(Entity var1);

    public int getHighestFilledSectionIndex() {
        ChunkSection[] var0 = this.getSections();
        for (int var1 = var0.length - 1; var1 >= 0; --var1) {
            ChunkSection var2 = var0[var1];
            if (var2.hasOnlyAir()) continue;
            return var1;
        }
        return -1;
    }

    @Deprecated(forRemoval=true)
    public int getHighestSectionPosition() {
        int var0 = this.getHighestFilledSectionIndex();
        return var0 == -1 ? this.getMinY() : SectionPosition.sectionToBlockCoord(this.getSectionYFromSectionIndex(var0));
    }

    public Set<BlockPosition> getBlockEntitiesPos() {
        HashSet var0 = Sets.newHashSet(this.pendingBlockEntities.keySet());
        var0.addAll(this.blockEntities.keySet());
        return var0;
    }

    public ChunkSection[] getSections() {
        return this.sections;
    }

    public ChunkSection getSection(int var0) {
        return this.getSections()[var0];
    }

    public Collection<Map.Entry<HeightMap.Type, HeightMap>> getHeightmaps() {
        return Collections.unmodifiableSet(this.heightmaps.entrySet());
    }

    public void setHeightmap(HeightMap.Type var0, long[] var1) {
        this.getOrCreateHeightmapUnprimed(var0).setRawData(this, var0, var1);
    }

    public HeightMap getOrCreateHeightmapUnprimed(HeightMap.Type var02) {
        return this.heightmaps.computeIfAbsent(var02, var0 -> new HeightMap(this, (HeightMap.Type)var0));
    }

    public boolean hasPrimedHeightmap(HeightMap.Type var0) {
        return this.heightmaps.get(var0) != null;
    }

    public int getHeight(HeightMap.Type var0, int var1, int var2) {
        HeightMap var3 = this.heightmaps.get(var0);
        if (var3 == null) {
            if (SharedConstants.IS_RUNNING_IN_IDE && this instanceof Chunk) {
                LOGGER.error("Unprimed heightmap: " + String.valueOf(var0) + " " + var1 + " " + var2);
            }
            HeightMap.primeHeightmaps(this, EnumSet.of(var0));
            var3 = this.heightmaps.get(var0);
        }
        return var3.getFirstAvailable(var1 & 0xF, var2 & 0xF) - 1;
    }

    public ChunkCoordIntPair getPos() {
        return this.chunkPos;
    }

    @Override
    @Nullable
    public StructureStart getStartForStructure(Structure var0) {
        return this.structureStarts.get(var0);
    }

    @Override
    public void setStartForStructure(Structure var0, StructureStart var1) {
        this.structureStarts.put(var0, var1);
        this.markUnsaved();
    }

    public Map<Structure, StructureStart> getAllStarts() {
        return Collections.unmodifiableMap(this.structureStarts);
    }

    public void setAllStarts(Map<Structure, StructureStart> var0) {
        this.structureStarts.clear();
        this.structureStarts.putAll(var0);
        this.markUnsaved();
    }

    @Override
    public LongSet getReferencesForStructure(Structure var0) {
        return this.structuresRefences.getOrDefault(var0, EMPTY_REFERENCE_SET);
    }

    @Override
    public void addReferenceForStructure(Structure var02, long var1) {
        this.structuresRefences.computeIfAbsent(var02, var0 -> new LongOpenHashSet()).add(var1);
        this.markUnsaved();
    }

    @Override
    public Map<Structure, LongSet> getAllReferences() {
        return Collections.unmodifiableMap(this.structuresRefences);
    }

    @Override
    public void setAllReferences(Map<Structure, LongSet> var0) {
        this.structuresRefences.clear();
        this.structuresRefences.putAll(var0);
        this.markUnsaved();
    }

    public boolean isYSpaceEmpty(int var0, int var1) {
        if (var0 < this.getMinY()) {
            var0 = this.getMinY();
        }
        if (var1 > this.getMaxY()) {
            var1 = this.getMaxY();
        }
        for (int var2 = var0; var2 <= var1; var2 += 16) {
            if (this.getSection(this.getSectionIndex(var2)).hasOnlyAir()) continue;
            return false;
        }
        return true;
    }

    public boolean isSectionEmpty(int var0) {
        return this.getSection(this.getSectionIndexFromSectionY(var0)).hasOnlyAir();
    }

    public void markUnsaved() {
        this.unsaved = true;
    }

    public boolean tryMarkSaved() {
        if (this.unsaved) {
            this.unsaved = false;
            return true;
        }
        return false;
    }

    public boolean isUnsaved() {
        return this.unsaved;
    }

    public abstract ChunkStatus getPersistedStatus();

    public ChunkStatus getHighestGeneratedStatus() {
        ChunkStatus var0 = this.getPersistedStatus();
        BelowZeroRetrogen var1 = this.getBelowZeroRetrogen();
        if (var1 != null) {
            ChunkStatus var2 = var1.targetStatus();
            return ChunkStatus.max(var2, var0);
        }
        return var0;
    }

    public abstract void removeBlockEntity(BlockPosition var1);

    public void markPosForPostprocessing(BlockPosition var0) {
        LOGGER.warn("Trying to mark a block for PostProcessing @ {}, but this operation is not supported.", (Object)var0);
    }

    public ShortList[] getPostProcessing() {
        return this.postProcessing;
    }

    public void addPackedPostProcess(ShortList var0, int var1) {
        IChunkAccess.getOrCreateOffsetList(this.getPostProcessing(), var1).addAll(var0);
    }

    public void setBlockEntityNbt(NBTTagCompound var0) {
        BlockPosition var1 = TileEntity.getPosFromTag(this.chunkPos, var0);
        if (!this.blockEntities.containsKey(var1)) {
            this.pendingBlockEntities.put(var1, var0);
        }
    }

    @Nullable
    public NBTTagCompound getBlockEntityNbt(BlockPosition var0) {
        return this.pendingBlockEntities.get(var0);
    }

    @Nullable
    public abstract NBTTagCompound getBlockEntityNbtForSaving(BlockPosition var1, HolderLookup.a var2);

    @Override
    public final void findBlockLightSources(BiConsumer<BlockPosition, IBlockData> var02) {
        this.findBlocks(var0 -> var0.getLightEmission() != 0, var02);
    }

    public void findBlocks(Predicate<IBlockData> var0, BiConsumer<BlockPosition, IBlockData> var1) {
        BlockPosition.MutableBlockPosition var2 = new BlockPosition.MutableBlockPosition();
        for (int var3 = this.getMinSectionY(); var3 <= this.getMaxSectionY(); ++var3) {
            ChunkSection var4 = this.getSection(this.getSectionIndexFromSectionY(var3));
            if (!var4.maybeHas(var0)) continue;
            BlockPosition var5 = SectionPosition.of(this.chunkPos, var3).origin();
            for (int var6 = 0; var6 < 16; ++var6) {
                for (int var7 = 0; var7 < 16; ++var7) {
                    for (int var8 = 0; var8 < 16; ++var8) {
                        IBlockData var9 = var4.getBlockState(var8, var6, var7);
                        if (!var0.test(var9)) continue;
                        var1.accept(var2.setWithOffset(var5, var8, var6, var7), var9);
                    }
                }
            }
        }
    }

    public abstract TickContainerAccess<Block> getBlockTicks();

    public abstract TickContainerAccess<FluidType> getFluidTicks();

    public boolean canBeSerialized() {
        return true;
    }

    public abstract a getTicksForSerialization(long var1);

    public ChunkConverter getUpgradeData() {
        return this.upgradeData;
    }

    public boolean isOldNoiseGeneration() {
        return this.blendingData != null;
    }

    @Nullable
    public BlendingData getBlendingData() {
        return this.blendingData;
    }

    public long getInhabitedTime() {
        return this.inhabitedTime;
    }

    public void incrementInhabitedTime(long var0) {
        this.inhabitedTime += var0;
    }

    public void setInhabitedTime(long var0) {
        this.inhabitedTime = var0;
    }

    public static ShortList getOrCreateOffsetList(ShortList[] var0, int var1) {
        if (var0[var1] == null) {
            var0[var1] = new ShortArrayList();
        }
        return var0[var1];
    }

    public boolean isLightCorrect() {
        return this.isLightCorrect;
    }

    public void setLightCorrect(boolean var0) {
        this.isLightCorrect = var0;
        this.markUnsaved();
    }

    @Override
    public int getMinY() {
        return this.levelHeightAccessor.getMinY();
    }

    @Override
    public int getHeight() {
        return this.levelHeightAccessor.getHeight();
    }

    public NoiseChunk getOrCreateNoiseChunk(Function<IChunkAccess, NoiseChunk> var0) {
        if (this.noiseChunk == null) {
            this.noiseChunk = var0.apply(this);
        }
        return this.noiseChunk;
    }

    @Deprecated
    public BiomeSettingsGeneration carverBiome(Supplier<BiomeSettingsGeneration> var0) {
        if (this.carverBiomeSettings == null) {
            this.carverBiomeSettings = var0.get();
        }
        return this.carverBiomeSettings;
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int var0, int var1, int var2) {
        try {
            int var3 = QuartPos.fromBlock(this.getMinY());
            int var4 = var3 + QuartPos.fromBlock(this.getHeight()) - 1;
            int var5 = MathHelper.clamp(var1, var3, var4);
            int var6 = this.getSectionIndex(QuartPos.toBlock(var5));
            return this.sections[var6].getNoiseBiome(var0 & 3, var5 & 3, var2 & 3);
        }
        catch (Throwable var3) {
            CrashReport var4 = CrashReport.forThrowable(var3, "Getting biome");
            CrashReportSystemDetails var5 = var4.addCategory("Biome being got");
            var5.setDetail("Location", () -> CrashReportSystemDetails.formatLocation((LevelHeightAccessor)this, var0, var1, var2));
            throw new ReportedException(var4);
        }
    }

    public void fillBiomesFromNoise(BiomeResolver var0, Climate.Sampler var1) {
        ChunkCoordIntPair var2 = this.getPos();
        int var3 = QuartPos.fromBlock(var2.getMinBlockX());
        int var4 = QuartPos.fromBlock(var2.getMinBlockZ());
        LevelHeightAccessor var5 = this.getHeightAccessorForGeneration();
        for (int var6 = var5.getMinSectionY(); var6 <= var5.getMaxSectionY(); ++var6) {
            ChunkSection var7 = this.getSection(this.getSectionIndexFromSectionY(var6));
            int var8 = QuartPos.fromSection(var6);
            var7.fillBiomesFromNoise(var0, var1, var3, var8, var4);
        }
    }

    public boolean hasAnyStructureReferences() {
        return !this.getAllReferences().isEmpty();
    }

    @Nullable
    public BelowZeroRetrogen getBelowZeroRetrogen() {
        return null;
    }

    public boolean isUpgrading() {
        return this.getBelowZeroRetrogen() != null;
    }

    public LevelHeightAccessor getHeightAccessorForGeneration() {
        return this;
    }

    public void initializeLightSources() {
        this.skyLightSources.fillFrom(this);
    }

    @Override
    public ChunkSkyLightSources getSkyLightSources() {
        return this.skyLightSources;
    }

    public record a(List<TickListChunk<Block>> blocks, List<TickListChunk<FluidType>> fluids) {
    }
}

