/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.sounds;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;

public class AmbientDesertBlockSoundsPlayer {
    private static final int IDLE_SOUND_CHANCE = 1600;
    private static final int WIND_SOUND_CHANCE = 10000;
    private static final int SURROUNDING_BLOCKS_PLAY_SOUND_THRESHOLD = 3;
    private static final int SURROUNDING_BLOCKS_DISTANCE_CHECK = 8;

    public static void playAmbientBlockSounds(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        if (!var0.is(TagsBlock.PLAYS_AMBIENT_DESERT_BLOCK_SOUNDS) || !var1.canSeeSky(var2.above())) {
            return;
        }
        if (var3.nextInt(1600) == 0 && AmbientDesertBlockSoundsPlayer.shouldPlayAmbientSound(var1, var2)) {
            var1.playLocalSound(var2.getX(), var2.getY(), var2.getZ(), SoundEffects.SAND_IDLE, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
        }
        if (var3.nextInt(10000) == 0 && AmbientDesertBlockSoundsPlayer.isInAmbientSoundBiome(var1.getBiome(var2)) && AmbientDesertBlockSoundsPlayer.shouldPlayAmbientSound(var1, var2)) {
            var1.playPlayerSound(SoundEffects.SAND_WIND, SoundCategory.AMBIENT, 1.0f, 1.0f);
        }
    }

    private static boolean isInAmbientSoundBiome(Holder<BiomeBase> var0) {
        return var0.is(Biomes.DESERT) || var0.is(BiomeTags.IS_BADLANDS);
    }

    private static boolean shouldPlayAmbientSound(World var0, BlockPosition var1) {
        int var2 = 0;
        for (EnumDirection var4 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPosition var5 = var1.relative(var4, 8);
            IBlockData var6 = var0.getBlockState(var5.atY(var0.getHeight(HeightMap.Type.WORLD_SURFACE, var5) - 1));
            if (!var6.is(TagsBlock.PLAYS_AMBIENT_DESERT_BLOCK_SOUNDS) || ++var2 < 3) continue;
            return true;
        }
        return false;
    }
}

