/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;

public class TrialSpawnerBlockEntity
extends TileEntity
implements Spawner,
TrialSpawner.b {
    public TrialSpawner trialSpawner = this.createDefaultSpawner();

    public TrialSpawnerBlockEntity(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.TRIAL_SPAWNER, var0, var1);
    }

    private TrialSpawner createDefaultSpawner() {
        PlayerDetector var0 = PlayerDetector.NO_CREATIVE_PLAYERS;
        PlayerDetector.a var1 = PlayerDetector.a.SELECT_FROM_LEVEL;
        return new TrialSpawner(this, var0, var1);
    }

    @Override
    protected void loadAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        super.loadAdditional(var0, var1);
        this.trialSpawner = var0.read(this.trialSpawner.codec(), var1.createSerializationContext(DynamicOpsNBT.INSTANCE)).orElseGet(this::createDefaultSpawner);
        if (this.level != null) {
            this.markUpdated();
        }
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        super.saveAdditional(var0, var1);
        var0.store(this.trialSpawner.codec(), var1.createSerializationContext(DynamicOpsNBT.INSTANCE), this.trialSpawner);
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag(HolderLookup.a var0) {
        return this.trialSpawner.getData().getUpdateTag(this.getBlockState().getValue(TrialSpawnerBlock.STATE));
    }

    @Override
    public void setEntityId(EntityTypes<?> var0, RandomSource var1) {
        if (this.level == null) {
            SystemUtils.logAndPauseIfInIde("Expected non-null level");
            return;
        }
        this.trialSpawner.overrideEntityToSpawn(var0, this.level);
        this.setChanged();
    }

    public TrialSpawner getTrialSpawner() {
        return this.trialSpawner;
    }

    @Override
    public TrialSpawnerState getState() {
        if (!this.getBlockState().hasProperty(BlockProperties.TRIAL_SPAWNER_STATE)) {
            return TrialSpawnerState.INACTIVE;
        }
        return this.getBlockState().getValue(BlockProperties.TRIAL_SPAWNER_STATE);
    }

    @Override
    public void setState(World var0, TrialSpawnerState var1) {
        this.setChanged();
        var0.setBlockAndUpdate(this.worldPosition, (IBlockData)this.getBlockState().setValue(BlockProperties.TRIAL_SPAWNER_STATE, var1));
    }

    @Override
    public void markUpdated() {
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

