/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerShulkerBox;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockShulkerBox;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class TileEntityShulkerBox
extends TileEntityLootable
implements IWorldInventory {
    public static final int COLUMNS = 9;
    public static final int ROWS = 3;
    public static final int CONTAINER_SIZE = 27;
    public static final int EVENT_SET_OPEN_COUNT = 1;
    public static final int OPENING_TICK_LENGTH = 10;
    public static final float MAX_LID_HEIGHT = 0.5f;
    public static final float MAX_LID_ROTATION = 270.0f;
    private static final int[] SLOTS = IntStream.range(0, 27).toArray();
    private NonNullList<ItemStack> itemStacks = NonNullList.withSize(27, ItemStack.EMPTY);
    public int openCount;
    private AnimationPhase animationStatus = AnimationPhase.CLOSED;
    private float progress;
    private float progressOld;
    @Nullable
    private final EnumColor color;

    public TileEntityShulkerBox(@Nullable EnumColor var0, BlockPosition var1, IBlockData var2) {
        super(TileEntityTypes.SHULKER_BOX, var1, var2);
        this.color = var0;
    }

    public TileEntityShulkerBox(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.SHULKER_BOX, var0, var1);
        EnumColor enumColor;
        Block block = var1.getBlock();
        if (block instanceof BlockShulkerBox) {
            BlockShulkerBox var2 = (BlockShulkerBox)block;
            enumColor = var2.getColor();
        } else {
            enumColor = null;
        }
        this.color = enumColor;
    }

    public static void tick(World var0, BlockPosition var1, IBlockData var2, TileEntityShulkerBox var3) {
        var3.updateAnimation(var0, var1, var2);
    }

    private void updateAnimation(World var0, BlockPosition var1, IBlockData var2) {
        this.progressOld = this.progress;
        switch (this.animationStatus.ordinal()) {
            case 0: {
                this.progress = 0.0f;
                break;
            }
            case 1: {
                this.progress += 0.1f;
                if (this.progressOld == 0.0f) {
                    TileEntityShulkerBox.doNeighborUpdates(var0, var1, var2);
                }
                if (this.progress >= 1.0f) {
                    this.animationStatus = AnimationPhase.OPENED;
                    this.progress = 1.0f;
                    TileEntityShulkerBox.doNeighborUpdates(var0, var1, var2);
                }
                this.moveCollidedEntities(var0, var1, var2);
                break;
            }
            case 3: {
                this.progress -= 0.1f;
                if (this.progressOld == 1.0f) {
                    TileEntityShulkerBox.doNeighborUpdates(var0, var1, var2);
                }
                if (!(this.progress <= 0.0f)) break;
                this.animationStatus = AnimationPhase.CLOSED;
                this.progress = 0.0f;
                TileEntityShulkerBox.doNeighborUpdates(var0, var1, var2);
                break;
            }
            case 2: {
                this.progress = 1.0f;
            }
        }
    }

    public AnimationPhase getAnimationStatus() {
        return this.animationStatus;
    }

    public AxisAlignedBB getBoundingBox(IBlockData var0) {
        Vec3D var1 = new Vec3D(0.5, 0.0, 0.5);
        return EntityShulker.getProgressAabb(1.0f, var0.getValue(BlockShulkerBox.FACING), 0.5f * this.getProgress(1.0f), var1);
    }

    private void moveCollidedEntities(World var0, BlockPosition var1, IBlockData var2) {
        if (!(var2.getBlock() instanceof BlockShulkerBox)) {
            return;
        }
        EnumDirection var3 = var2.getValue(BlockShulkerBox.FACING);
        AxisAlignedBB var4 = EntityShulker.getProgressDeltaAabb(1.0f, var3, this.progressOld, this.progress, var1.getBottomCenter());
        List<Entity> var5 = var0.getEntities(null, var4);
        if (var5.isEmpty()) {
            return;
        }
        for (Entity var7 : var5) {
            if (var7.getPistonPushReaction() == EnumPistonReaction.IGNORE) continue;
            var7.move(EnumMoveType.SHULKER_BOX, new Vec3D((var4.getXsize() + 0.01) * (double)var3.getStepX(), (var4.getYsize() + 0.01) * (double)var3.getStepY(), (var4.getZsize() + 0.01) * (double)var3.getStepZ()));
        }
    }

    @Override
    public int getContainerSize() {
        return this.itemStacks.size();
    }

    @Override
    public boolean triggerEvent(int var0, int var1) {
        if (var0 == 1) {
            this.openCount = var1;
            if (var1 == 0) {
                this.animationStatus = AnimationPhase.CLOSING;
            }
            if (var1 == 1) {
                this.animationStatus = AnimationPhase.OPENING;
            }
            return true;
        }
        return super.triggerEvent(var0, var1);
    }

    private static void doNeighborUpdates(World var0, BlockPosition var1, IBlockData var2) {
        var2.updateNeighbourShapes(var0, var1, 3);
        var0.updateNeighborsAt(var1, var2.getBlock());
    }

    @Override
    public void preRemoveSideEffects(BlockPosition var0, IBlockData var1) {
    }

    @Override
    public void startOpen(EntityHuman var0) {
        if (!this.remove && !var0.isSpectator()) {
            if (this.openCount < 0) {
                this.openCount = 0;
            }
            ++this.openCount;
            this.level.blockEvent(this.worldPosition, this.getBlockState().getBlock(), 1, this.openCount);
            if (this.openCount == 1) {
                this.level.gameEvent((Entity)var0, GameEvent.CONTAINER_OPEN, this.worldPosition);
                this.level.playSound(null, this.worldPosition, SoundEffects.SHULKER_BOX_OPEN, SoundCategory.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    @Override
    public void stopOpen(EntityHuman var0) {
        if (!this.remove && !var0.isSpectator()) {
            --this.openCount;
            this.level.blockEvent(this.worldPosition, this.getBlockState().getBlock(), 1, this.openCount);
            if (this.openCount <= 0) {
                this.level.gameEvent((Entity)var0, GameEvent.CONTAINER_CLOSE, this.worldPosition);
                this.level.playSound(null, this.worldPosition, SoundEffects.SHULKER_BOX_CLOSE, SoundCategory.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    @Override
    protected IChatBaseComponent getDefaultName() {
        return IChatBaseComponent.translatable("container.shulkerBox");
    }

    @Override
    protected void loadAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        super.loadAdditional(var0, var1);
        this.loadFromTag(var0, var1);
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        super.saveAdditional(var0, var1);
        if (!this.trySaveLootTable(var0)) {
            ContainerUtil.saveAllItems(var0, this.itemStacks, false, var1);
        }
    }

    public void loadFromTag(NBTTagCompound var0, HolderLookup.a var1) {
        this.itemStacks = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        if (!this.tryLoadLootTable(var0)) {
            ContainerUtil.loadAllItems(var0, this.itemStacks, var1);
        }
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.itemStacks;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> var0) {
        this.itemStacks = var0;
    }

    @Override
    public int[] getSlotsForFace(EnumDirection var0) {
        return SLOTS;
    }

    @Override
    public boolean canPlaceItemThroughFace(int var0, ItemStack var1, @Nullable EnumDirection var2) {
        return !(Block.byItem(var1.getItem()) instanceof BlockShulkerBox);
    }

    @Override
    public boolean canTakeItemThroughFace(int var0, ItemStack var1, EnumDirection var2) {
        return true;
    }

    public float getProgress(float var0) {
        return MathHelper.lerp(var0, this.progressOld, this.progress);
    }

    @Nullable
    public EnumColor getColor() {
        return this.color;
    }

    @Override
    protected Container createMenu(int var0, PlayerInventory var1) {
        return new ContainerShulkerBox(var0, var1, this);
    }

    public boolean isClosed() {
        return this.animationStatus == AnimationPhase.CLOSED;
    }

    public static final class AnimationPhase
    extends Enum<AnimationPhase> {
        public static final /* enum */ AnimationPhase CLOSED = new AnimationPhase();
        public static final /* enum */ AnimationPhase OPENING = new AnimationPhase();
        public static final /* enum */ AnimationPhase OPENED = new AnimationPhase();
        public static final /* enum */ AnimationPhase CLOSING = new AnimationPhase();
        private static final /* synthetic */ AnimationPhase[] e;

        public static AnimationPhase[] values() {
            return (AnimationPhase[])e.clone();
        }

        public static AnimationPhase valueOf(String var0) {
            return Enum.valueOf(AnimationPhase.class, var0);
        }

        private static /* synthetic */ AnimationPhase[] a() {
            return new AnimationPhase[]{CLOSED, OPENING, OPENED, CLOSING};
        }

        static {
            e = AnimationPhase.a();
        }
    }
}

