/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.MobSpawnerAbstract;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;

public class TileEntityMobSpawner
extends TileEntity
implements Spawner {
    private final MobSpawnerAbstract spawner = new MobSpawnerAbstract(this){

        @Override
        public void broadcastEvent(World var0, BlockPosition var1, int var2) {
            var0.blockEvent(var1, Blocks.SPAWNER, var2, 0);
        }

        @Override
        public void setNextSpawnData(@Nullable World var0, BlockPosition var1, MobSpawnerData var2) {
            super.setNextSpawnData(var0, var1, var2);
            if (var0 != null) {
                IBlockData var3 = var0.getBlockState(var1);
                var0.sendBlockUpdated(var1, var3, var3, 260);
            }
        }
    };

    public TileEntityMobSpawner(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.MOB_SPAWNER, var0, var1);
    }

    @Override
    protected void loadAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        super.loadAdditional(var0, var1);
        this.spawner.load(this.level, this.worldPosition, var0);
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        super.saveAdditional(var0, var1);
        this.spawner.save(var0);
    }

    public static void clientTick(World var0, BlockPosition var1, IBlockData var2, TileEntityMobSpawner var3) {
        var3.spawner.clientTick(var0, var1);
    }

    public static void serverTick(World var0, BlockPosition var1, IBlockData var2, TileEntityMobSpawner var3) {
        var3.spawner.serverTick((WorldServer)var0, var1);
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag(HolderLookup.a var0) {
        NBTTagCompound var1 = this.saveCustomOnly(var0);
        var1.remove("SpawnPotentials");
        return var1;
    }

    @Override
    public boolean triggerEvent(int var0, int var1) {
        if (this.spawner.onEventTriggered(this.level, var0)) {
            return true;
        }
        return super.triggerEvent(var0, var1);
    }

    @Override
    public void setEntityId(EntityTypes<?> var0, RandomSource var1) {
        this.spawner.setEntityId(var0, this.level, var1, this.worldPosition);
        this.setChanged();
    }

    public MobSpawnerAbstract getSpawner() {
        return this.spawner;
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

