/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Clearable;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerLectern;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockLectern;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;

public class TileEntityLectern
extends TileEntity
implements Clearable,
ITileInventory {
    public static final int DATA_PAGE = 0;
    public static final int NUM_DATA = 1;
    public static final int SLOT_BOOK = 0;
    public static final int NUM_SLOTS = 1;
    public final IInventory bookAccess = new IInventory(){

        @Override
        public int getContainerSize() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return TileEntityLectern.this.book.isEmpty();
        }

        @Override
        public ItemStack getItem(int var0) {
            return var0 == 0 ? TileEntityLectern.this.book : ItemStack.EMPTY;
        }

        @Override
        public ItemStack removeItem(int var0, int var1) {
            if (var0 == 0) {
                ItemStack var2 = TileEntityLectern.this.book.split(var1);
                if (TileEntityLectern.this.book.isEmpty()) {
                    TileEntityLectern.this.onBookItemRemove();
                }
                return var2;
            }
            return ItemStack.EMPTY;
        }

        @Override
        public ItemStack removeItemNoUpdate(int var0) {
            if (var0 == 0) {
                ItemStack var1 = TileEntityLectern.this.book;
                TileEntityLectern.this.book = ItemStack.EMPTY;
                TileEntityLectern.this.onBookItemRemove();
                return var1;
            }
            return ItemStack.EMPTY;
        }

        @Override
        public void setItem(int var0, ItemStack var1) {
        }

        @Override
        public int getMaxStackSize() {
            return 1;
        }

        @Override
        public void setChanged() {
            TileEntityLectern.this.setChanged();
        }

        @Override
        public boolean stillValid(EntityHuman var0) {
            return IInventory.stillValidBlockEntity(TileEntityLectern.this, var0) && TileEntityLectern.this.hasBook();
        }

        @Override
        public boolean canPlaceItem(int var0, ItemStack var1) {
            return false;
        }

        @Override
        public void clearContent() {
        }
    };
    private final IContainerProperties dataAccess = new IContainerProperties(){

        @Override
        public int get(int var0) {
            return var0 == 0 ? TileEntityLectern.this.page : 0;
        }

        @Override
        public void set(int var0, int var1) {
            if (var0 == 0) {
                TileEntityLectern.this.setPage(var1);
            }
        }

        @Override
        public int getCount() {
            return 1;
        }
    };
    ItemStack book = ItemStack.EMPTY;
    int page;
    private int pageCount;

    public TileEntityLectern(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.LECTERN, var0, var1);
    }

    public ItemStack getBook() {
        return this.book;
    }

    public boolean hasBook() {
        return this.book.has(DataComponents.WRITABLE_BOOK_CONTENT) || this.book.has(DataComponents.WRITTEN_BOOK_CONTENT);
    }

    public void setBook(ItemStack var0) {
        this.setBook(var0, null);
    }

    void onBookItemRemove() {
        this.page = 0;
        this.pageCount = 0;
        BlockLectern.resetBookState(null, this.getLevel(), this.getBlockPos(), this.getBlockState(), false);
    }

    public void setBook(ItemStack var0, @Nullable EntityHuman var1) {
        this.book = this.resolveBook(var0, var1);
        this.page = 0;
        this.pageCount = TileEntityLectern.getPageCount(this.book);
        this.setChanged();
    }

    public void setPage(int var0) {
        int var1 = MathHelper.clamp(var0, 0, this.pageCount - 1);
        if (var1 != this.page) {
            this.page = var1;
            this.setChanged();
            BlockLectern.signalPageChange(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public int getPage() {
        return this.page;
    }

    public int getRedstoneSignal() {
        float var0 = this.pageCount > 1 ? (float)this.getPage() / ((float)this.pageCount - 1.0f) : 1.0f;
        return MathHelper.floor(var0 * 14.0f) + (this.hasBook() ? 1 : 0);
    }

    private ItemStack resolveBook(ItemStack var0, @Nullable EntityHuman var1) {
        World world = this.level;
        if (world instanceof WorldServer) {
            WorldServer var2 = (WorldServer)world;
            WrittenBookContent.resolveForItem(var0, this.createCommandSourceStack(var1, var2), var1);
        }
        return var0;
    }

    private CommandListenerWrapper createCommandSourceStack(@Nullable EntityHuman var0, WorldServer var1) {
        IChatBaseComponent var3;
        String var2;
        if (var0 == null) {
            var2 = "Lectern";
            var3 = IChatBaseComponent.literal("Lectern");
        } else {
            var2 = var0.getName().getString();
            var3 = var0.getDisplayName();
        }
        Vec3D var4 = Vec3D.atCenterOf(this.worldPosition);
        return new CommandListenerWrapper(ICommandListener.NULL, var4, Vec2F.ZERO, var1, 2, var2, var3, var1.getServer(), var0);
    }

    @Override
    protected void loadAdditional(NBTTagCompound var02, HolderLookup.a var1) {
        super.loadAdditional(var02, var1);
        RegistryOps<NBTBase> var2 = var1.createSerializationContext(DynamicOpsNBT.INSTANCE);
        this.book = var02.read("Book", ItemStack.CODEC, var2).map(var0 -> this.resolveBook((ItemStack)var0, null)).orElse(ItemStack.EMPTY);
        this.pageCount = TileEntityLectern.getPageCount(this.book);
        this.page = MathHelper.clamp(var02.getIntOr("Page", 0), 0, this.pageCount - 1);
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        super.saveAdditional(var0, var1);
        if (!this.getBook().isEmpty()) {
            RegistryOps<NBTBase> var2 = var1.createSerializationContext(DynamicOpsNBT.INSTANCE);
            var0.store("Book", ItemStack.CODEC, var2, this.getBook());
            var0.putInt("Page", this.page);
        }
    }

    @Override
    public void clearContent() {
        this.setBook(ItemStack.EMPTY);
    }

    @Override
    public void preRemoveSideEffects(BlockPosition var0, IBlockData var1) {
        if (var1.getValue(BlockLectern.HAS_BOOK).booleanValue() && this.level != null) {
            EnumDirection var2 = var1.getValue(BlockLectern.FACING);
            ItemStack var3 = this.getBook().copy();
            float var4 = 0.25f * (float)var2.getStepX();
            float var5 = 0.25f * (float)var2.getStepZ();
            EntityItem var6 = new EntityItem(this.level, (double)var0.getX() + 0.5 + (double)var4, var0.getY() + 1, (double)var0.getZ() + 0.5 + (double)var5, var3);
            var6.setDefaultPickUpDelay();
            this.level.addFreshEntity(var6);
        }
    }

    @Override
    public Container createMenu(int var0, PlayerInventory var1, EntityHuman var2) {
        return new ContainerLectern(var0, this.bookAccess, this.dataAccess);
    }

    @Override
    public IChatBaseComponent getDisplayName() {
        return IChatBaseComponent.translatable("container.lectern");
    }

    private static int getPageCount(ItemStack var0) {
        WrittenBookContent var1 = var0.get(DataComponents.WRITTEN_BOOK_CONTENT);
        if (var1 != null) {
            return var1.pages().size();
        }
        WritableBookContent var2 = var0.get(DataComponents.WRITABLE_BOOK_CONTENT);
        if (var2 != null) {
            return var2.pages().size();
        }
        return 0;
    }
}

