/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipeCampfire;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;

public class TileEntityCampfire
extends TileEntity
implements Clearable {
    private static final int BURN_COOL_SPEED = 2;
    private static final int NUM_SLOTS = 4;
    private final NonNullList<ItemStack> items = NonNullList.withSize(4, ItemStack.EMPTY);
    public final int[] cookingProgress = new int[4];
    public final int[] cookingTime = new int[4];

    public TileEntityCampfire(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.CAMPFIRE, var0, var1);
    }

    public static void cookTick(WorldServer var0, BlockPosition var1, IBlockData var22, TileEntityCampfire var3, CraftingManager.a<SingleRecipeInput, RecipeCampfire> var4) {
        boolean var5 = false;
        for (int var6 = 0; var6 < var3.items.size(); ++var6) {
            SingleRecipeInput var8;
            ItemStack var9;
            ItemStack var7 = var3.items.get(var6);
            if (var7.isEmpty()) continue;
            var5 = true;
            int n2 = var6;
            var3.cookingProgress[n2] = var3.cookingProgress[n2] + 1;
            if (var3.cookingProgress[var6] < var3.cookingTime[var6] || !(var9 = var4.getRecipeFor(var8 = new SingleRecipeInput(var7), var0).map(var2 -> ((RecipeCampfire)var2.value()).assemble(var8, (HolderLookup.a)var0.registryAccess())).orElse(var7)).isItemEnabled(var0.enabledFeatures())) continue;
            InventoryUtils.dropItemStack(var0, var1.getX(), var1.getY(), var1.getZ(), var9);
            var3.items.set(var6, ItemStack.EMPTY);
            var0.sendBlockUpdated(var1, var22, var22, 3);
            var0.gameEvent(GameEvent.BLOCK_CHANGE, var1, GameEvent.a.of(var22));
        }
        if (var5) {
            TileEntityCampfire.setChanged(var0, var1, var22);
        }
    }

    public static void cooldownTick(World var0, BlockPosition var1, IBlockData var2, TileEntityCampfire var3) {
        boolean var4 = false;
        for (int var5 = 0; var5 < var3.items.size(); ++var5) {
            if (var3.cookingProgress[var5] <= 0) continue;
            var4 = true;
            var3.cookingProgress[var5] = MathHelper.clamp(var3.cookingProgress[var5] - 2, 0, var3.cookingTime[var5]);
        }
        if (var4) {
            TileEntityCampfire.setChanged(var0, var1, var2);
        }
    }

    public static void particleTick(World var0, BlockPosition var1, IBlockData var2, TileEntityCampfire var3) {
        int var5;
        RandomSource var4 = var0.random;
        if (var4.nextFloat() < 0.11f) {
            for (var5 = 0; var5 < var4.nextInt(2) + 2; ++var5) {
                BlockCampfire.makeParticles(var0, var1, var2.getValue(BlockCampfire.SIGNAL_FIRE), false);
            }
        }
        var5 = var2.getValue(BlockCampfire.FACING).get2DDataValue();
        for (int var6 = 0; var6 < var3.items.size(); ++var6) {
            if (var3.items.get(var6).isEmpty() || !(var4.nextFloat() < 0.2f)) continue;
            EnumDirection var7 = EnumDirection.from2DDataValue(Math.floorMod(var6 + var5, 4));
            float var8 = 0.3125f;
            double var9 = (double)var1.getX() + 0.5 - (double)((float)var7.getStepX() * 0.3125f) + (double)((float)var7.getClockWise().getStepX() * 0.3125f);
            double var11 = (double)var1.getY() + 0.5;
            double var13 = (double)var1.getZ() + 0.5 - (double)((float)var7.getStepZ() * 0.3125f) + (double)((float)var7.getClockWise().getStepZ() * 0.3125f);
            for (int var15 = 0; var15 < 4; ++var15) {
                var0.addParticle(Particles.SMOKE, var9, var11, var13, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void loadAdditional(NBTTagCompound var02, HolderLookup.a var1) {
        super.loadAdditional(var02, var1);
        this.items.clear();
        ContainerUtil.loadAllItems(var02, this.items, var1);
        var02.getIntArray("CookingTimes").ifPresentOrElse(var0 -> System.arraycopy(var0, 0, this.cookingProgress, 0, Math.min(this.cookingTime.length, ((int[])var0).length)), () -> Arrays.fill(this.cookingProgress, 0));
        var02.getIntArray("CookingTotalTimes").ifPresentOrElse(var0 -> System.arraycopy(var0, 0, this.cookingTime, 0, Math.min(this.cookingTime.length, ((int[])var0).length)), () -> Arrays.fill(this.cookingTime, 0));
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        super.saveAdditional(var0, var1);
        ContainerUtil.saveAllItems(var0, this.items, true, var1);
        var0.putIntArray("CookingTimes", this.cookingProgress);
        var0.putIntArray("CookingTotalTimes", this.cookingTime);
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag(HolderLookup.a var0) {
        NBTTagCompound var1 = new NBTTagCompound();
        ContainerUtil.saveAllItems(var1, this.items, true, var0);
        return var1;
    }

    public boolean placeFood(WorldServer var0, @Nullable EntityLiving var1, ItemStack var2) {
        for (int var3 = 0; var3 < this.items.size(); ++var3) {
            ItemStack var4 = this.items.get(var3);
            if (!var4.isEmpty()) continue;
            Optional<RecipeHolder<RecipeCampfire>> var5 = var0.recipeAccess().getRecipeFor(Recipes.CAMPFIRE_COOKING, new SingleRecipeInput(var2), var0);
            if (var5.isEmpty()) {
                return false;
            }
            this.cookingTime[var3] = var5.get().value().cookingTime();
            this.cookingProgress[var3] = 0;
            this.items.set(var3, var2.consumeAndReturn(1, var1));
            var0.gameEvent(GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.a.of(var1, this.getBlockState()));
            this.markUpdated();
            return true;
        }
        return false;
    }

    private void markUpdated() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    @Override
    public void clearContent() {
        this.items.clear();
    }

    @Override
    public void preRemoveSideEffects(BlockPosition var0, IBlockData var1) {
        if (this.level != null) {
            InventoryUtils.dropContents(this.level, var0, this.getItems());
        }
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter var0) {
        super.applyImplicitComponents(var0);
        var0.getOrDefault(DataComponents.CONTAINER, ItemContainerContents.EMPTY).copyInto(this.getItems());
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.a var0) {
        super.collectImplicitComponents(var0);
        var0.set(DataComponents.CONTAINER, ItemContainerContents.fromItems(this.getItems()));
    }

    @Override
    public void removeComponentsFromTag(NBTTagCompound var0) {
        var0.remove("Items");
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

