/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.EnumChatFormat;
import net.minecraft.FileUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.structures.DebugReportNBT;
import net.minecraft.gametest.framework.FailedTestTracker;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestHarnessStructures;
import net.minecraft.gametest.framework.GameTestHarnessTestCommand;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ARGB;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.BeaconBeamOwner;
import net.minecraft.world.level.block.entity.BoundingBoxRenderable;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.phys.AxisAlignedBB;

public class TestInstanceBlockEntity
extends TileEntity
implements BeaconBeamOwner,
BoundingBoxRenderable {
    private static final IChatBaseComponent INVALID_TEST_NAME = IChatBaseComponent.translatable("test_instance_block.invalid_test");
    private static final List<BeaconBeamOwner.a> BEAM_CLEARED = List.of();
    private static final List<BeaconBeamOwner.a> BEAM_RUNNING = List.of(new BeaconBeamOwner.a(ARGB.color(128, 128, 128)));
    private static final List<BeaconBeamOwner.a> BEAM_SUCCESS = List.of(new BeaconBeamOwner.a(ARGB.color(0, 255, 0)));
    private static final List<BeaconBeamOwner.a> BEAM_REQUIRED_FAILED = List.of(new BeaconBeamOwner.a(ARGB.color(255, 0, 0)));
    private static final List<BeaconBeamOwner.a> BEAM_OPTIONAL_FAILED = List.of(new BeaconBeamOwner.a(ARGB.color(255, 128, 0)));
    private static final BaseBlockPosition STRUCTURE_OFFSET = new BaseBlockPosition(0, 1, 1);
    private a data = new a(Optional.empty(), BaseBlockPosition.ZERO, EnumBlockRotation.NONE, false, b.CLEARED, Optional.empty());

    public TestInstanceBlockEntity(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.TEST_INSTANCE_BLOCK, var0, var1);
    }

    public void set(a var0) {
        this.data = var0;
        this.setChanged();
    }

    public static Optional<BaseBlockPosition> getStructureSize(WorldServer var0, ResourceKey<GameTestInstance> var1) {
        return TestInstanceBlockEntity.getStructureTemplate(var0, var1).map(DefinedStructure::getSize);
    }

    public StructureBoundingBox getStructureBoundingBox() {
        BlockPosition var0 = this.getStructurePos();
        BlockPosition var1 = var0.offset(this.getTransformedSize()).offset(-1, -1, -1);
        return StructureBoundingBox.fromCorners(var0, var1);
    }

    public AxisAlignedBB getStructureBounds() {
        return AxisAlignedBB.of(this.getStructureBoundingBox());
    }

    private static Optional<DefinedStructure> getStructureTemplate(WorldServer var02, ResourceKey<GameTestInstance> var12) {
        return var02.registryAccess().get(var12).map(var0 -> ((GameTestInstance)var0.value()).structure()).flatMap(var1 -> var02.getStructureManager().get((MinecraftKey)var1));
    }

    public Optional<ResourceKey<GameTestInstance>> test() {
        return this.data.test();
    }

    public IChatBaseComponent getTestName() {
        return this.test().map(var0 -> IChatBaseComponent.literal(var0.location().toString())).orElse(INVALID_TEST_NAME);
    }

    private Optional<Holder.c<GameTestInstance>> getTestHolder() {
        return this.test().flatMap(this.level.registryAccess()::get);
    }

    public boolean ignoreEntities() {
        return this.data.ignoreEntities();
    }

    public BaseBlockPosition getSize() {
        return this.data.size();
    }

    public EnumBlockRotation getRotation() {
        return this.getTestHolder().map(Holder::value).map(GameTestInstance::rotation).orElse(EnumBlockRotation.NONE).getRotated(this.data.rotation());
    }

    public Optional<IChatBaseComponent> errorMessage() {
        return this.data.errorMessage();
    }

    public void setErrorMessage(IChatBaseComponent var0) {
        this.set(this.data.withError(var0));
    }

    public void setSuccess() {
        this.set(this.data.withStatus(b.FINISHED));
        this.removeBarriers();
    }

    public void setRunning() {
        this.set(this.data.withStatus(b.RUNNING));
    }

    @Override
    public void setChanged() {
        super.setChanged();
        if (this.level instanceof WorldServer) {
            this.level.sendBlockUpdated(this.getBlockPos(), Blocks.AIR.defaultBlockState(), this.getBlockState(), 3);
        }
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag(HolderLookup.a var0) {
        NBTTagCompound var1 = new NBTTagCompound();
        this.saveAdditional(var1, var0);
        return var1;
    }

    @Override
    protected void loadAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        NBTBase var2 = var0.get("data");
        if (var2 == null) {
            return;
        }
        a.CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var2).ifSuccess(this::set);
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0, HolderLookup.a var12) {
        DataResult var2 = a.CODEC.encode((Object)this.data, (DynamicOps)DynamicOpsNBT.INSTANCE, (Object)new NBTTagCompound());
        var2.ifSuccess(var1 -> var0.put("data", (NBTBase)var1));
    }

    @Override
    public BoundingBoxRenderable.a renderMode() {
        return BoundingBoxRenderable.a.BOX;
    }

    public BlockPosition getStructurePos() {
        return TestInstanceBlockEntity.getStructurePos(this.getBlockPos());
    }

    public static BlockPosition getStructurePos(BlockPosition var0) {
        return var0.offset(STRUCTURE_OFFSET);
    }

    @Override
    public BoundingBoxRenderable.b getRenderableBox() {
        return new BoundingBoxRenderable.b(new BlockPosition(STRUCTURE_OFFSET), this.getTransformedSize());
    }

    @Override
    public List<BeaconBeamOwner.a> getBeamSections() {
        return switch (this.data.status().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> BEAM_CLEARED;
            case 1 -> BEAM_RUNNING;
            case 2 -> this.errorMessage().isEmpty() ? BEAM_SUCCESS : (this.getTestHolder().map(Holder::value).map(GameTestInstance::required).orElse(true) != false ? BEAM_REQUIRED_FAILED : BEAM_OPTIONAL_FAILED);
        };
    }

    private BaseBlockPosition getTransformedSize() {
        BaseBlockPosition var0 = this.getSize();
        EnumBlockRotation var1 = this.getRotation();
        boolean var2 = var1 == EnumBlockRotation.CLOCKWISE_90 || var1 == EnumBlockRotation.COUNTERCLOCKWISE_90;
        int var3 = var2 ? var0.getZ() : var0.getX();
        int var4 = var2 ? var0.getX() : var0.getZ();
        return new BaseBlockPosition(var3, var0.getY(), var4);
    }

    public void resetTest(Consumer<IChatBaseComponent> var0) {
        this.removeBarriers();
        boolean var1 = this.placeStructure();
        if (var1) {
            var0.accept(IChatBaseComponent.translatable("test_instance_block.reset_success", this.getTestName()).withStyle(EnumChatFormat.GREEN));
        }
        this.set(this.data.withStatus(b.CLEARED));
    }

    public Optional<MinecraftKey> saveTest(Consumer<IChatBaseComponent> var0) {
        Optional<Holder.c<GameTestInstance>> var1 = this.getTestHolder();
        Optional<MinecraftKey> var2 = var1.isPresent() ? Optional.of(var1.get().value().structure()) : this.test().map(ResourceKey::location);
        if (var2.isEmpty()) {
            BlockPosition var3 = this.getBlockPos();
            var0.accept(IChatBaseComponent.translatable("test_instance_block.error.unable_to_save", var3.getX(), var3.getY(), var3.getZ()).withStyle(EnumChatFormat.RED));
            return var2;
        }
        World world = this.level;
        if (world instanceof WorldServer) {
            WorldServer var3 = (WorldServer)world;
            TileEntityStructure.saveStructure(var3, var2.get(), this.getStructurePos(), this.getSize(), this.ignoreEntities(), "", true);
        }
        return var2;
    }

    public boolean exportTest(Consumer<IChatBaseComponent> var0) {
        World world;
        Optional<MinecraftKey> var1 = this.saveTest(var0);
        if (var1.isEmpty() || !((world = this.level) instanceof WorldServer)) {
            return false;
        }
        WorldServer var2 = (WorldServer)world;
        return TestInstanceBlockEntity.export(var2, var1.get(), var0);
    }

    public static boolean export(WorldServer var0, MinecraftKey var1, Consumer<IChatBaseComponent> var2) {
        Path var3 = GameTestHarnessStructures.testStructuresDir;
        Path var4 = var0.getStructureManager().createAndValidatePathToGeneratedStructure(var1, ".nbt");
        Path var5 = DebugReportNBT.convertStructure(CachedOutput.NO_CACHE, var4, var1.getPath(), var3.resolve(var1.getNamespace()).resolve("structure"));
        if (var5 == null) {
            var2.accept(IChatBaseComponent.literal("Failed to export " + String.valueOf(var4)).withStyle(EnumChatFormat.RED));
            return true;
        }
        try {
            FileUtils.createDirectoriesSafe(var5.getParent());
        }
        catch (IOException var6) {
            var2.accept(IChatBaseComponent.literal("Could not create folder " + String.valueOf(var5.getParent())).withStyle(EnumChatFormat.RED));
            return true;
        }
        var2.accept(IChatBaseComponent.literal("Exported " + String.valueOf(var1) + " to " + String.valueOf(var5.toAbsolutePath())));
        return false;
    }

    public void runTest(Consumer<IChatBaseComponent> var0) {
        World world = this.level;
        if (!(world instanceof WorldServer)) {
            return;
        }
        WorldServer var1 = (WorldServer)world;
        Optional<Holder.c<GameTestInstance>> var2 = this.getTestHolder();
        BlockPosition var3 = this.getBlockPos();
        if (var2.isEmpty()) {
            var0.accept(IChatBaseComponent.translatable("test_instance_block.error.no_test", var3.getX(), var3.getY(), var3.getZ()).withStyle(EnumChatFormat.RED));
            return;
        }
        if (!this.placeStructure()) {
            var0.accept(IChatBaseComponent.translatable("test_instance_block.error.no_test_structure", var3.getX(), var3.getY(), var3.getZ()).withStyle(EnumChatFormat.RED));
            return;
        }
        GameTestHarnessRunner.clearMarkers(var1);
        GameTestHarnessTicker.SINGLETON.clear();
        FailedTestTracker.forgetFailedTests();
        var0.accept(IChatBaseComponent.translatable("test_instance_block.starting", var2.get().getRegisteredName()));
        GameTestHarnessInfo var4 = new GameTestHarnessInfo(var2.get(), this.data.rotation(), var1, RetryOptions.noRetries());
        var4.setTestBlockPos(var3);
        GameTestHarnessRunner var5 = GameTestHarnessRunner.a.fromInfo(List.of(var4), var1).build();
        GameTestHarnessTestCommand.trackAndStartRunner(var1.getServer().createCommandSourceStack(), var5);
    }

    public boolean placeStructure() {
        World world = this.level;
        if (world instanceof WorldServer) {
            WorldServer var0 = (WorldServer)world;
            Optional var12 = this.data.test().flatMap(var1 -> TestInstanceBlockEntity.getStructureTemplate(var0, var1));
            if (var12.isPresent()) {
                this.placeStructure(var0, (DefinedStructure)var12.get());
                return true;
            }
        }
        return false;
    }

    private void placeStructure(WorldServer var0, DefinedStructure var1) {
        DefinedStructureInfo var2 = new DefinedStructureInfo().setRotation(this.getRotation()).setIgnoreEntities(this.data.ignoreEntities()).setKnownShape(true);
        BlockPosition var3 = this.getStartCorner();
        this.forceLoadChunks();
        this.removeEntities();
        var1.placeInWorld(var0, var3, var3, var2, var0.getRandom(), 818);
    }

    private void removeEntities() {
        this.level.getEntities(null, this.getStructureBounds()).stream().filter(var0 -> !(var0 instanceof EntityHuman)).forEach(Entity::discard);
    }

    private void forceLoadChunks() {
        World world = this.level;
        if (world instanceof WorldServer) {
            WorldServer var0 = (WorldServer)world;
            this.getStructureBoundingBox().intersectingChunks().forEach(var1 -> var0.setChunkForced(var1.x, var1.z, true));
        }
    }

    public BlockPosition getStartCorner() {
        BaseBlockPosition var0 = this.getSize();
        EnumBlockRotation var1 = this.getRotation();
        BlockPosition var2 = this.getStructurePos();
        return switch (var1) {
            default -> throw new MatchException(null, null);
            case EnumBlockRotation.NONE -> var2;
            case EnumBlockRotation.CLOCKWISE_90 -> var2.offset(var0.getZ() - 1, 0, 0);
            case EnumBlockRotation.CLOCKWISE_180 -> var2.offset(var0.getX() - 1, 0, var0.getZ() - 1);
            case EnumBlockRotation.COUNTERCLOCKWISE_90 -> var2.offset(0, 0, var0.getX() - 1);
        };
    }

    public void encaseStructure() {
        this.processStructureBoundary(var0 -> {
            if (!this.level.getBlockState((BlockPosition)var0).is(Blocks.TEST_INSTANCE_BLOCK)) {
                this.level.setBlockAndUpdate((BlockPosition)var0, Blocks.BARRIER.defaultBlockState());
            }
        });
    }

    public void removeBarriers() {
        this.processStructureBoundary(var0 -> {
            if (this.level.getBlockState((BlockPosition)var0).is(Blocks.BARRIER)) {
                this.level.setBlockAndUpdate((BlockPosition)var0, Blocks.AIR.defaultBlockState());
            }
        });
    }

    public void processStructureBoundary(Consumer<BlockPosition> var02) {
        AxisAlignedBB var1 = this.getStructureBounds();
        boolean var2 = this.getTestHolder().map(var0 -> ((GameTestInstance)var0.value()).skyAccess()).orElse(false) == false;
        BlockPosition var3 = BlockPosition.containing(var1.minX, var1.minY, var1.minZ).offset(-1, -1, -1);
        BlockPosition var42 = BlockPosition.containing(var1.maxX, var1.maxY, var1.maxZ);
        BlockPosition.betweenClosedStream(var3, var42).forEach(var4 -> {
            boolean var6;
            boolean var5 = var4.getX() == var3.getX() || var4.getX() == var42.getX() || var4.getZ() == var3.getZ() || var4.getZ() == var42.getZ() || var4.getY() == var3.getY();
            boolean bl = var6 = var4.getY() == var42.getY();
            if (var5 || var6 && var2) {
                var02.accept((BlockPosition)var4);
            }
        });
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }

    public record a(Optional<ResourceKey<GameTestInstance>> test, BaseBlockPosition size, EnumBlockRotation rotation, boolean ignoreEntities, b status, Optional<IChatBaseComponent> errorMessage) {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ResourceKey.codec(Registries.TEST_INSTANCE).optionalFieldOf("test").forGetter(a::test), (App)BaseBlockPosition.CODEC.fieldOf("size").forGetter(a::size), (App)EnumBlockRotation.CODEC.fieldOf("rotation").forGetter(a::rotation), (App)Codec.BOOL.fieldOf("ignore_entities").forGetter(a::ignoreEntities), (App)b.CODEC.fieldOf("status").forGetter(a::status), (App)ComponentSerialization.CODEC.optionalFieldOf("error_message").forGetter(a::errorMessage)).apply((Applicative)var0, a::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, a> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.optional(ResourceKey.streamCodec(Registries.TEST_INSTANCE)), a::test, BaseBlockPosition.STREAM_CODEC, a::size, EnumBlockRotation.STREAM_CODEC, a::rotation, ByteBufCodecs.BOOL, a::ignoreEntities, b.STREAM_CODEC, a::status, ByteBufCodecs.optional(ComponentSerialization.STREAM_CODEC), a::errorMessage, a::new);

        public a withSize(BaseBlockPosition var0) {
            return new a(this.test, var0, this.rotation, this.ignoreEntities, this.status, this.errorMessage);
        }

        public a withStatus(b var0) {
            return new a(this.test, this.size, this.rotation, this.ignoreEntities, var0, Optional.empty());
        }

        public a withError(IChatBaseComponent var0) {
            return new a(this.test, this.size, this.rotation, this.ignoreEntities, b.FINISHED, Optional.of(var0));
        }
    }

    public static final class b
    extends Enum<b>
    implements INamable {
        public static final /* enum */ b CLEARED = new b("cleared", 0);
        public static final /* enum */ b RUNNING = new b("running", 1);
        public static final /* enum */ b FINISHED = new b("finished", 2);
        private static final IntFunction<b> ID_MAP;
        public static final Codec<b> CODEC;
        public static final StreamCodec<ByteBuf, b> STREAM_CODEC;
        private final String id;
        private final int index;
        private static final /* synthetic */ b[] i;

        public static b[] values() {
            return (b[])i.clone();
        }

        public static b valueOf(String var0) {
            return Enum.valueOf(b.class, var0);
        }

        private b(String var2, int var3) {
            this.id = var2;
            this.index = var3;
        }

        @Override
        public String getSerializedName() {
            return this.id;
        }

        public static b byIndex(int var0) {
            return ID_MAP.apply(var0);
        }

        private static /* synthetic */ b[] a() {
            return new b[]{CLEARED, RUNNING, FINISHED};
        }

        static {
            i = b.a();
            ID_MAP = ByIdMap.continuous(var0 -> var0.index, b.values(), ByIdMap.a.ZERO);
            CODEC = INamable.fromEnum(b::values);
            STREAM_CODEC = ByteBufCodecs.idMapper(b::byIndex, var0 -> var0.index);
        }
    }
}

