/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class TestInstanceBlock
extends BlockTileEntity
implements GameMasterBlock {
    public static final MapCodec<TestInstanceBlock> CODEC = TestInstanceBlock.simpleCodec(TestInstanceBlock::new);

    public TestInstanceBlock(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    @Nullable
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TestInstanceBlockEntity(var0, var1);
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        TileEntity var5 = var1.getBlockEntity(var2);
        if (!(var5 instanceof TestInstanceBlockEntity)) {
            return EnumInteractionResult.PASS;
        }
        TestInstanceBlockEntity var6 = (TestInstanceBlockEntity)var5;
        if (!var3.canUseGameMasterBlocks()) {
            return EnumInteractionResult.PASS;
        }
        if (var3.getCommandSenderWorld().isClientSide) {
            var3.openTestInstanceBlock(var6);
        }
        return EnumInteractionResult.SUCCESS;
    }

    protected MapCodec<TestInstanceBlock> codec() {
        return CODEC;
    }
}

