/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class DryVegetationBlock
extends VegetationBlock {
    public static final MapCodec<DryVegetationBlock> CODEC = DryVegetationBlock.simpleCodec(DryVegetationBlock::new);
    private static final VoxelShape SHAPE = Block.column(12.0, 0.0, 13.0);
    private static final int IDLE_SOUND_CHANCE = 150;
    private static final int IDLE_SOUND_BADLANDS_DECREASED_CHANCE = 5;

    public MapCodec<? extends DryVegetationBlock> codec() {
        return CODEC;
    }

    protected DryVegetationBlock(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    protected boolean mayPlaceOn(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return var0.is(TagsBlock.DRY_VEGETATION_MAY_PLACE_ON);
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        if (var3.nextInt(150) == 0) {
            IBlockData var4 = var1.getBlockState(var2.below());
            if ((var4.is(Blocks.RED_SAND) || var4.is(TagsBlock.TERRACOTTA)) && var3.nextInt(5) != 0) {
                return;
            }
            IBlockData var5 = var1.getBlockState(var2.below(2));
            if (var4.is(TagsBlock.PLAYS_AMBIENT_DESERT_BLOCK_SOUNDS) && var5.is(TagsBlock.PLAYS_AMBIENT_DESERT_BLOCK_SOUNDS)) {
                var1.playLocalSound(var2.getX(), var2.getY(), var2.getZ(), SoundEffects.DEAD_BUSH_IDLE, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
            }
        }
    }
}

