/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.slf4j.Logger;

public class BlockPortal
extends Block
implements Portal {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<BlockPortal> CODEC = BlockPortal.simpleCodec(BlockPortal::new);
    public static final BlockStateEnum<EnumDirection.EnumAxis> AXIS = BlockProperties.HORIZONTAL_AXIS;
    private static final Map<EnumDirection.EnumAxis, VoxelShape> SHAPES = VoxelShapes.rotateHorizontalAxis(Block.column(4.0, 16.0, 0.0, 16.0));

    public MapCodec<BlockPortal> codec() {
        return CODEC;
    }

    public BlockPortal(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(AXIS, EnumDirection.EnumAxis.X));
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPES.get(var0.getValue(AXIS));
    }

    @Override
    protected VoxelShape getEntityInsideCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, Entity var3) {
        return var0.getShape(var1, var2);
    }

    @Override
    protected void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (var1.dimensionType().natural() && var1.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && var3.nextInt(2000) < var1.getDifficulty().getId() && var1.anyPlayerCloseEnoughForSpawning(var2)) {
            EntityPigZombie var4;
            while (var1.getBlockState(var2).is(this)) {
                var2 = var2.below();
            }
            if (var1.getBlockState(var2).isValidSpawn(var1, var2, EntityTypes.ZOMBIFIED_PIGLIN) && (var4 = EntityTypes.ZOMBIFIED_PIGLIN.spawn(var1, var2.above(), EntitySpawnReason.STRUCTURE)) != null) {
                var4.setPortalCooldown();
                Entity var5 = var4.getVehicle();
                if (var5 != null) {
                    var5.setPortalCooldown();
                }
            }
        }
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        boolean var10;
        EnumDirection.EnumAxis var8 = var4.getAxis();
        EnumDirection.EnumAxis var9 = var0.getValue(AXIS);
        boolean bl = var10 = var9 != var8 && var8.isHorizontal();
        if (var10 || var6.is(this) || BlockPortalShape.findAnyShape(var1, var3, var9).isComplete()) {
            return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Override
    protected void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3, InsideBlockEffectApplier var4) {
        if (var3.canUsePortal(false)) {
            var3.setAsInsidePortal(this, var2);
        }
    }

    @Override
    public int getPortalTransitionTime(WorldServer var0, Entity var1) {
        if (var1 instanceof EntityHuman) {
            EntityHuman var2 = (EntityHuman)var1;
            return Math.max(0, var0.getGameRules().getInt(var2.getAbilities().invulnerable ? GameRules.RULE_PLAYERS_NETHER_PORTAL_CREATIVE_DELAY : GameRules.RULE_PLAYERS_NETHER_PORTAL_DEFAULT_DELAY));
        }
        return 0;
    }

    @Override
    @Nullable
    public TeleportTransition getPortalDestination(WorldServer var0, Entity var1, BlockPosition var2) {
        ResourceKey<World> var3 = var0.dimension() == World.NETHER ? World.OVERWORLD : World.NETHER;
        WorldServer var4 = var0.getServer().getLevel(var3);
        if (var4 == null) {
            return null;
        }
        boolean var5 = var4.dimension() == World.NETHER;
        WorldBorder var6 = var4.getWorldBorder();
        double var7 = DimensionManager.getTeleportationScale(var0.dimensionType(), var4.dimensionType());
        BlockPosition var9 = var6.clampToBounds(var1.getX() * var7, var1.getY(), var1.getZ() * var7);
        return this.getExitPortal(var4, var1, var2, var9, var5, var6);
    }

    @Nullable
    private TeleportTransition getExitPortal(WorldServer var0, Entity var12, BlockPosition var22, BlockPosition var3, boolean var4, WorldBorder var5) {
        TeleportTransition.a var8;
        BlockUtil.Rectangle var7;
        Optional<BlockPosition> var6 = var0.getPortalForcer().findClosestPortalPosition(var3, var4, var5);
        if (var6.isPresent()) {
            BlockPosition var9 = var6.get();
            IBlockData var10 = var0.getBlockState(var9);
            var7 = BlockUtil.getLargestRectangleAround(var9, var10.getValue(BlockProperties.HORIZONTAL_AXIS), 21, EnumDirection.EnumAxis.Y, 21, var2 -> var0.getBlockState((BlockPosition)var2) == var10);
            var8 = TeleportTransition.PLAY_PORTAL_SOUND.then(var1 -> var1.placePortalTicket(var9));
        } else {
            EnumDirection.EnumAxis var9 = var12.level().getBlockState(var22).getOptionalValue(AXIS).orElse(EnumDirection.EnumAxis.X);
            Optional<BlockUtil.Rectangle> var10 = var0.getPortalForcer().createPortal(var3, var9);
            if (var10.isEmpty()) {
                LOGGER.error("Unable to create a portal, likely target out of worldborder");
                return null;
            }
            var7 = var10.get();
            var8 = TeleportTransition.PLAY_PORTAL_SOUND.then(TeleportTransition.PLACE_PORTAL_TICKET);
        }
        return BlockPortal.getDimensionTransitionFromExit(var12, var22, var7, var0, var8);
    }

    private static TeleportTransition getDimensionTransitionFromExit(Entity var0, BlockPosition var1, BlockUtil.Rectangle var22, WorldServer var3, TeleportTransition.a var4) {
        Vec3D var6;
        EnumDirection.EnumAxis var5;
        IBlockData var7 = var0.level().getBlockState(var1);
        if (var7.hasProperty(BlockProperties.HORIZONTAL_AXIS)) {
            var5 = var7.getValue(BlockProperties.HORIZONTAL_AXIS);
            BlockUtil.Rectangle var8 = BlockUtil.getLargestRectangleAround(var1, var5, 21, EnumDirection.EnumAxis.Y, 21, var2 -> var0.level().getBlockState((BlockPosition)var2) == var7);
            var6 = var0.getRelativePortalPosition(var5, var8);
        } else {
            var5 = EnumDirection.EnumAxis.X;
            var6 = new Vec3D(0.5, 0.0, 0.0);
        }
        return BlockPortal.createDimensionTransition(var3, var22, var5, var6, var0, var4);
    }

    private static TeleportTransition createDimensionTransition(WorldServer var0, BlockUtil.Rectangle var1, EnumDirection.EnumAxis var2, Vec3D var3, Entity var4, TeleportTransition.a var5) {
        BlockPosition var6 = var1.minCorner;
        IBlockData var7 = var0.getBlockState(var6);
        EnumDirection.EnumAxis var8 = var7.getOptionalValue(BlockProperties.HORIZONTAL_AXIS).orElse(EnumDirection.EnumAxis.X);
        double var9 = var1.axis1Size;
        double var11 = var1.axis2Size;
        EntitySize var13 = var4.getDimensions(var4.getPose());
        int var14 = var2 == var8 ? 0 : 90;
        double var15 = (double)var13.width() / 2.0 + (var9 - (double)var13.width()) * var3.x();
        double var17 = (var11 - (double)var13.height()) * var3.y();
        double var19 = 0.5 + var3.z();
        boolean var21 = var8 == EnumDirection.EnumAxis.X;
        Vec3D var22 = new Vec3D((double)var6.getX() + (var21 ? var15 : var19), (double)var6.getY() + var17, (double)var6.getZ() + (var21 ? var19 : var15));
        Vec3D var23 = BlockPortalShape.findCollisionFreePosition(var22, var0, var4, var13);
        return new TeleportTransition(var0, var23, Vec3D.ZERO, var14, 0.0f, Relative.union(Relative.DELTA, Relative.ROTATION), var5);
    }

    @Override
    public Portal.a getLocalTransition() {
        return Portal.a.CONFUSION;
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        if (var3.nextInt(100) == 0) {
            var1.playLocalSound((double)var2.getX() + 0.5, (double)var2.getY() + 0.5, (double)var2.getZ() + 0.5, SoundEffects.PORTAL_AMBIENT, SoundCategory.BLOCKS, 0.5f, var3.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int var4 = 0; var4 < 4; ++var4) {
            double var5 = (double)var2.getX() + var3.nextDouble();
            double var7 = (double)var2.getY() + var3.nextDouble();
            double var9 = (double)var2.getZ() + var3.nextDouble();
            double var11 = ((double)var3.nextFloat() - 0.5) * 0.5;
            double var13 = ((double)var3.nextFloat() - 0.5) * 0.5;
            double var15 = ((double)var3.nextFloat() - 0.5) * 0.5;
            int var17 = var3.nextInt(2) * 2 - 1;
            if (var1.getBlockState(var2.west()).is(this) || var1.getBlockState(var2.east()).is(this)) {
                var9 = (double)var2.getZ() + 0.5 + 0.25 * (double)var17;
                var15 = var3.nextFloat() * 2.0f * (float)var17;
            } else {
                var5 = (double)var2.getX() + 0.5 + 0.25 * (double)var17;
                var11 = var3.nextFloat() * 2.0f * (float)var17;
            }
            var1.addParticle(Particles.PORTAL, var5, var7, var9, var11, var13, var15);
        }
    }

    @Override
    protected ItemStack getCloneItemStack(IWorldReader var0, BlockPosition var1, IBlockData var2, boolean var3) {
        return ItemStack.EMPTY;
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        switch (var1) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch (var0.getValue(AXIS)) {
                    case X: {
                        return (IBlockData)var0.setValue(AXIS, EnumDirection.EnumAxis.Z);
                    }
                    case Z: {
                        return (IBlockData)var0.setValue(AXIS, EnumDirection.EnumAxis.X);
                    }
                }
                return var0;
            }
        }
        return var0;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(AXIS);
    }
}

