/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataAbstract;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.RecipeSingleItem;
import net.minecraft.world.item.crafting.RecipeStonecutting;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.SelectableRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import net.minecraft.world.level.World;
import org.slf4j.Logger;

public class CraftingManager
extends ResourceDataAbstract<RecipeMap>
implements RecipeAccess {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<ResourceKey<RecipePropertySet>, c> RECIPE_PROPERTY_SETS = Map.of(RecipePropertySet.SMITHING_ADDITION, var0 -> {
        Optional<Object> optional;
        if (var0 instanceof SmithingRecipe) {
            SmithingRecipe var1 = (SmithingRecipe)var0;
            optional = var1.additionIngredient();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.SMITHING_BASE, var0 -> {
        Optional<Object> optional;
        if (var0 instanceof SmithingRecipe) {
            SmithingRecipe var1 = (SmithingRecipe)var0;
            optional = Optional.of(var1.baseIngredient());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.SMITHING_TEMPLATE, var0 -> {
        Optional<Object> optional;
        if (var0 instanceof SmithingRecipe) {
            SmithingRecipe var1 = (SmithingRecipe)var0;
            optional = var1.templateIngredient();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.FURNACE_INPUT, CraftingManager.forSingleInput(Recipes.SMELTING), RecipePropertySet.BLAST_FURNACE_INPUT, CraftingManager.forSingleInput(Recipes.BLASTING), RecipePropertySet.SMOKER_INPUT, CraftingManager.forSingleInput(Recipes.SMOKING), RecipePropertySet.CAMPFIRE_INPUT, CraftingManager.forSingleInput(Recipes.CAMPFIRE_COOKING));
    private static final FileToIdConverter RECIPE_LISTER = FileToIdConverter.registry(Registries.RECIPE);
    private final HolderLookup.a registries;
    public RecipeMap recipes = RecipeMap.EMPTY;
    private Map<ResourceKey<RecipePropertySet>, RecipePropertySet> propertySets = Map.of();
    private SelectableRecipe.b<RecipeStonecutting> stonecutterRecipes = SelectableRecipe.b.empty();
    private List<d> allDisplays = List.of();
    private Map<ResourceKey<IRecipe<?>>, List<d>> recipeToDisplay = Map.of();

    public CraftingManager(HolderLookup.a var0) {
        this.registries = var0;
    }

    @Override
    protected RecipeMap prepare(IResourceManager var0, GameProfilerFiller var12) {
        TreeMap<MinecraftKey, IRecipe> var22 = new TreeMap<MinecraftKey, IRecipe>();
        ResourceDataJson.scanDirectory(var0, RECIPE_LISTER, this.registries.createSerializationContext(JsonOps.INSTANCE), IRecipe.CODEC, var22);
        ArrayList var3 = new ArrayList(var22.size());
        var22.forEach((var1, var2) -> {
            ResourceKey<IRecipe<?>> var3 = ResourceKey.create(Registries.RECIPE, var1);
            RecipeHolder<IRecipe> var4 = new RecipeHolder<IRecipe>(var3, (IRecipe)var2);
            var3.add(var4);
        });
        return RecipeMap.create(var3);
    }

    @Override
    protected void apply(RecipeMap var0, IResourceManager var1, GameProfilerFiller var2) {
        this.recipes = var0;
        LOGGER.info("Loaded {} recipes", (Object)var0.values().size());
    }

    public void finalizeRecipeLoading(FeatureFlagSet var02) {
        ArrayList var12 = new ArrayList();
        List<b> var2 = RECIPE_PROPERTY_SETS.entrySet().stream().map(var0 -> new b((ResourceKey)var0.getKey(), (c)var0.getValue())).toList();
        this.recipes.values().forEach(var3 -> {
            Object var4 = var3.value();
            if (!var4.isSpecial() && var4.placementInfo().isImpossibleToPlace()) {
                LOGGER.warn("Recipe {} can't be placed due to empty ingredients and will be ignored", (Object)var3.id().location());
                return;
            }
            var2.forEach(var1 -> var1.accept((IRecipe<?>)var4));
            if (var4 instanceof RecipeStonecutting) {
                RecipeStonecutting var5 = (RecipeStonecutting)var4;
                RecipeHolder var6 = var3;
                if (CraftingManager.isIngredientEnabled(var02, var5.input()) && var5.resultDisplay().isEnabled(var02)) {
                    var12.add(new SelectableRecipe.a(var5.input(), new SelectableRecipe(var5.resultDisplay(), Optional.of(var6))));
                }
            }
        });
        this.propertySets = var2.stream().collect(Collectors.toUnmodifiableMap(var0 -> var0.key, var1 -> var1.asPropertySet(var02)));
        this.stonecutterRecipes = new SelectableRecipe.b(var12);
        this.allDisplays = CraftingManager.unpackRecipeInfo(this.recipes.values(), var02);
        this.recipeToDisplay = this.allDisplays.stream().collect(Collectors.groupingBy(var0 -> var0.parent.id(), IdentityHashMap::new, Collectors.toList()));
    }

    static List<RecipeItemStack> filterDisabled(FeatureFlagSet var0, List<RecipeItemStack> var12) {
        var12.removeIf(var1 -> !CraftingManager.isIngredientEnabled(var0, var1));
        return var12;
    }

    private static boolean isIngredientEnabled(FeatureFlagSet var0, RecipeItemStack var12) {
        return var12.items().allMatch(var1 -> ((Item)var1.value()).isEnabled(var0));
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Optional<RecipeHolder<T>> getRecipeFor(Recipes<T> var0, I var1, World var2, @Nullable ResourceKey<IRecipe<?>> var3) {
        RecipeHolder<T> var4 = var3 != null ? this.byKeyTyped(var0, var3) : null;
        return this.getRecipeFor(var0, var1, var2, var4);
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Optional<RecipeHolder<T>> getRecipeFor(Recipes<T> var0, I var1, World var2, @Nullable RecipeHolder<T> var3) {
        if (var3 != null && var3.value().matches(var1, var2)) {
            return Optional.of(var3);
        }
        return this.getRecipeFor(var0, var1, var2);
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Optional<RecipeHolder<T>> getRecipeFor(Recipes<T> var0, I var1, World var2) {
        return this.recipes.getRecipesFor(var0, var1, var2).findFirst();
    }

    public Optional<RecipeHolder<?>> byKey(ResourceKey<IRecipe<?>> var0) {
        return Optional.ofNullable(this.recipes.byKey(var0));
    }

    @Nullable
    private <T extends IRecipe<?>> RecipeHolder<T> byKeyTyped(Recipes<T> var0, ResourceKey<IRecipe<?>> var1) {
        RecipeHolder<?> var2 = this.recipes.byKey(var1);
        if (var2 != null && var2.value().getType().equals(var0)) {
            return var2;
        }
        return null;
    }

    public Map<ResourceKey<RecipePropertySet>, RecipePropertySet> getSynchronizedItemProperties() {
        return this.propertySets;
    }

    public SelectableRecipe.b<RecipeStonecutting> getSynchronizedStonecutterRecipes() {
        return this.stonecutterRecipes;
    }

    @Override
    public RecipePropertySet propertySet(ResourceKey<RecipePropertySet> var0) {
        return this.propertySets.getOrDefault(var0, RecipePropertySet.EMPTY);
    }

    @Override
    public SelectableRecipe.b<RecipeStonecutting> stonecutterRecipes() {
        return this.stonecutterRecipes;
    }

    public Collection<RecipeHolder<?>> getRecipes() {
        return this.recipes.values();
    }

    @Nullable
    public d getRecipeFromDisplay(RecipeDisplayId var0) {
        return this.allDisplays.get(var0.index());
    }

    public void listDisplaysForRecipe(ResourceKey<IRecipe<?>> var0, Consumer<RecipeDisplayEntry> var12) {
        List<d> var2 = this.recipeToDisplay.get(var0);
        if (var2 != null) {
            var2.forEach(var1 -> var12.accept(var1.display));
        }
    }

    @VisibleForTesting
    protected static RecipeHolder<?> fromJson(ResourceKey<IRecipe<?>> var0, JsonObject var1, HolderLookup.a var2) {
        IRecipe var3 = (IRecipe)IRecipe.CODEC.parse(var2.createSerializationContext(JsonOps.INSTANCE), (Object)var1).getOrThrow(JsonParseException::new);
        return new RecipeHolder<IRecipe>(var0, var3);
    }

    public static <I extends RecipeInput, T extends IRecipe<I>> a<I, T> createCheck(final Recipes<T> var0) {
        return new a<I, T>(){
            @Nullable
            private ResourceKey<IRecipe<?>> lastRecipe;

            @Override
            public Optional<RecipeHolder<T>> getRecipeFor(I var02, WorldServer var1) {
                CraftingManager var2 = var1.recipeAccess();
                Optional var3 = var2.getRecipeFor(var0, var02, (World)var1, this.lastRecipe);
                if (var3.isPresent()) {
                    RecipeHolder var4 = var3.get();
                    this.lastRecipe = var4.id();
                    return Optional.of(var4);
                }
                return Optional.empty();
            }
        };
    }

    private static List<d> unpackRecipeInfo(Iterable<RecipeHolder<?>> var0, FeatureFlagSet var1) {
        ArrayList<d> var2 = new ArrayList<d>();
        Object2IntOpenHashMap var3 = new Object2IntOpenHashMap();
        for (RecipeHolder<?> var5 : var0) {
            Object var6 = var5.value();
            OptionalInt var7 = var6.group().isEmpty() ? OptionalInt.empty() : OptionalInt.of(var3.computeIfAbsent((Object)var6.group(), arg_0 -> CraftingManager.a((Object2IntMap)var3, arg_0)));
            Optional<Object> var8 = var6.isSpecial() ? Optional.empty() : Optional.of(var6.placementInfo().ingredients());
            for (RecipeDisplay var10 : var6.display()) {
                if (!var10.isEnabled(var1)) continue;
                int var11 = var2.size();
                RecipeDisplayId var12 = new RecipeDisplayId(var11);
                RecipeDisplayEntry var13 = new RecipeDisplayEntry(var12, var10, var7, var6.recipeBookCategory(), var8);
                var2.add(new d(var13, var5));
            }
        }
        return var2;
    }

    private static c forSingleInput(Recipes<? extends RecipeSingleItem> var0) {
        return var1 -> {
            Optional<Object> optional;
            if (var1.getType() == var0 && var1 instanceof RecipeSingleItem) {
                RecipeSingleItem var2 = (RecipeSingleItem)var1;
                optional = Optional.of(var2.input());
            } else {
                optional = Optional.empty();
            }
            return optional;
        };
    }

    @Override
    protected /* synthetic */ Object prepare(IResourceManager iResourceManager, GameProfilerFiller gameProfilerFiller) {
        return this.prepare(iResourceManager, gameProfilerFiller);
    }

    private static /* synthetic */ int a(Object2IntMap var0, Object var1) {
        return var0.size();
    }

    public static final class d
    extends Record {
        final RecipeDisplayEntry display;
        final RecipeHolder<?> parent;

        public d(RecipeDisplayEntry var0, RecipeHolder<?> var1) {
            this.display = var0;
            this.parent = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "display;parent", "display", "parent"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "display;parent", "display", "parent"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "display;parent", "display", "parent"}, this, var0);
        }

        public RecipeDisplayEntry display() {
            return this.display;
        }

        public RecipeHolder<?> parent() {
            return this.parent;
        }
    }

    @FunctionalInterface
    public static interface c {
        public Optional<RecipeItemStack> apply(IRecipe<?> var1);
    }

    public static class b
    implements Consumer<IRecipe<?>> {
        final ResourceKey<RecipePropertySet> key;
        private final c extractor;
        private final List<RecipeItemStack> ingredients = new ArrayList<RecipeItemStack>();

        protected b(ResourceKey<RecipePropertySet> var0, c var1) {
            this.key = var0;
            this.extractor = var1;
        }

        @Override
        public void accept(IRecipe<?> var0) {
            this.extractor.apply(var0).ifPresent(this.ingredients::add);
        }

        public RecipePropertySet asPropertySet(FeatureFlagSet var0) {
            return RecipePropertySet.create(CraftingManager.filterDisabled(var0, this.ingredients));
        }

        @Override
        public /* synthetic */ void accept(Object object) {
            this.accept((IRecipe)object);
        }
    }

    public static interface a<I extends RecipeInput, T extends IRecipe<I>> {
        public Optional<RecipeHolder<T>> getRecipeFor(I var1, WorldServer var2);
    }
}

