/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.NullOps;
import net.minecraft.util.Unit;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.component.UseCooldown;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

public final class ItemStack
implements DataComponentHolder {
    private static final List<IChatBaseComponent> OP_NBT_WARNING = List.of(IChatBaseComponent.translatable("item.op_warning.line1").withStyle(EnumChatFormat.RED, EnumChatFormat.BOLD), IChatBaseComponent.translatable("item.op_warning.line2").withStyle(EnumChatFormat.RED), IChatBaseComponent.translatable("item.op_warning.line3").withStyle(EnumChatFormat.RED));
    private static final IChatBaseComponent UNBREAKABLE_TOOLTIP = IChatBaseComponent.translatable("item.unbreakable").withStyle(EnumChatFormat.BLUE);
    public static final MapCodec<ItemStack> MAP_CODEC = MapCodec.recursive((String)"ItemStack", var0 -> RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Item.CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)ExtraCodecs.intRange(1, 99).fieldOf("count").orElse((Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(var0 -> var0.components.asPatch())).apply((Applicative)var02, ItemStack::new)));
    public static final Codec<ItemStack> CODEC = Codec.lazyInitialized(() -> MAP_CODEC.codec());
    public static final Codec<ItemStack> SINGLE_ITEM_CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(var02 -> var02.group((App)Item.CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(var0 -> var0.components.asPatch())).apply((Applicative)var02, (var0, var1) -> new ItemStack((Holder<Item>)var0, 1, (DataComponentPatch)var1))));
    public static final Codec<ItemStack> STRICT_CODEC = CODEC.validate(ItemStack::validateStrict);
    public static final Codec<ItemStack> STRICT_SINGLE_ITEM_CODEC = SINGLE_ITEM_CODEC.validate(ItemStack::validateStrict);
    public static final Codec<ItemStack> OPTIONAL_CODEC = ExtraCodecs.optionalEmptyMap(CODEC).xmap(var0 -> var0.orElse(EMPTY), var0 -> var0.isEmpty() ? Optional.empty() : Optional.of(var0));
    public static final Codec<ItemStack> SIMPLE_ITEM_CODEC = Item.CODEC.xmap(ItemStack::new, ItemStack::getItemHolder);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> OPTIONAL_STREAM_CODEC = ItemStack.createOptionalStreamCodec(DataComponentPatch.STREAM_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> OPTIONAL_UNTRUSTED_STREAM_CODEC = ItemStack.createOptionalStreamCodec(DataComponentPatch.DELIMITED_STREAM_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

        @Override
        public ItemStack decode(RegistryFriendlyByteBuf var0) {
            ItemStack var1 = (ItemStack)OPTIONAL_STREAM_CODEC.decode(var0);
            if (var1.isEmpty()) {
                throw new DecoderException("Empty ItemStack not allowed");
            }
            return var1;
        }

        @Override
        public void encode(RegistryFriendlyByteBuf var0, ItemStack var1) {
            if (var1.isEmpty()) {
                throw new EncoderException("Empty ItemStack not allowed");
            }
            OPTIONAL_STREAM_CODEC.encode(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((RegistryFriendlyByteBuf)((Object)object), (ItemStack)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((RegistryFriendlyByteBuf)((Object)object));
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, List<ItemStack>> OPTIONAL_LIST_STREAM_CODEC = OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity));
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ItemStack EMPTY = new ItemStack((Void)null);
    private static final IChatBaseComponent DISABLED_ITEM_TOOLTIP = IChatBaseComponent.translatable("item.disabled").withStyle(EnumChatFormat.RED);
    private int count;
    private int popTime;
    @Deprecated
    @Nullable
    private Item item;
    final PatchedDataComponentMap components;
    @Nullable
    private Entity entityRepresentation;

    public static DataResult<ItemStack> validateStrict(ItemStack var0) {
        DataResult<Unit> var12 = ItemStack.validateComponents(var0.getComponents());
        if (var12.isError()) {
            return var12.map(var1 -> var0);
        }
        if (var0.getCount() > var0.getMaxStackSize()) {
            return DataResult.error(() -> "Item stack with stack size of " + var0.getCount() + " was larger than maximum: " + var0.getMaxStackSize());
        }
        return DataResult.success((Object)var0);
    }

    private static StreamCodec<RegistryFriendlyByteBuf, ItemStack> createOptionalStreamCodec(final StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch> var0) {
        return new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

            @Override
            public ItemStack decode(RegistryFriendlyByteBuf var02) {
                int var1 = var02.readVarInt();
                if (var1 <= 0) {
                    return EMPTY;
                }
                Holder var2 = (Holder)Item.STREAM_CODEC.decode(var02);
                DataComponentPatch var3 = (DataComponentPatch)var0.decode(var02);
                return new ItemStack(var2, var1, var3);
            }

            @Override
            public void encode(RegistryFriendlyByteBuf var02, ItemStack var1) {
                if (var1.isEmpty()) {
                    var02.writeVarInt(0);
                    return;
                }
                var02.writeVarInt(var1.getCount());
                Item.STREAM_CODEC.encode(var02, var1.getItemHolder());
                var0.encode(var02, var1.components.asPatch());
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((RegistryFriendlyByteBuf)((Object)object), (ItemStack)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ItemStack> validatedStreamCodec(final StreamCodec<RegistryFriendlyByteBuf, ItemStack> var0) {
        return new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

            @Override
            public ItemStack decode(RegistryFriendlyByteBuf var02) {
                ItemStack var1 = (ItemStack)var0.decode(var02);
                if (!var1.isEmpty()) {
                    RegistryOps<Unit> var2 = var02.registryAccess().createSerializationContext(NullOps.INSTANCE);
                    CODEC.encodeStart(var2, (Object)var1).getOrThrow(DecoderException::new);
                }
                return var1;
            }

            @Override
            public void encode(RegistryFriendlyByteBuf var02, ItemStack var1) {
                var0.encode(var02, var1);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((RegistryFriendlyByteBuf)((Object)object), (ItemStack)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }

    public Optional<TooltipComponent> getTooltipImage() {
        return this.getItem().getTooltipImage(this);
    }

    @Override
    public DataComponentMap getComponents() {
        return !this.isEmpty() ? this.components : DataComponentMap.EMPTY;
    }

    public DataComponentMap getPrototype() {
        return !this.isEmpty() ? this.getItem().components() : DataComponentMap.EMPTY;
    }

    public DataComponentPatch getComponentsPatch() {
        return !this.isEmpty() ? this.components.asPatch() : DataComponentPatch.EMPTY;
    }

    public DataComponentMap immutableComponents() {
        return !this.isEmpty() ? this.components.toImmutableMap() : DataComponentMap.EMPTY;
    }

    public boolean hasNonDefault(DataComponentType<?> var0) {
        return !this.isEmpty() && this.components.hasNonDefault(var0);
    }

    public ItemStack(IMaterial var0) {
        this(var0, 1);
    }

    public ItemStack(Holder<Item> var0) {
        this(var0.value(), 1);
    }

    public ItemStack(Holder<Item> var0, int var1, DataComponentPatch var2) {
        this(var0.value(), var1, PatchedDataComponentMap.fromPatch(var0.value().components(), var2));
    }

    public ItemStack(Holder<Item> var0, int var1) {
        this(var0.value(), var1);
    }

    public ItemStack(IMaterial var0, int var1) {
        this(var0, var1, new PatchedDataComponentMap(var0.asItem().components()));
    }

    private ItemStack(IMaterial var0, int var1, PatchedDataComponentMap var2) {
        this.item = var0.asItem();
        this.count = var1;
        this.components = var2;
        this.getItem().verifyComponentsAfterLoad(this);
    }

    private ItemStack(@Nullable Void var0) {
        this.item = null;
        this.components = new PatchedDataComponentMap(DataComponentMap.EMPTY);
    }

    public static DataResult<Unit> validateComponents(DataComponentMap var0) {
        if (var0.has(DataComponents.MAX_DAMAGE) && var0.getOrDefault(DataComponents.MAX_STACK_SIZE, 1) > 1) {
            return DataResult.error(() -> "Item cannot be both damageable and stackable");
        }
        ItemContainerContents var1 = var0.getOrDefault(DataComponents.CONTAINER, ItemContainerContents.EMPTY);
        for (ItemStack var3 : var1.nonEmptyItems()) {
            int var5;
            int var4 = var3.getCount();
            if (var4 <= (var5 = var3.getMaxStackSize())) continue;
            return DataResult.error(() -> "Item stack with count of " + var4 + " was larger than maximum: " + var5);
        }
        return DataResult.success((Object)((Object)Unit.INSTANCE));
    }

    public static Optional<ItemStack> parse(HolderLookup.a var02, NBTBase var1) {
        return CODEC.parse(var02.createSerializationContext(DynamicOpsNBT.INSTANCE), (Object)var1).resultOrPartial(var0 -> LOGGER.error("Tried to load invalid item: '{}'", var0));
    }

    public boolean isEmpty() {
        return this == EMPTY || this.item == Items.AIR || this.count <= 0;
    }

    public boolean isItemEnabled(FeatureFlagSet var0) {
        return this.isEmpty() || this.getItem().isEnabled(var0);
    }

    public ItemStack split(int var0) {
        int var1 = Math.min(var0, this.getCount());
        ItemStack var2 = this.copyWithCount(var1);
        this.shrink(var1);
        return var2;
    }

    public ItemStack copyAndClear() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ItemStack var0 = this.copy();
        this.setCount(0);
        return var0;
    }

    public Item getItem() {
        return this.isEmpty() ? Items.AIR : this.item;
    }

    public Holder<Item> getItemHolder() {
        return this.getItem().builtInRegistryHolder();
    }

    public boolean is(TagKey<Item> var0) {
        return this.getItem().builtInRegistryHolder().is(var0);
    }

    public boolean is(Item var0) {
        return this.getItem() == var0;
    }

    public boolean is(Predicate<Holder<Item>> var0) {
        return var0.test(this.getItem().builtInRegistryHolder());
    }

    public boolean is(Holder<Item> var0) {
        return this.getItem().builtInRegistryHolder() == var0;
    }

    public boolean is(HolderSet<Item> var0) {
        return var0.contains(this.getItemHolder());
    }

    public Stream<TagKey<Item>> getTags() {
        return this.getItem().builtInRegistryHolder().tags();
    }

    public EnumInteractionResult useOn(ItemActionContext var0) {
        EnumInteractionResult.d var5;
        EntityHuman var1 = var0.getPlayer();
        BlockPosition var2 = var0.getClickedPos();
        if (var1 != null && !var1.getAbilities().mayBuild && !this.canPlaceOnBlockInAdventureMode(new ShapeDetectorBlock(var0.getLevel(), var2, false))) {
            return EnumInteractionResult.PASS;
        }
        Item var3 = this.getItem();
        EnumInteractionResult var4 = var3.useOn(var0);
        if (var1 != null && var4 instanceof EnumInteractionResult.d && (var5 = (EnumInteractionResult.d)var4).wasItemInteraction()) {
            var1.awardStat(StatisticList.ITEM_USED.get(var3));
        }
        return var4;
    }

    public float getDestroySpeed(IBlockData var0) {
        return this.getItem().getDestroySpeed(this, var0);
    }

    public EnumInteractionResult use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = this.copy();
        boolean var4 = this.getUseDuration(var1) <= 0;
        EnumInteractionResult var5 = this.getItem().use(var0, var1, var2);
        if (var4 && var5 instanceof EnumInteractionResult.d) {
            EnumInteractionResult.d var6;
            return var6.heldItemTransformedTo((var6 = (EnumInteractionResult.d)var5).heldItemTransformedTo() == null ? this.applyAfterUseComponentSideEffects(var1, var3) : var6.heldItemTransformedTo().applyAfterUseComponentSideEffects(var1, var3));
        }
        return var5;
    }

    public ItemStack finishUsingItem(World var0, EntityLiving var1) {
        ItemStack var2 = this.copy();
        ItemStack var3 = this.getItem().finishUsingItem(this, var0, var1);
        return var3.applyAfterUseComponentSideEffects(var1, var2);
    }

    private ItemStack applyAfterUseComponentSideEffects(EntityLiving var0, ItemStack var1) {
        UseRemainder var2 = var1.get(DataComponents.USE_REMAINDER);
        UseCooldown var3 = var1.get(DataComponents.USE_COOLDOWN);
        int var4 = var1.getCount();
        ItemStack var5 = this;
        if (var2 != null) {
            var5 = var2.convertIntoRemainder(var5, var4, var0.hasInfiniteMaterials(), var0::handleExtraItemsCreatedOnUse);
        }
        if (var3 != null) {
            var3.apply(var1, var0);
        }
        return var5;
    }

    public NBTBase save(HolderLookup.a var0, NBTBase var1) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return (NBTBase)CODEC.encode((Object)this, var0.createSerializationContext(DynamicOpsNBT.INSTANCE), (Object)var1).getOrThrow();
    }

    public NBTBase save(HolderLookup.a var0) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return (NBTBase)CODEC.encodeStart(var0.createSerializationContext(DynamicOpsNBT.INSTANCE), (Object)this).getOrThrow();
    }

    public int getMaxStackSize() {
        return this.getOrDefault(DataComponents.MAX_STACK_SIZE, 1);
    }

    public boolean isStackable() {
        return this.getMaxStackSize() > 1 && (!this.isDamageableItem() || !this.isDamaged());
    }

    public boolean isDamageableItem() {
        return this.has(DataComponents.MAX_DAMAGE) && !this.has(DataComponents.UNBREAKABLE) && this.has(DataComponents.DAMAGE);
    }

    public boolean isDamaged() {
        return this.isDamageableItem() && this.getDamageValue() > 0;
    }

    public int getDamageValue() {
        return MathHelper.clamp(this.getOrDefault(DataComponents.DAMAGE, 0), 0, this.getMaxDamage());
    }

    public void setDamageValue(int var0) {
        this.set(DataComponents.DAMAGE, MathHelper.clamp(var0, 0, this.getMaxDamage()));
    }

    public int getMaxDamage() {
        return this.getOrDefault(DataComponents.MAX_DAMAGE, 0);
    }

    public boolean isBroken() {
        return this.isDamageableItem() && this.getDamageValue() >= this.getMaxDamage();
    }

    public boolean nextDamageWillBreak() {
        return this.isDamageableItem() && this.getDamageValue() >= this.getMaxDamage() - 1;
    }

    public void hurtAndBreak(int var0, WorldServer var1, @Nullable EntityPlayer var2, Consumer<Item> var3) {
        int var4 = this.processDurabilityChange(var0, var1, var2);
        if (var4 != 0) {
            this.applyDamage(this.getDamageValue() + var4, var2, var3);
        }
    }

    private int processDurabilityChange(int var0, WorldServer var1, @Nullable EntityPlayer var2) {
        if (!this.isDamageableItem()) {
            return 0;
        }
        if (var2 != null && var2.hasInfiniteMaterials()) {
            return 0;
        }
        if (var0 > 0) {
            return EnchantmentManager.processDurabilityChange(var1, this, var0);
        }
        return var0;
    }

    private void applyDamage(int var0, @Nullable EntityPlayer var1, Consumer<Item> var2) {
        if (var1 != null) {
            CriterionTriggers.ITEM_DURABILITY_CHANGED.trigger(var1, this, var0);
        }
        this.setDamageValue(var0);
        if (this.isBroken()) {
            Item var3 = this.getItem();
            this.shrink(1);
            var2.accept(var3);
        }
    }

    public void hurtWithoutBreaking(int var02, EntityHuman var1) {
        if (var1 instanceof EntityPlayer) {
            EntityPlayer var2 = (EntityPlayer)var1;
            int var3 = this.processDurabilityChange(var02, var2.serverLevel(), var2);
            if (var3 == 0) {
                return;
            }
            int var4 = Math.min(this.getDamageValue() + var3, this.getMaxDamage() - 1);
            this.applyDamage(var4, var2, var0 -> {});
        }
    }

    public void hurtAndBreak(int var0, EntityLiving var1, EnumItemSlot var22) {
        World world = var1.level();
        if (world instanceof WorldServer) {
            EntityPlayer var4;
            WorldServer var3 = (WorldServer)world;
            this.hurtAndBreak(var0, var3, var1 instanceof EntityPlayer ? (var4 = (EntityPlayer)var1) : null, var2 -> var1.onEquippedItemBroken((Item)var2, var22));
        }
    }

    public ItemStack hurtAndConvertOnBreak(int var0, IMaterial var1, EntityLiving var2, EnumItemSlot var3) {
        this.hurtAndBreak(var0, var2, var3);
        if (this.isEmpty()) {
            ItemStack var4 = this.transmuteCopyIgnoreEmpty(var1, 1);
            if (var4.isDamageableItem()) {
                var4.setDamageValue(0);
            }
            return var4;
        }
        return this;
    }

    public boolean isBarVisible() {
        return this.getItem().isBarVisible(this);
    }

    public int getBarWidth() {
        return this.getItem().getBarWidth(this);
    }

    public int getBarColor() {
        return this.getItem().getBarColor(this);
    }

    public boolean overrideStackedOnOther(Slot var0, ClickAction var1, EntityHuman var2) {
        return this.getItem().overrideStackedOnOther(this, var0, var1, var2);
    }

    public boolean overrideOtherStackedOnMe(ItemStack var0, Slot var1, ClickAction var2, EntityHuman var3, SlotAccess var4) {
        return this.getItem().overrideOtherStackedOnMe(this, var0, var1, var2, var3, var4);
    }

    public boolean hurtEnemy(EntityLiving var0, EntityLiving var1) {
        Item var2 = this.getItem();
        var2.hurtEnemy(this, var0, var1);
        if (this.has(DataComponents.WEAPON)) {
            if (var1 instanceof EntityHuman) {
                EntityHuman var3 = (EntityHuman)var1;
                var3.awardStat(StatisticList.ITEM_USED.get(var2));
            }
            return true;
        }
        return false;
    }

    public void postHurtEnemy(EntityLiving var0, EntityLiving var1) {
        this.getItem().postHurtEnemy(this, var0, var1);
        Weapon var2 = this.get(DataComponents.WEAPON);
        if (var2 != null) {
            this.hurtAndBreak(var2.itemDamagePerAttack(), var1, EnumItemSlot.MAINHAND);
        }
    }

    public void mineBlock(World var0, IBlockData var1, BlockPosition var2, EntityHuman var3) {
        Item var4 = this.getItem();
        if (var4.mineBlock(this, var0, var1, var2, var3)) {
            var3.awardStat(StatisticList.ITEM_USED.get(var4));
        }
    }

    public boolean isCorrectToolForDrops(IBlockData var0) {
        return this.getItem().isCorrectToolForDrops(this, var0);
    }

    public EnumInteractionResult interactLivingEntity(EntityHuman var0, EntityLiving var1, EnumHand var2) {
        EnumInteractionResult var4;
        Equippable var3 = this.get(DataComponents.EQUIPPABLE);
        if (var3 != null && var3.equipOnInteract() && (var4 = var3.equipOnTarget(var0, var1, this)) != EnumInteractionResult.PASS) {
            return var4;
        }
        return this.getItem().interactLivingEntity(this, var0, var1, var2);
    }

    public ItemStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ItemStack var0 = new ItemStack(this.getItem(), this.count, this.components.copy());
        var0.setPopTime(this.getPopTime());
        return var0;
    }

    public ItemStack copyWithCount(int var0) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ItemStack var1 = this.copy();
        var1.setCount(var0);
        return var1;
    }

    public ItemStack transmuteCopy(IMaterial var0) {
        return this.transmuteCopy(var0, this.getCount());
    }

    public ItemStack transmuteCopy(IMaterial var0, int var1) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return this.transmuteCopyIgnoreEmpty(var0, var1);
    }

    private ItemStack transmuteCopyIgnoreEmpty(IMaterial var0, int var1) {
        return new ItemStack(var0.asItem().builtInRegistryHolder(), var1, this.components.asPatch());
    }

    public static boolean matches(ItemStack var0, ItemStack var1) {
        if (var0 == var1) {
            return true;
        }
        if (var0.getCount() != var1.getCount()) {
            return false;
        }
        return ItemStack.isSameItemSameComponents(var0, var1);
    }

    @Deprecated
    public static boolean listMatches(List<ItemStack> var0, List<ItemStack> var1) {
        if (var0.size() != var1.size()) {
            return false;
        }
        for (int var2 = 0; var2 < var0.size(); ++var2) {
            if (ItemStack.matches(var0.get(var2), var1.get(var2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isSameItem(ItemStack var0, ItemStack var1) {
        return var0.is(var1.getItem());
    }

    public static boolean isSameItemSameComponents(ItemStack var0, ItemStack var1) {
        if (!var0.is(var1.getItem())) {
            return false;
        }
        if (var0.isEmpty() && var1.isEmpty()) {
            return true;
        }
        return Objects.equals(var0.components, var1.components);
    }

    public static MapCodec<ItemStack> lenientOptionalFieldOf(String var02) {
        return CODEC.lenientOptionalFieldOf(var02).xmap(var0 -> var0.orElse(EMPTY), var0 -> var0.isEmpty() ? Optional.empty() : Optional.of(var0));
    }

    public static int hashItemAndComponents(@Nullable ItemStack var0) {
        if (var0 != null) {
            int var1 = 31 + var0.getItem().hashCode();
            return 31 * var1 + var0.getComponents().hashCode();
        }
        return 0;
    }

    @Deprecated
    public static int hashStackList(List<ItemStack> var0) {
        int var1 = 0;
        for (ItemStack var3 : var0) {
            var1 = var1 * 31 + ItemStack.hashItemAndComponents(var3);
        }
        return var1;
    }

    public String toString() {
        return this.getCount() + " " + String.valueOf(this.getItem());
    }

    public void inventoryTick(World var0, Entity var1, @Nullable EnumItemSlot var2) {
        if (this.popTime > 0) {
            --this.popTime;
        }
        if (var0 instanceof WorldServer) {
            WorldServer var3 = (WorldServer)var0;
            this.getItem().inventoryTick(this, var3, var1, var2);
        }
    }

    public void onCraftedBy(EntityHuman var0, int var1) {
        var0.awardStat(StatisticList.ITEM_CRAFTED.get(this.getItem()), var1);
        this.getItem().onCraftedBy(this, var0);
    }

    public void onCraftedBySystem(World var0) {
        this.getItem().onCraftedPostProcess(this, var0);
    }

    public int getUseDuration(EntityLiving var0) {
        return this.getItem().getUseDuration(this, var0);
    }

    public ItemUseAnimation getUseAnimation() {
        return this.getItem().getUseAnimation(this);
    }

    public void releaseUsing(World var0, EntityLiving var1, int var2) {
        ItemStack var4;
        ItemStack var3 = this.copy();
        if (this.getItem().releaseUsing(this, var0, var1, var2) && (var4 = this.applyAfterUseComponentSideEffects(var1, var3)) != this) {
            var1.setItemInHand(var1.getUsedItemHand(), var4);
        }
    }

    public boolean useOnRelease() {
        return this.getItem().useOnRelease(this);
    }

    @Nullable
    public <T> T set(DataComponentType<T> var0, @Nullable T var1) {
        return this.components.set(var0, var1);
    }

    public <T> void copyFrom(DataComponentType<T> var0, DataComponentGetter var1) {
        this.set(var0, var1.get(var0));
    }

    @Nullable
    public <T, U> T update(DataComponentType<T> var0, T var1, U var2, BiFunction<T, U, T> var3) {
        return this.set(var0, var3.apply(this.getOrDefault(var0, var1), var2));
    }

    @Nullable
    public <T> T update(DataComponentType<T> var0, T var1, UnaryOperator<T> var2) {
        T var3 = this.getOrDefault(var0, var1);
        return this.set(var0, var2.apply(var3));
    }

    @Nullable
    public <T> T remove(DataComponentType<? extends T> var0) {
        return this.components.remove(var0);
    }

    public void applyComponentsAndValidate(DataComponentPatch var0) {
        DataComponentPatch var1 = this.components.asPatch();
        this.components.applyPatch(var0);
        Optional var2 = ItemStack.validateStrict(this).error();
        if (var2.isPresent()) {
            LOGGER.error("Failed to apply component patch '{}' to item: '{}'", (Object)var0, (Object)((DataResult.Error)var2.get()).message());
            this.components.restorePatch(var1);
            return;
        }
        this.getItem().verifyComponentsAfterLoad(this);
    }

    public void applyComponents(DataComponentPatch var0) {
        this.components.applyPatch(var0);
        this.getItem().verifyComponentsAfterLoad(this);
    }

    public void applyComponents(DataComponentMap var0) {
        this.components.setAll(var0);
        this.getItem().verifyComponentsAfterLoad(this);
    }

    public IChatBaseComponent getHoverName() {
        IChatBaseComponent var0 = this.getCustomName();
        if (var0 != null) {
            return var0;
        }
        return this.getItemName();
    }

    @Nullable
    public IChatBaseComponent getCustomName() {
        String var2;
        IChatBaseComponent var0 = this.get(DataComponents.CUSTOM_NAME);
        if (var0 != null) {
            return var0;
        }
        WrittenBookContent var1 = this.get(DataComponents.WRITTEN_BOOK_CONTENT);
        if (var1 != null && !UtilColor.isBlank(var2 = var1.title().raw())) {
            return IChatBaseComponent.literal(var2);
        }
        return null;
    }

    public IChatBaseComponent getItemName() {
        return this.getItem().getName(this);
    }

    public IChatBaseComponent getStyledHoverName() {
        IChatMutableComponent var0 = IChatBaseComponent.empty().append(this.getHoverName()).withStyle(this.getRarity().color());
        if (this.has(DataComponents.CUSTOM_NAME)) {
            var0.withStyle(EnumChatFormat.ITALIC);
        }
        return var0;
    }

    public <T extends TooltipProvider> void addToTooltip(DataComponentType<T> var0, Item.b var1, TooltipDisplay var2, Consumer<IChatBaseComponent> var3, TooltipFlag var4) {
        TooltipProvider var5 = (TooltipProvider)this.get(var0);
        if (var5 != null && var2.shows(var0)) {
            var5.addToTooltip(var1, var3, var4, this.components);
        }
    }

    public List<IChatBaseComponent> getTooltipLines(Item.b var0, @Nullable EntityHuman var1, TooltipFlag var2) {
        TooltipDisplay var3 = this.getOrDefault(DataComponents.TOOLTIP_DISPLAY, TooltipDisplay.DEFAULT);
        if (!var2.isCreative() && var3.hideTooltip()) {
            boolean var4 = this.getItem().shouldPrintOpWarning(this, var1);
            return var4 ? OP_NBT_WARNING : List.of();
        }
        ArrayList var4 = Lists.newArrayList();
        var4.add(this.getStyledHoverName());
        this.addDetailsToTooltip(var0, var3, var1, var2, var4::add);
        return var4;
    }

    public void addDetailsToTooltip(Item.b var0, TooltipDisplay var1, @Nullable EntityHuman var2, TooltipFlag var3, Consumer<IChatBaseComponent> var4) {
        int var7;
        AdventureModePredicate var6;
        Object var5;
        this.getItem().appendHoverText(this, var0, var1, var4, var3);
        this.addToTooltip(DataComponents.TROPICAL_FISH_PATTERN, var0, var1, var4, var3);
        this.addToTooltip(DataComponents.INSTRUMENT, var0, var1, var4, var3);
        this.addToTooltip(DataComponents.MAP_ID, var0, var1, var4, var3);
        this.addToTooltip(DataComponents.BEES, var0, var1, var4, var3);
        this.addToTooltip(DataComponents.CONTAINER_LOOT, var0, var1, var4, var3);
        this.addToTooltip(DataComponents.CONTAINER, var0, var1, var4, var3);
        this.addToTooltip(DataComponents.BANNER_PATTERNS, var0, var1, var4, var3);
        this.addToTooltip(DataComponents.POT_DECORATIONS, var0, var1, var4, var3);
        this.addToTooltip(DataComponents.WRITTEN_BOOK_CONTENT, var0, var1, var4, var3);
        this.addToTooltip(DataComponents.CHARGED_PROJECTILES, var0, var1, var4, var3);
        this.addToTooltip(DataComponents.FIREWORKS, var0, var1, var4, var3);
        this.addToTooltip(DataComponents.FIREWORK_EXPLOSION, var0, var1, var4, var3);
        this.addToTooltip(DataComponents.POTION_CONTENTS, var0, var1, var4, var3);
        this.addToTooltip(DataComponents.JUKEBOX_PLAYABLE, var0, var1, var4, var3);
        this.addToTooltip(DataComponents.TRIM, var0, var1, var4, var3);
        this.addToTooltip(DataComponents.STORED_ENCHANTMENTS, var0, var1, var4, var3);
        this.addToTooltip(DataComponents.ENCHANTMENTS, var0, var1, var4, var3);
        this.addToTooltip(DataComponents.DYED_COLOR, var0, var1, var4, var3);
        this.addToTooltip(DataComponents.LORE, var0, var1, var4, var3);
        this.addAttributeTooltips(var4, var1, var2);
        if (this.has(DataComponents.UNBREAKABLE) && var1.shows(DataComponents.UNBREAKABLE)) {
            var4.accept(UNBREAKABLE_TOOLTIP);
        }
        this.addToTooltip(DataComponents.OMINOUS_BOTTLE_AMPLIFIER, var0, var1, var4, var3);
        this.addToTooltip(DataComponents.SUSPICIOUS_STEW_EFFECTS, var0, var1, var4, var3);
        this.addToTooltip(DataComponents.BLOCK_STATE, var0, var1, var4, var3);
        if ((this.is(Items.SPAWNER) || this.is(Items.TRIAL_SPAWNER)) && var1.shows(DataComponents.BLOCK_ENTITY_DATA)) {
            var5 = this.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, CustomData.EMPTY);
            Spawner.appendHoverText((CustomData)var5, var4, "SpawnData");
        }
        if ((var5 = this.get(DataComponents.CAN_BREAK)) != null && var1.shows(DataComponents.CAN_BREAK)) {
            var4.accept(CommonComponents.EMPTY);
            var4.accept(AdventureModePredicate.CAN_BREAK_HEADER);
            ((AdventureModePredicate)var5).addToTooltip(var4);
        }
        if ((var6 = this.get(DataComponents.CAN_PLACE_ON)) != null && var1.shows(DataComponents.CAN_PLACE_ON)) {
            var4.accept(CommonComponents.EMPTY);
            var4.accept(AdventureModePredicate.CAN_PLACE_HEADER);
            var6.addToTooltip(var4);
        }
        if (var3.isAdvanced()) {
            if (this.isDamaged() && var1.shows(DataComponents.DAMAGE)) {
                var4.accept(IChatBaseComponent.translatable("item.durability", this.getMaxDamage() - this.getDamageValue(), this.getMaxDamage()));
            }
            var4.accept(IChatBaseComponent.literal(BuiltInRegistries.ITEM.getKey(this.getItem()).toString()).withStyle(EnumChatFormat.DARK_GRAY));
            var7 = this.components.size();
            if (var7 > 0) {
                var4.accept(IChatBaseComponent.translatable("item.components", var7).withStyle(EnumChatFormat.DARK_GRAY));
            }
        }
        if (var2 != null && !this.getItem().isEnabled(var2.level().enabledFeatures())) {
            var4.accept(DISABLED_ITEM_TOOLTIP);
        }
        if ((var7 = this.getItem().shouldPrintOpWarning(this, var2)) != 0) {
            OP_NBT_WARNING.forEach(var4);
        }
    }

    private void addAttributeTooltips(Consumer<IChatBaseComponent> var0, TooltipDisplay var1, @Nullable EntityHuman var2) {
        if (!var1.shows(DataComponents.ATTRIBUTE_MODIFIERS)) {
            return;
        }
        for (EquipmentSlotGroup var6 : EquipmentSlotGroup.values()) {
            MutableBoolean var7 = new MutableBoolean(true);
            this.forEachModifier(var6, (Holder<AttributeBase> var4, AttributeModifier var5) -> {
                if (var7.isTrue()) {
                    var0.accept(CommonComponents.EMPTY);
                    var0.accept(IChatBaseComponent.translatable("item.modifiers." + var6.getSerializedName()).withStyle(EnumChatFormat.GRAY));
                    var7.setFalse();
                }
                this.addModifierTooltip(var0, var2, (Holder<AttributeBase>)var4, (AttributeModifier)var5);
            });
        }
    }

    private void addModifierTooltip(Consumer<IChatBaseComponent> var0, @Nullable EntityHuman var1, Holder<AttributeBase> var2, AttributeModifier var3) {
        double var4 = var3.amount();
        boolean var6 = false;
        if (var1 != null) {
            if (var3.is(Item.BASE_ATTACK_DAMAGE_ID)) {
                var4 += var1.getAttributeBaseValue(GenericAttributes.ATTACK_DAMAGE);
                var6 = true;
            } else if (var3.is(Item.BASE_ATTACK_SPEED_ID)) {
                var4 += var1.getAttributeBaseValue(GenericAttributes.ATTACK_SPEED);
                var6 = true;
            }
        }
        double var7 = var3.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE || var3.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? var4 * 100.0 : (var2.is(GenericAttributes.KNOCKBACK_RESISTANCE) ? var4 * 10.0 : var4);
        if (var6) {
            var0.accept(CommonComponents.space().append(IChatBaseComponent.translatable("attribute.modifier.equals." + var3.operation().id(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(var7), IChatBaseComponent.translatable(var2.value().getDescriptionId()))).withStyle(EnumChatFormat.DARK_GREEN));
        } else if (var4 > 0.0) {
            var0.accept(IChatBaseComponent.translatable("attribute.modifier.plus." + var3.operation().id(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(var7), IChatBaseComponent.translatable(var2.value().getDescriptionId())).withStyle(var2.value().getStyle(true)));
        } else if (var4 < 0.0) {
            var0.accept(IChatBaseComponent.translatable("attribute.modifier.take." + var3.operation().id(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(-var7), IChatBaseComponent.translatable(var2.value().getDescriptionId())).withStyle(var2.value().getStyle(false)));
        }
    }

    public boolean hasFoil() {
        Boolean var0 = this.get(DataComponents.ENCHANTMENT_GLINT_OVERRIDE);
        if (var0 != null) {
            return var0;
        }
        return this.getItem().isFoil(this);
    }

    public EnumItemRarity getRarity() {
        EnumItemRarity var0 = this.getOrDefault(DataComponents.RARITY, EnumItemRarity.COMMON);
        if (!this.isEnchanted()) {
            return var0;
        }
        return switch (var0) {
            case EnumItemRarity.COMMON, EnumItemRarity.UNCOMMON -> EnumItemRarity.RARE;
            case EnumItemRarity.RARE -> EnumItemRarity.EPIC;
            default -> var0;
        };
    }

    public boolean isEnchantable() {
        if (!this.has(DataComponents.ENCHANTABLE)) {
            return false;
        }
        ItemEnchantments var0 = this.get(DataComponents.ENCHANTMENTS);
        return var0 != null && var0.isEmpty();
    }

    public void enchant(Holder<Enchantment> var0, int var1) {
        EnchantmentManager.updateEnchantments(this, var2 -> var2.upgrade(var0, var1));
    }

    public boolean isEnchanted() {
        return !this.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY).isEmpty();
    }

    public ItemEnchantments getEnchantments() {
        return this.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
    }

    public boolean isFramed() {
        return this.entityRepresentation instanceof EntityItemFrame;
    }

    public void setEntityRepresentation(@Nullable Entity var0) {
        if (!this.isEmpty()) {
            this.entityRepresentation = var0;
        }
    }

    @Nullable
    public EntityItemFrame getFrame() {
        return this.entityRepresentation instanceof EntityItemFrame ? (EntityItemFrame)this.getEntityRepresentation() : null;
    }

    @Nullable
    public Entity getEntityRepresentation() {
        return !this.isEmpty() ? this.entityRepresentation : null;
    }

    public void forEachModifier(EquipmentSlotGroup var0, BiConsumer<Holder<AttributeBase>, AttributeModifier> var1) {
        ItemAttributeModifiers var2 = this.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
        var2.forEach(var0, var1);
        EnchantmentManager.forEachModifier(this, var0, var1);
    }

    public void forEachModifier(EnumItemSlot var0, BiConsumer<Holder<AttributeBase>, AttributeModifier> var1) {
        ItemAttributeModifiers var2 = this.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
        var2.forEach(var0, var1);
        EnchantmentManager.forEachModifier(this, var0, var1);
    }

    public IChatBaseComponent getDisplayName() {
        IChatMutableComponent var02 = IChatBaseComponent.empty().append(this.getHoverName());
        if (this.has(DataComponents.CUSTOM_NAME)) {
            var02.withStyle(EnumChatFormat.ITALIC);
        }
        IChatMutableComponent var1 = ChatComponentUtils.wrapInSquareBrackets(var02);
        if (!this.isEmpty()) {
            var1.withStyle(this.getRarity().color()).withStyle(var0 -> var0.withHoverEvent(new ChatHoverable.d(this)));
        }
        return var1;
    }

    public boolean canPlaceOnBlockInAdventureMode(ShapeDetectorBlock var0) {
        AdventureModePredicate var1 = this.get(DataComponents.CAN_PLACE_ON);
        return var1 != null && var1.test(var0);
    }

    public boolean canBreakBlockInAdventureMode(ShapeDetectorBlock var0) {
        AdventureModePredicate var1 = this.get(DataComponents.CAN_BREAK);
        return var1 != null && var1.test(var0);
    }

    public int getPopTime() {
        return this.popTime;
    }

    public void setPopTime(int var0) {
        this.popTime = var0;
    }

    public int getCount() {
        return this.isEmpty() ? 0 : this.count;
    }

    public void setCount(int var0) {
        this.count = var0;
    }

    public void limitSize(int var0) {
        if (!this.isEmpty() && this.getCount() > var0) {
            this.setCount(var0);
        }
    }

    public void grow(int var0) {
        this.setCount(this.getCount() + var0);
    }

    public void shrink(int var0) {
        this.grow(-var0);
    }

    public void consume(int var0, @Nullable EntityLiving var1) {
        if (var1 == null || !var1.hasInfiniteMaterials()) {
            this.shrink(var0);
        }
    }

    public ItemStack consumeAndReturn(int var0, @Nullable EntityLiving var1) {
        ItemStack var2 = this.copyWithCount(var0);
        this.consume(var0, var1);
        return var2;
    }

    public void onUseTick(World var0, EntityLiving var1, int var2) {
        Consumable var3 = this.get(DataComponents.CONSUMABLE);
        if (var3 != null && var3.shouldEmitParticlesAndSounds(var2)) {
            var3.emitParticlesAndSounds(var1.getRandom(), var1, this, 5);
        }
        this.getItem().onUseTick(var0, var1, this, var2);
    }

    public void onDestroyed(EntityItem var0) {
        this.getItem().onDestroyed(var0);
    }

    public boolean canBeHurtBy(DamageSource var0) {
        DamageResistant var1 = this.get(DataComponents.DAMAGE_RESISTANT);
        return var1 == null || !var1.isResistantTo(var0);
    }

    public boolean isValidRepairItem(ItemStack var0) {
        Repairable var1 = this.get(DataComponents.REPAIRABLE);
        return var1 != null && var1.isValidRepairItem(var0);
    }

    public boolean canDestroyBlock(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3) {
        return this.getItem().canDestroyBlock(this, var0, var1, var2, var3);
    }
}

