/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockGrowingTop;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;

public class ItemShears
extends Item {
    public ItemShears(Item.Info var0) {
        super(var0);
    }

    public static Tool createToolProperties() {
        HolderGetter<Block> var0 = BuiltInRegistries.acquireBootstrapRegistrationLookup(BuiltInRegistries.BLOCK);
        return new Tool(List.of(Tool.a.minesAndDrops(HolderSet.direct(Blocks.COBWEB.builtInRegistryHolder()), 15.0f), Tool.a.overrideSpeed(var0.getOrThrow(TagsBlock.LEAVES), 15.0f), Tool.a.overrideSpeed(var0.getOrThrow(TagsBlock.WOOL), 5.0f), Tool.a.overrideSpeed(HolderSet.direct(Blocks.VINE.builtInRegistryHolder(), Blocks.GLOW_LICHEN.builtInRegistryHolder()), 2.0f)), 1.0f, 1, true);
    }

    @Override
    public boolean mineBlock(ItemStack var0, World var1, IBlockData var2, BlockPosition var3, EntityLiving var4) {
        Tool var5 = var0.get(DataComponents.TOOL);
        if (var5 == null) {
            return false;
        }
        if (!var1.isClientSide() && !var2.is(TagsBlock.FIRE) && var5.damagePerBlock() > 0) {
            var0.hurtAndBreak(var5.damagePerBlock(), var4, EnumItemSlot.MAINHAND);
        }
        return true;
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        BlockGrowingTop var5;
        BlockPosition var2;
        World var1 = var0.getLevel();
        IBlockData var3 = var1.getBlockState(var2 = var0.getClickedPos());
        Block var4 = var3.getBlock();
        if (var4 instanceof BlockGrowingTop && !(var5 = (BlockGrowingTop)var4).isMaxAge(var3)) {
            EntityHuman var6 = var0.getPlayer();
            ItemStack var7 = var0.getItemInHand();
            if (var6 instanceof EntityPlayer) {
                CriterionTriggers.ITEM_USED_ON_BLOCK.trigger((EntityPlayer)var6, var2, var7);
            }
            var1.playSound((Entity)var6, var2, SoundEffects.GROWING_PLANT_CROP, SoundCategory.BLOCKS, 1.0f, 1.0f);
            IBlockData var8 = var5.getMaxAgeState(var3);
            var1.setBlockAndUpdate(var2, var8);
            var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.a.of(var0.getPlayer(), var8));
            if (var6 != null) {
                var7.hurtAndBreak(1, var6, EntityLiving.getSlotForHand(var0.getHand()));
            }
            return EnumInteractionResult.SUCCESS;
        }
        return super.useOn(var0);
    }
}

