/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.critereon.CriterionConditionBlock;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;

public class AdventureModePredicate {
    public static final Codec<AdventureModePredicate> CODEC = ExtraCodecs.compactListCodec(CriterionConditionBlock.CODEC, ExtraCodecs.nonEmptyList(CriterionConditionBlock.CODEC.listOf())).xmap(AdventureModePredicate::new, var0 -> var0.predicates);
    public static final StreamCodec<RegistryFriendlyByteBuf, AdventureModePredicate> STREAM_CODEC = StreamCodec.composite(CriterionConditionBlock.STREAM_CODEC.apply(ByteBufCodecs.list()), var0 -> var0.predicates, AdventureModePredicate::new);
    public static final IChatBaseComponent CAN_BREAK_HEADER = IChatBaseComponent.translatable("item.canBreak").withStyle(EnumChatFormat.GRAY);
    public static final IChatBaseComponent CAN_PLACE_HEADER = IChatBaseComponent.translatable("item.canPlace").withStyle(EnumChatFormat.GRAY);
    private static final IChatBaseComponent UNKNOWN_USE = IChatBaseComponent.translatable("item.canUse.unknown").withStyle(EnumChatFormat.GRAY);
    private final List<CriterionConditionBlock> predicates;
    @Nullable
    private List<IChatBaseComponent> cachedTooltip;
    @Nullable
    private ShapeDetectorBlock lastCheckedBlock;
    private boolean lastResult;
    private boolean checksBlockEntity;

    public AdventureModePredicate(List<CriterionConditionBlock> var0) {
        this.predicates = var0;
    }

    private static boolean areSameBlocks(ShapeDetectorBlock var0, @Nullable ShapeDetectorBlock var1, boolean var2) {
        if (var1 == null || var0.getState() != var1.getState()) {
            return false;
        }
        if (!var2) {
            return true;
        }
        if (var0.getEntity() == null && var1.getEntity() == null) {
            return true;
        }
        if (var0.getEntity() == null || var1.getEntity() == null) {
            return false;
        }
        IRegistryCustom var3 = var0.getLevel().registryAccess();
        return Objects.equals(var0.getEntity().saveWithId(var3), var1.getEntity().saveWithId(var3));
    }

    public boolean test(ShapeDetectorBlock var0) {
        if (AdventureModePredicate.areSameBlocks(var0, this.lastCheckedBlock, this.checksBlockEntity)) {
            return this.lastResult;
        }
        this.lastCheckedBlock = var0;
        this.checksBlockEntity = false;
        for (CriterionConditionBlock var2 : this.predicates) {
            if (!var2.matches(var0)) continue;
            this.checksBlockEntity |= var2.requiresNbt();
            this.lastResult = true;
            return true;
        }
        this.lastResult = false;
        return false;
    }

    private List<IChatBaseComponent> tooltip() {
        if (this.cachedTooltip == null) {
            this.cachedTooltip = AdventureModePredicate.computeTooltip(this.predicates);
        }
        return this.cachedTooltip;
    }

    public void addToTooltip(Consumer<IChatBaseComponent> var0) {
        this.tooltip().forEach(var0);
    }

    private static List<IChatBaseComponent> computeTooltip(List<CriterionConditionBlock> var02) {
        for (CriterionConditionBlock var2 : var02) {
            if (!var2.blocks().isEmpty()) continue;
            return List.of(UNKNOWN_USE);
        }
        return var02.stream().flatMap(var0 -> var0.blocks().orElseThrow().stream()).distinct().map(var0 -> ((Block)var0.value()).getName().withStyle(EnumChatFormat.DARK_GRAY)).toList();
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof AdventureModePredicate) {
            AdventureModePredicate var1 = (AdventureModePredicate)var0;
            return this.predicates.equals(var1.predicates);
        }
        return false;
    }

    public int hashCode() {
        return this.predicates.hashCode();
    }

    public String toString() {
        return "AdventureModePredicate{predicates=" + String.valueOf(this.predicates) + "}";
    }
}

